/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.external;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFileVersionException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFolderLocalServiceUtil;
import com.liferay.document.library.repository.external.CredentialsProvider;
import com.liferay.document.library.repository.external.ExtRepository;
import com.liferay.document.library.repository.external.ExtRepositoryAdapterCache;
import com.liferay.document.library.repository.external.ExtRepositoryFileEntry;
import com.liferay.document.library.repository.external.ExtRepositoryFileVersion;
import com.liferay.document.library.repository.external.ExtRepositoryFileVersionDescriptor;
import com.liferay.document.library.repository.external.ExtRepositoryFolder;
import com.liferay.document.library.repository.external.ExtRepositoryObject;
import com.liferay.document.library.repository.external.ExtRepositoryObjectType;
import com.liferay.document.library.repository.external.ExtRepositoryQueryMapperImpl;
import com.liferay.document.library.repository.external.ExtRepositorySearchResult;
import com.liferay.document.library.repository.external.model.ExtRepositoryFileEntryAdapter;
import com.liferay.document.library.repository.external.model.ExtRepositoryFileVersionAdapter;
import com.liferay.document.library.repository.external.model.ExtRepositoryFolderAdapter;
import com.liferay.document.library.repository.external.model.ExtRepositoryObjectAdapter;
import com.liferay.document.library.repository.external.model.ExtRepositoryObjectAdapterType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchRepositoryEntryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.RepositoryEntry;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.BaseRepositoryImpl;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class ExtRepositoryAdapter
extends BaseRepositoryImpl {
    private static final Log _log = LogFactoryUtil.getLog(ExtRepositoryAdapter.class);
    private final ExtRepository _extRepository;

    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream inputStream, long size, ServiceContext serviceContext) throws PortalException {
        String fileName = null;
        fileName = Validator.isNull((String)title) ? sourceFileName : title;
        String extRepositoryFolderKey = this.getExtRepositoryObjectKey(folderId);
        ExtRepositoryFileEntry extRepositoryFileEntry = this._extRepository.addExtRepositoryFileEntry(extRepositoryFolderKey, mimeType, fileName, description, changeLog, inputStream);
        return this._toExtRepositoryObjectAdapter(ExtRepositoryObjectAdapterType.FILE, extRepositoryFileEntry);
    }

    public FileShortcut addFileShortcut(long userId, long folderId, long toFileEntryId, ServiceContext serviceContext) {
        throw new UnsupportedOperationException();
    }

    public ExtRepositoryFolderAdapter addFolder(long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        String extRepositoryParentFolderKey = this.getExtRepositoryObjectKey(parentFolderId);
        ExtRepositoryFolder extRepositoryFolder = this._extRepository.addExtRepositoryFolder(extRepositoryParentFolderKey, name, description);
        return this._toExtRepositoryObjectAdapter(ExtRepositoryObjectAdapterType.FOLDER, extRepositoryFolder);
    }

    public FileVersion cancelCheckOut(long fileEntryId) throws PortalException {
        String extRepositoryFileEntryKey = this.getExtRepositoryObjectKey(fileEntryId);
        ExtRepositoryFileVersion extRepositoryFileVersion = this._extRepository.cancelCheckOut(extRepositoryFileEntryKey);
        if (extRepositoryFileVersion != null) {
            ExtRepositoryFileEntryAdapter extRepositoryFileEntryAdapter = this.getFileEntry(fileEntryId);
            return this._toExtRepositoryFileVersionAdapter(extRepositoryFileEntryAdapter, extRepositoryFileVersion);
        }
        return null;
    }

    public void checkInFileEntry(long userId, long fileEntryId, boolean major, String changeLog, ServiceContext serviceContext) throws PortalException {
        String extRepositoryFileEntryKey = this.getExtRepositoryObjectKey(fileEntryId);
        this._extRepository.checkInExtRepositoryFileEntry(extRepositoryFileEntryKey, major, changeLog);
    }

    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        this.checkInFileEntry(userId, fileEntryId, false, "", serviceContext);
    }

    public FileEntry checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws PortalException {
        String extRepositoryFileEntryKey = this.getExtRepositoryObjectKey(fileEntryId);
        ExtRepositoryFileEntry extRepositoryFileEntry = this._extRepository.checkOutExtRepositoryFileEntry(extRepositoryFileEntryKey);
        return this._toExtRepositoryObjectAdapter(ExtRepositoryObjectAdapterType.FILE, extRepositoryFileEntry);
    }

    public FileEntry checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public FileEntry copyFileEntry(long userId, long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        String extRepositoryFileEntryKey = this.getExtRepositoryObjectKey(fileEntryId);
        ExtRepositoryFileEntry extRepositoryFileEntry = this._extRepository.getExtRepositoryObject(ExtRepositoryObjectType.FILE, extRepositoryFileEntryKey);
        String newExtRepositoryFolderKey = this.getExtRepositoryObjectKey(destFolderId);
        ExtRepositoryFileEntry copyExtRepositoryFileEntry = this._extRepository.copyExtRepositoryObject(ExtRepositoryObjectType.FILE, extRepositoryFileEntryKey, newExtRepositoryFolderKey, extRepositoryFileEntry.getTitle());
        return this._toExtRepositoryObjectAdapter(ExtRepositoryObjectAdapterType.FILE, copyExtRepositoryFileEntry);
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException {
        String extRepositoryFileEntryKey = this.getExtRepositoryObjectKey(fileEntryId);
        this._extRepository.deleteExtRepositoryObject(ExtRepositoryObjectType.FILE, extRepositoryFileEntryKey);
        ExtRepositoryAdapterCache extRepositoryAdapterCache = ExtRepositoryAdapterCache.getInstance();
        extRepositoryAdapterCache.remove(extRepositoryFileEntryKey);
    }

    public void deleteFileShortcut(long fileShortcutId) {
        throw new UnsupportedOperationException();
    }

    public void deleteFileShortcuts(long toFileEntryId) {
        throw new UnsupportedOperationException();
    }

    public void deleteFolder(long folderId) throws PortalException {
        String extRepositoryFolderKey = this.getExtRepositoryObjectKey(folderId);
        this._extRepository.deleteExtRepositoryObject(ExtRepositoryObjectType.FOLDER, extRepositoryFolderKey);
        ExtRepositoryAdapterCache extRepositoryAdapterCache = ExtRepositoryAdapterCache.getInstance();
        extRepositoryAdapterCache.remove(extRepositoryFolderKey);
    }

    public String getAuthType() {
        return this._extRepository.getAuthType();
    }

    public InputStream getContentStream(ExtRepositoryFileEntryAdapter extRepositoryFileEntryAdapter) throws PortalException {
        return this._extRepository.getContentStream(extRepositoryFileEntryAdapter.getExtRepositoryModel());
    }

    public InputStream getContentStream(ExtRepositoryFileVersionAdapter extRepositoryFileVersionAdapter) throws PortalException {
        return this._extRepository.getContentStream(extRepositoryFileVersionAdapter.getExtRepositoryModel());
    }

    public List<ExtRepositoryFileVersionAdapter> getExtRepositoryFileVersionAdapters(ExtRepositoryFileEntryAdapter extRepositoryFileEntryAdapter) throws PortalException {
        List<ExtRepositoryFileVersion> extRepositoryFileVersions = this._extRepository.getExtRepositoryFileVersions(extRepositoryFileEntryAdapter.getExtRepositoryModel());
        return this._toExtRepositoryFileVersionAdapters(extRepositoryFileEntryAdapter, extRepositoryFileVersions);
    }

    public List<FileEntry> getFileEntries(long folderId, int status, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return this.getFileEntries(folderId, start, end, obc);
    }

    public List<FileEntry> getFileEntries(long folderId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        String extRepositoryFolderKey = this.getExtRepositoryObjectKey(folderId);
        List<ExtRepositoryFileEntry> extRepositoryFileEntries = this._extRepository.getExtRepositoryObjects(ExtRepositoryObjectType.FILE, extRepositoryFolderKey);
        List<ExtRepositoryFileEntryAdapter> extRepositoryFileEntryAdapters = this._toExtRepositoryObjectAdapters(ExtRepositoryObjectAdapterType.FILE, extRepositoryFileEntries);
        return this._sublist(extRepositoryFileEntryAdapters, start, end, obc);
    }

    public List<FileEntry> getFileEntries(long folderId, long fileEntryTypeId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        if (fileEntryTypeId == 0L) {
            return this.getFileEntries(folderId, start, end, obc);
        }
        return Collections.emptyList();
    }

    public List<FileEntry> getFileEntries(long folderId, String[] mimeTypes, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        String extRepositoryFolderKey = this.getExtRepositoryObjectKey(folderId);
        List<ExtRepositoryFileEntry> extRepositoryFileEntries = this._extRepository.getExtRepositoryObjects(ExtRepositoryObjectType.FILE, extRepositoryFolderKey);
        List<ExtRepositoryFileEntryAdapter> extRepositoryFileEntryAdapters = this._toExtRepositoryObjectAdapters(ExtRepositoryObjectAdapterType.FILE, extRepositoryFileEntries);
        extRepositoryFileEntryAdapters = this._filterByMimeType(extRepositoryFileEntryAdapters, mimeTypes);
        return this._sublist(extRepositoryFileEntryAdapters, start, end, obc);
    }

    public int getFileEntriesCount(long folderId) throws PortalException {
        String extRepositoryFolderKey = this.getExtRepositoryObjectKey(folderId);
        return this._extRepository.getExtRepositoryObjectsCount(ExtRepositoryObjectType.FILE, extRepositoryFolderKey);
    }

    public int getFileEntriesCount(long folderId, int status) throws PortalException {
        return this.getFileEntriesCount(folderId);
    }

    public int getFileEntriesCount(long folderId, long fileEntryTypeId) throws PortalException {
        if (fileEntryTypeId == 0L) {
            String extRepositoryFolderKey = this.getExtRepositoryObjectKey(folderId);
            return this._extRepository.getExtRepositoryObjectsCount(ExtRepositoryObjectType.FILE, extRepositoryFolderKey);
        }
        return 0;
    }

    public int getFileEntriesCount(long folderId, String[] mimeTypes) throws PortalException {
        String extRepositoryFolderKey = this.getExtRepositoryObjectKey(folderId);
        return this._extRepository.getExtRepositoryObjectsCount(ExtRepositoryObjectType.FILE, extRepositoryFolderKey);
    }

    public ExtRepositoryFileEntryAdapter getFileEntry(long fileEntryId) throws PortalException {
        String extRepositoryFileEntryKey = this.getExtRepositoryObjectKey(fileEntryId);
        ExtRepositoryFileEntry extRepositoryObject = this._extRepository.getExtRepositoryObject(ExtRepositoryObjectType.FILE, extRepositoryFileEntryKey);
        return this._toExtRepositoryObjectAdapter(ExtRepositoryObjectAdapterType.FILE, extRepositoryObject);
    }

    public FileEntry getFileEntry(long folderId, String title) throws PortalException {
        String extRepositoryFolderKey = this.getExtRepositoryObjectKey(folderId);
        ExtRepositoryFileEntry extRepositoryObject = this._extRepository.getExtRepositoryObject(ExtRepositoryObjectType.FILE, extRepositoryFolderKey, title);
        return this._toExtRepositoryObjectAdapter(ExtRepositoryObjectAdapterType.FILE, extRepositoryObject);
    }

    public FileEntry getFileEntryByUuid(String uuid) throws PortalException {
        String extRepositoryFileEntryKey = this._getExtRepositoryObjectKey(uuid);
        ExtRepositoryFileEntry extRepositoryFileEntry = this._extRepository.getExtRepositoryObject(ExtRepositoryObjectType.FILE, extRepositoryFileEntryKey);
        return this._toExtRepositoryObjectAdapter(ExtRepositoryObjectAdapterType.FILE, extRepositoryFileEntry);
    }

    public FileShortcut getFileShortcut(long fileShortcutId) {
        throw new UnsupportedOperationException();
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        String extRepositoryFileVersionKey = this.getExtRepositoryObjectKey(fileVersionId);
        ExtRepositoryFileVersionDescriptor extRepositoryFileVersionDescriptor = this._extRepository.getExtRepositoryFileVersionDescriptor(extRepositoryFileVersionKey);
        String extRepositoryFileEntryKey = extRepositoryFileVersionDescriptor.getExtRepositoryFileEntryKey();
        String version = extRepositoryFileVersionDescriptor.getVersion();
        ExtRepositoryFileEntry extRepositoryFileEntry = this._extRepository.getExtRepositoryObject(ExtRepositoryObjectType.FILE, extRepositoryFileEntryKey);
        ExtRepositoryFileVersion extRepositoryFileVersion = this._extRepository.getExtRepositoryFileVersion(extRepositoryFileEntry, version);
        if (extRepositoryFileVersion == null) {
            return null;
        }
        ExtRepositoryFileEntryAdapter extRepositoryFileEntryAdapter = this._toExtRepositoryObjectAdapter(ExtRepositoryObjectAdapterType.FILE, extRepositoryFileEntry);
        return this._toExtRepositoryFileVersionAdapter(extRepositoryFileEntryAdapter, extRepositoryFileVersion);
    }

    public ExtRepositoryFolderAdapter getFolder(long folderId) throws PortalException {
        String extRepositoryFolderKey = this.getExtRepositoryObjectKey(folderId);
        ExtRepositoryFolder extRepositoryFolder = this._extRepository.getExtRepositoryObject(ExtRepositoryObjectType.FOLDER, extRepositoryFolderKey);
        return this._toExtRepositoryObjectAdapter(ExtRepositoryObjectAdapterType.FOLDER, extRepositoryFolder);
    }

    public ExtRepositoryFolderAdapter getFolder(long parentFolderId, String name) throws PortalException {
        String extRepositoryParentFolderKey = this.getExtRepositoryObjectKey(parentFolderId);
        ExtRepositoryFolder extRepositoryFolder = this._extRepository.getExtRepositoryObject(ExtRepositoryObjectType.FOLDER, extRepositoryParentFolderKey, name);
        return this._toExtRepositoryObjectAdapter(ExtRepositoryObjectAdapterType.FOLDER, extRepositoryFolder);
    }

    public List<Folder> getFolders(long parentFolderId, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        String extRepositoryParentFolderKey = this.getExtRepositoryObjectKey(parentFolderId);
        List<ExtRepositoryFolder> extRepositoryFolders = this._extRepository.getExtRepositoryObjects(ExtRepositoryObjectType.FOLDER, extRepositoryParentFolderKey);
        List<ExtRepositoryFolderAdapter> extRepositoryFolderAdapters = this._toExtRepositoryObjectAdapters(ExtRepositoryObjectAdapterType.FOLDER, extRepositoryFolders);
        return this._sublist(extRepositoryFolderAdapters, start, end, obc);
    }

    public List<Object> getFoldersAndFileEntries(long folderId, int start, int end, OrderByComparator<?> obc) {
        try {
            String extRepositoryFolderKey = this.getExtRepositoryObjectKey(folderId);
            List<ExtRepositoryObject> extRepositoryObjects = this._extRepository.getExtRepositoryObjects(ExtRepositoryObjectType.OBJECT, extRepositoryFolderKey);
            List<ExtRepositoryObjectAdapter<?>> extRepositoryObjectAdapters = this._toExtRepositoryObjectAdapters(ExtRepositoryObjectAdapterType.OBJECT, extRepositoryObjects);
            return this._sublist(extRepositoryObjectAdapters, start, end, obc);
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public List<Object> getFoldersAndFileEntries(long folderId, String[] mimeTypes, int start, int end, OrderByComparator<?> obc) throws PortalException {
        String extRepositoryFolderKey = this.getExtRepositoryObjectKey(folderId);
        List<ExtRepositoryObject> extRepositoryObjects = this._extRepository.getExtRepositoryObjects(ExtRepositoryObjectType.OBJECT, extRepositoryFolderKey);
        List<ExtRepositoryObjectAdapter<?>> extRepositoryObjectAdapters = this._toExtRepositoryObjectAdapters(ExtRepositoryObjectAdapterType.OBJECT, extRepositoryObjects);
        extRepositoryObjectAdapters = this._filterByMimeType(extRepositoryObjectAdapters, mimeTypes);
        return this._sublist(extRepositoryObjectAdapters, start, end, obc);
    }

    public int getFoldersAndFileEntriesCount(long folderId) {
        try {
            String extRepositoryFolderKey = this.getExtRepositoryObjectKey(folderId);
            return this._extRepository.getExtRepositoryObjectsCount(ExtRepositoryObjectType.OBJECT, extRepositoryFolderKey);
        }
        catch (PortalException pe) {
            throw new SystemException((Throwable)pe);
        }
    }

    public int getFoldersAndFileEntriesCount(long folderId, String[] mimeTypes) throws PortalException {
        List<Object> extRepositoryObjects = this.getFoldersAndFileEntries(folderId, mimeTypes, -1, -1, null);
        return extRepositoryObjects.size();
    }

    public int getFoldersCount(long parentFolderId, boolean includeMountfolders) throws PortalException {
        String extRepositoryParentFolderKey = this.getExtRepositoryObjectKey(parentFolderId);
        return this._extRepository.getExtRepositoryObjectsCount(ExtRepositoryObjectType.FOLDER, extRepositoryParentFolderKey);
    }

    public int getFoldersFileEntriesCount(List<Long> folderIds, int status) throws PortalException {
        int count = 0;
        for (long folderId : folderIds) {
            String extRepositoryFolderKey = this.getExtRepositoryObjectKey(folderId);
            count += this._extRepository.getExtRepositoryObjectsCount(ExtRepositoryObjectType.FILE, extRepositoryFolderKey);
        }
        return count;
    }

    public String getLiferayLogin(String extRepositoryUserName) {
        return this._extRepository.getLiferayLogin(extRepositoryUserName);
    }

    public List<Folder> getMountFolders(long parentFolderId, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        return Collections.emptyList();
    }

    public int getMountFoldersCount(long parentFolderId) throws PortalException {
        return 0;
    }

    public ExtRepositoryFolderAdapter getParentFolder(ExtRepositoryObjectAdapter<?> extRepositoryObjectAdapter) throws PortalException {
        ExtRepositoryFolder parentFolder = this._extRepository.getExtRepositoryParentFolder(extRepositoryObjectAdapter.getExtRepositoryModel());
        return this._toExtRepositoryObjectAdapter(ExtRepositoryObjectAdapterType.FOLDER, parentFolder);
    }

    public void getSubfolderIds(List<Long> folderIds, long folderId) throws PortalException {
        folderIds.addAll(this.getSubfolderIds(folderId, true));
    }

    public List<Long> getSubfolderIds(long folderId, boolean recurse) throws PortalException {
        String extRepositoryFolderKey = this.getExtRepositoryObjectKey(folderId);
        List<String> extRepositorySubfolderKeys = this._extRepository.getSubfolderKeys(extRepositoryFolderKey, recurse);
        ArrayList<Long> subfolderIds = new ArrayList<Long>();
        for (String extRepositorySubfolderKey : extRepositorySubfolderKeys) {
            RepositoryEntry repositoryEntry = this.getRepositoryEntry(extRepositorySubfolderKey);
            subfolderIds.add(repositoryEntry.getRepositoryEntryId());
        }
        return subfolderIds;
    }

    public String[] getSupportedConfigurations() {
        return this._extRepository.getSupportedConfigurations();
    }

    public String[][] getSupportedParameters() {
        return this._extRepository.getSupportedParameters();
    }

    public void initRepository() throws PortalException {
        try {
            CredentialsProvider credentialsProvider = new CredentialsProvider(){

                @Override
                public String getLogin() {
                    return ExtRepositoryAdapter.this._getLogin();
                }

                @Override
                public String getPassword() {
                    return ExtRepositoryAdapter.this._getPassword();
                }
            };
            this._extRepository.initRepository(this.getTypeSettingsProperties(), credentialsProvider);
        }
        catch (PortalException | SystemException e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to initialize repository " + this._extRepository), e);
            }
            throw e;
        }
    }

    public Lock lockFolder(long folderId) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public Lock lockFolder(long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        String extRepositoryFileEntryKey = this.getExtRepositoryObjectKey(fileEntryId);
        ExtRepositoryFileEntry extRepositoryFileEntry = this._extRepository.getExtRepositoryObject(ExtRepositoryObjectType.FILE, extRepositoryFileEntryKey);
        String extRepositoryNewFolderKey = this.getExtRepositoryObjectKey(newFolderId);
        ExtRepositoryFileEntry moveExtRepositoryFileEntry = this._extRepository.moveExtRepositoryObject(ExtRepositoryObjectType.FILE, extRepositoryFileEntryKey, extRepositoryNewFolderKey, extRepositoryFileEntry.getTitle());
        return this._toExtRepositoryObjectAdapter(ExtRepositoryObjectAdapterType.FILE, moveExtRepositoryFileEntry);
    }

    public ExtRepositoryFolderAdapter moveFolder(long userId, long folderId, long newParentFolderId, ServiceContext serviceContext) throws PortalException {
        String extRepositoryFolderKey = this.getExtRepositoryObjectKey(folderId);
        ExtRepositoryFolder extRepositoryFolder = this._extRepository.getExtRepositoryObject(ExtRepositoryObjectType.FOLDER, extRepositoryFolderKey);
        String extRepositoryNewParentFolderKey = this.getExtRepositoryObjectKey(newParentFolderId);
        ExtRepositoryFolder moveExtRepositoryFolder = this._extRepository.moveExtRepositoryObject(ExtRepositoryObjectType.FOLDER, extRepositoryFolderKey, extRepositoryNewParentFolderKey, extRepositoryFolder.getName());
        return this._toExtRepositoryObjectAdapter(ExtRepositoryObjectAdapterType.FOLDER, moveExtRepositoryFolder);
    }

    public Lock refreshFileEntryLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public Lock refreshFolderLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        String extRepositoryFileEntryKey = this.getExtRepositoryObjectKey(fileEntryId);
        ExtRepositoryFileEntry extRepositoryFileEntry = this._extRepository.getExtRepositoryObject(ExtRepositoryObjectType.FILE, extRepositoryFileEntryKey);
        ExtRepositoryFileVersion extRepositoryFileVersion = null;
        List<ExtRepositoryFileVersion> extRepositoryFileVersions = this._extRepository.getExtRepositoryFileVersions(extRepositoryFileEntry);
        for (ExtRepositoryFileVersion curExtRepositoryFileVersion : extRepositoryFileVersions) {
            String curVersion = curExtRepositoryFileVersion.getVersion();
            if (!curVersion.equals(version)) continue;
            extRepositoryFileVersion = curExtRepositoryFileVersion;
            break;
        }
        if (extRepositoryFileVersion != null) {
            InputStream inputStream = this._extRepository.getContentStream(extRepositoryFileVersion);
            boolean needsCheckIn = false;
            if (!this.isCheckedOut(extRepositoryFileEntry)) {
                try {
                    this._extRepository.checkOutExtRepositoryFileEntry(extRepositoryFileEntryKey);
                    needsCheckIn = true;
                }
                catch (UnsupportedOperationException curVersion) {
                    // empty catch block
                }
            }
            this._extRepository.updateExtRepositoryFileEntry(extRepositoryFileEntryKey, extRepositoryFileVersion.getMimeType(), inputStream);
            String changeLog = LanguageUtil.format((Locale)serviceContext.getLocale(), (String)"reverted-to-x", (Object)version, (boolean)false);
            if (needsCheckIn) {
                try {
                    this._extRepository.checkInExtRepositoryFileEntry(extRepositoryFileEntryKey, true, changeLog);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        } else {
            throw new NoSuchFileVersionException(StringBundler.concat((String[])new String[]{"No file version with {extRepositoryModelKey=", extRepositoryFileEntry.getExtRepositoryModelKey(), ", version: ", version, "}"}));
        }
    }

    public Hits search(long creatorUserId, int status, int start, int end) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public Hits search(long creatorUserId, long folderId, String[] mimeTypes, int status, int start, int end) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public Hits search(SearchContext searchContext, Query query) throws SearchException {
        long startTime = System.currentTimeMillis();
        List<ExtRepositorySearchResult<?>> extRepositorySearchResults = null;
        try {
            extRepositorySearchResults = this._extRepository.search(searchContext, query, new ExtRepositoryQueryMapperImpl(this));
        }
        catch (PortalException | SystemException e) {
            throw new SearchException("Unable to perform search", e);
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        ArrayList<DocumentImpl> documents = new ArrayList<DocumentImpl>();
        ArrayList<String> snippets = new ArrayList<String>();
        ArrayList<Float> scores = new ArrayList<Float>();
        int total = 0;
        for (ExtRepositorySearchResult<?> extRepositorySearchResult : extRepositorySearchResults) {
            try {
                ExtRepositoryObjectAdapter<?> extRepositoryEntryAdapter = this._toExtRepositoryObjectAdapter(ExtRepositoryObjectAdapterType.OBJECT, (ExtRepositoryObject)extRepositorySearchResult.getObject());
                DocumentImpl document = new DocumentImpl();
                document.addKeyword("entryClassName", extRepositoryEntryAdapter.getModelClassName());
                document.addKeyword("entryClassPK", extRepositoryEntryAdapter.getPrimaryKey());
                document.addKeyword("title", extRepositoryEntryAdapter.getName());
                documents.add(document);
                if (queryConfig.isScoreEnabled()) {
                    scores.add(Float.valueOf(extRepositorySearchResult.getScore()));
                } else {
                    scores.add(Float.valueOf(1.0f));
                }
                snippets.add(extRepositorySearchResult.getSnippet());
                ++total;
            }
            catch (PortalException | SystemException e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)"Invalid entry returned from search", e);
            }
        }
        float searchTime = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
        HitsImpl hits = new HitsImpl();
        hits.setDocs(documents.toArray(new Document[documents.size()]));
        hits.setLength(total);
        hits.setQueryTerms(new String[0]);
        hits.setScores(ArrayUtil.toFloatArray(scores));
        hits.setSearchTime(searchTime);
        hits.setSnippets(snippets.toArray(new String[snippets.size()]));
        hits.setStart(startTime);
        return hits;
    }

    public void unlockFolder(long folderId, String lockUuid) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream inputStream, long size, ServiceContext serviceContext) throws PortalException {
        boolean needsCheckIn = false;
        String extRepositoryFileEntryKey = this.getExtRepositoryObjectKey(fileEntryId);
        try {
            ExtRepositoryFileEntry extRepositoryFileEntry = this._extRepository.getExtRepositoryObject(ExtRepositoryObjectType.FILE, extRepositoryFileEntryKey);
            if (!this.isCheckedOut(extRepositoryFileEntry)) {
                this._extRepository.checkOutExtRepositoryFileEntry(extRepositoryFileEntryKey);
                needsCheckIn = true;
            }
            if (inputStream != null) {
                extRepositoryFileEntry = this._extRepository.updateExtRepositoryFileEntry(extRepositoryFileEntryKey, mimeType, inputStream);
            }
            if (!title.equals(extRepositoryFileEntry.getTitle())) {
                ExtRepositoryFolder folder = this._extRepository.getExtRepositoryParentFolder(extRepositoryFileEntry);
                extRepositoryFileEntry = this._extRepository.moveExtRepositoryObject(ExtRepositoryObjectType.FILE, extRepositoryFileEntryKey, folder.getExtRepositoryModelKey(), title);
                ExtRepositoryAdapterCache extRepositoryAdapterCache = ExtRepositoryAdapterCache.getInstance();
                extRepositoryAdapterCache.clear();
                this.repositoryEntryLocalService.updateRepositoryEntry(fileEntryId, extRepositoryFileEntry.getExtRepositoryModelKey());
            }
            if (needsCheckIn) {
                this._extRepository.checkInExtRepositoryFileEntry(extRepositoryFileEntry.getExtRepositoryModelKey(), majorVersion, changeLog);
                needsCheckIn = false;
            }
            return this._toExtRepositoryObjectAdapter(ExtRepositoryObjectAdapterType.FILE, extRepositoryFileEntry);
        }
        catch (PortalException | SystemException e) {
            if (needsCheckIn) {
                this._extRepository.cancelCheckOut(extRepositoryFileEntryKey);
            }
            throw e;
        }
    }

    public FileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) {
        throw new UnsupportedOperationException();
    }

    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) {
        throw new UnsupportedOperationException();
    }

    public ExtRepositoryFolderAdapter updateFolder(long folderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        String extRepositoryFolderKey = this.getExtRepositoryObjectKey(folderId);
        ExtRepositoryFolder extRepositoryFolder = this._extRepository.getExtRepositoryObject(ExtRepositoryObjectType.FOLDER, extRepositoryFolderKey);
        ExtRepositoryFolder parentExtRepositoryFolder = this._extRepository.getExtRepositoryParentFolder(extRepositoryFolder);
        ExtRepositoryFolder newExtRepositoryFolder = this._extRepository.moveExtRepositoryObject(ExtRepositoryObjectType.FOLDER, extRepositoryFolderKey, parentExtRepositoryFolder.getExtRepositoryModelKey(), name);
        ExtRepositoryAdapterCache extRepositoryAdapterCache = ExtRepositoryAdapterCache.getInstance();
        extRepositoryAdapterCache.remove(extRepositoryFolderKey);
        return this._toExtRepositoryObjectAdapter(ExtRepositoryObjectAdapterType.FOLDER, newExtRepositoryFolder);
    }

    public boolean verifyFileEntryCheckOut(long fileEntryId, String lockUuid) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public boolean verifyInheritableLock(long folderId, String lockUuid) throws PortalException {
        throw new UnsupportedOperationException();
    }

    protected ExtRepositoryAdapter(ExtRepository extRepository) {
        if (extRepository == null) {
            extRepository = (ExtRepository)((Object)this);
        }
        this._extRepository = extRepository;
    }

    protected String getExtRepositoryObjectKey(long repositoryEntryId) throws PortalException {
        RepositoryEntry repositoryEntry = this.repositoryEntryLocalService.fetchRepositoryEntry(repositoryEntryId);
        if (repositoryEntry != null) {
            return repositoryEntry.getMappedId();
        }
        DLFolder rootMountDLFolder = DLFolderLocalServiceUtil.getDLFolder((long)repositoryEntryId);
        repositoryEntry = this._getRootRepositoryEntry(rootMountDLFolder);
        return repositoryEntry.getMappedId();
    }

    protected boolean isCheckedOut(ExtRepositoryFileEntry extRepositoryFileEntry) {
        String checkedOutBy = extRepositoryFileEntry.getCheckedOutBy();
        return !Validator.isNull((String)checkedOutBy);
    }

    private void _checkAssetEntry(ExtRepositoryFileEntryAdapter extRepositoryFileEntryAdapter) throws PortalException {
        this.dlAppHelperLocalService.checkAssetEntry(PrincipalThreadLocal.getUserId(), (FileEntry)extRepositoryFileEntryAdapter, extRepositoryFileEntryAdapter.getFileVersion());
    }

    private User _fetchDefaultUser() {
        try {
            return this.userLocalService.getDefaultUser(this.getCompanyId());
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to get default user for company " + this.getCompanyId()), (Throwable)pe);
            return null;
        }
    }

    private <T extends ExtRepositoryObjectAdapter<?>> List<T> _filterByMimeType(List<T> extRepositoryObjects, String[] mimeTypes) {
        if (ArrayUtil.isEmpty((Object[])mimeTypes)) {
            return extRepositoryObjects;
        }
        HashSet<String> allowedMimeTypes = new HashSet<String>(Arrays.asList(mimeTypes));
        ArrayList<ExtRepositoryObjectAdapter> filteredExtRepositoryObjects = new ArrayList<ExtRepositoryObjectAdapter>();
        for (ExtRepositoryObjectAdapter extRepositoryObject : extRepositoryObjects) {
            ExtRepositoryFileEntryAdapter extRepositoryFileEntryAdapter;
            if (!(extRepositoryObject instanceof ExtRepositoryFileEntryAdapter) || !allowedMimeTypes.contains((extRepositoryFileEntryAdapter = (ExtRepositoryFileEntryAdapter)extRepositoryObject).getMimeType())) continue;
            filteredExtRepositoryObjects.add(extRepositoryObject);
        }
        return filteredExtRepositoryObjects;
    }

    private void _forceGetFileVersions(ExtRepositoryFileEntryAdapter extRepositoryFileEntryAdapter) {
        extRepositoryFileEntryAdapter.getFileVersions(-1);
    }

    private String _getExtRepositoryObjectKey(String uuid) throws PortalException {
        RepositoryEntry repositoryEntry = this.repositoryEntryLocalService.fetchRepositoryEntryByUuidAndGroupId(uuid, this.getGroupId());
        if (repositoryEntry == null) {
            throw new NoSuchRepositoryEntryException("No repository entry exits with UUID " + uuid);
        }
        return repositoryEntry.getMappedId();
    }

    private String _getLogin() {
        String login = PrincipalThreadLocal.getName();
        if (Validator.isNull((String)login) || this._isDefaultUser(login)) {
            return PropsUtil.get((String)"dl.repository.guest.username");
        }
        try {
            String authType = this.getAuthType();
            if (!authType.equals("userId")) {
                User user = this.userLocalService.getUser(GetterUtil.getLong((String)login));
                if (authType.equals("emailAddress")) {
                    login = user.getEmailAddress();
                } else if (authType.equals("screenName")) {
                    login = user.getScreenName();
                }
            }
        }
        catch (PortalException | SystemException e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get login to connect to external repository " + this._extRepository), e);
            }
            login = null;
        }
        return login;
    }

    private String _getPassword() {
        String login = PrincipalThreadLocal.getName();
        if (Validator.isNull((String)login) || this._isDefaultUser(login)) {
            return PropsUtil.get((String)"dl.repository.guest.password");
        }
        return PrincipalThreadLocal.getPassword();
    }

    private RepositoryEntry _getRootRepositoryEntry(DLFolder rootMountFolder) throws PortalException {
        return this.repositoryEntryLocalService.getRepositoryEntry(rootMountFolder.getUserId(), this.getGroupId(), this.getRepositoryId(), this._extRepository.getRootFolderKey());
    }

    private boolean _isDefaultUser(String login) {
        User defaultUser = this._fetchDefaultUser();
        return defaultUser != null && login.equals(defaultUser.getScreenName());
    }

    private <T, V extends T> List<T> _sublist(List<V> list, int start, int end, OrderByComparator<T> obc) {
        if (obc != null) {
            list = ListUtil.sort(list, obc);
        }
        return ListUtil.toList((List)ListUtil.subList((List)list, (int)start, (int)end));
    }

    private ExtRepositoryFileVersionAdapter _toExtRepositoryFileVersionAdapter(ExtRepositoryFileEntryAdapter extRepositoryFileEntryAdapter, ExtRepositoryFileVersion extRepositoryFileVersion) throws PortalException {
        String extRepositoryModelKey;
        ExtRepositoryAdapterCache extRepositoryAdapterCache = ExtRepositoryAdapterCache.getInstance();
        ExtRepositoryFileVersionAdapter extRepositoryVersionAdapter = (ExtRepositoryFileVersionAdapter)extRepositoryAdapterCache.get(extRepositoryModelKey = extRepositoryFileVersion.getExtRepositoryModelKey());
        if (extRepositoryVersionAdapter == null) {
            RepositoryEntry repositoryEntry = this.getRepositoryEntry(extRepositoryModelKey);
            extRepositoryVersionAdapter = new ExtRepositoryFileVersionAdapter(this, repositoryEntry.getRepositoryEntryId(), repositoryEntry.getUuid(), extRepositoryFileEntryAdapter, extRepositoryFileVersion);
            extRepositoryAdapterCache.put(extRepositoryVersionAdapter);
        }
        return extRepositoryVersionAdapter;
    }

    private List<ExtRepositoryFileVersionAdapter> _toExtRepositoryFileVersionAdapters(ExtRepositoryFileEntryAdapter extRepositoryFileEntryAdapter, List<ExtRepositoryFileVersion> extRepositoryFileVersions) throws PortalException {
        ArrayList<ExtRepositoryFileVersionAdapter> extRepositoryFileVersionAdapters = new ArrayList<ExtRepositoryFileVersionAdapter>();
        for (ExtRepositoryFileVersion extRepositoryFileVersion : extRepositoryFileVersions) {
            ExtRepositoryFileVersionAdapter extRepositoryFileVersionAdapter = this._toExtRepositoryFileVersionAdapter(extRepositoryFileEntryAdapter, extRepositoryFileVersion);
            extRepositoryFileVersionAdapters.add(extRepositoryFileVersionAdapter);
        }
        return extRepositoryFileVersionAdapters;
    }

    private <T extends ExtRepositoryObjectAdapter<?>> T _toExtRepositoryObjectAdapter(ExtRepositoryObjectAdapterType<T> extRepositoryObjectAdapterType, ExtRepositoryObject extRepositoryObject) throws PortalException {
        String extRepositoryModelKey;
        ExtRepositoryAdapterCache extRepositoryAdapterCache = ExtRepositoryAdapterCache.getInstance();
        ExtRepositoryObjectAdapter extRepositoryObjectAdapter = (ExtRepositoryObjectAdapter)extRepositoryAdapterCache.get(extRepositoryModelKey = extRepositoryObject.getExtRepositoryModelKey());
        if (extRepositoryObjectAdapter == null) {
            RepositoryEntry repositoryEntry = this.getRepositoryEntry(extRepositoryModelKey);
            if (extRepositoryObject instanceof ExtRepositoryFolder) {
                ExtRepositoryFolder extRepositoryFolder = (ExtRepositoryFolder)extRepositoryObject;
                extRepositoryObjectAdapter = new ExtRepositoryFolderAdapter(this, repositoryEntry.getRepositoryEntryId(), repositoryEntry.getUuid(), extRepositoryFolder);
            } else {
                ExtRepositoryFileEntry extRepositoryFileEntry = (ExtRepositoryFileEntry)extRepositoryObject;
                extRepositoryObjectAdapter = new ExtRepositoryFileEntryAdapter(this, repositoryEntry.getRepositoryEntryId(), repositoryEntry.getUuid(), extRepositoryFileEntry);
                this._forceGetFileVersions((ExtRepositoryFileEntryAdapter)extRepositoryObjectAdapter);
                this._checkAssetEntry((ExtRepositoryFileEntryAdapter)extRepositoryObjectAdapter);
            }
            extRepositoryAdapterCache.put(extRepositoryObjectAdapter);
        }
        if (extRepositoryObjectAdapterType == ExtRepositoryObjectAdapterType.FILE) {
            if (!(extRepositoryObjectAdapter instanceof ExtRepositoryFileEntryAdapter)) {
                throw new NoSuchFileEntryException("External repository object is not a file " + extRepositoryObject);
            }
        } else if (extRepositoryObjectAdapterType == ExtRepositoryObjectAdapterType.FOLDER) {
            if (!(extRepositoryObjectAdapter instanceof ExtRepositoryFolderAdapter)) {
                throw new NoSuchFolderException("External repository object is not a folder " + extRepositoryObject);
            }
        } else if (extRepositoryObjectAdapterType != ExtRepositoryObjectAdapterType.OBJECT) {
            throw new IllegalArgumentException("Unsupported repository object type " + extRepositoryObjectAdapterType);
        }
        return (T)extRepositoryObjectAdapter;
    }

    private <T extends ExtRepositoryObjectAdapter<?>> List<T> _toExtRepositoryObjectAdapters(ExtRepositoryObjectAdapterType<T> extRepositoryObjectAdapterType, List<? extends ExtRepositoryObject> extRepositoryObjects) throws PortalException {
        ArrayList<T> extRepositoryObjectAdapters = new ArrayList<T>();
        for (ExtRepositoryObject extRepositoryObject : extRepositoryObjects) {
            extRepositoryObjectAdapters.add(this._toExtRepositoryObjectAdapter(extRepositoryObjectAdapterType, extRepositoryObject));
        }
        return extRepositoryObjectAdapters;
    }
}

