/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.external.model;

import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.repository.external.ExtRepositoryAdapter;
import com.liferay.document.library.repository.external.ExtRepositoryObject;
import com.liferay.document.library.repository.external.model.ExtRepositoryFolderAdapter;
import com.liferay.document.library.repository.external.model.ExtRepositoryModelAdapter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ExtRepositoryObjectAdapter<T>
extends ExtRepositoryModelAdapter<T> {
    private static final Map<String, Boolean> _unsupportedActionIds = new HashMap<String, Boolean>();
    private final ExtRepositoryObject _extRepositoryObject;

    public boolean containsPermission(PermissionChecker permissionChecker, String actionId) throws PortalException {
        if (_unsupportedActionIds.containsKey(actionId)) {
            return _unsupportedActionIds.get(actionId);
        }
        try {
            ExtRepositoryObject.ExtRepositoryPermission extRepositoryPermission = ExtRepositoryObject.ExtRepositoryPermission.valueOf(actionId);
            return this._extRepositoryObject.containsPermission(extRepositoryPermission);
        }
        catch (IllegalArgumentException iae) {
            throw new RepositoryException("Unexpected permission action " + actionId, (Throwable)iae);
        }
    }

    public List<Long> getAncestorFolderIds() throws PortalException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        Folder folder = this.getParentFolder();
        while (!folder.isRoot()) {
            folderIds.add(folder.getFolderId());
            folder = folder.getParentFolder();
        }
        return folderIds;
    }

    public List<Folder> getAncestors() throws PortalException {
        Folder folder;
        ArrayList<Folder> folders = new ArrayList<Folder>();
        for (folder = this.getParentFolder(); folder != null && !folder.isRoot(); folder = folder.getParentFolder()) {
            folders.add(folder);
        }
        if (folder != null) {
            folders.add(folder);
        }
        return folders;
    }

    public String getExtension() {
        return this._extRepositoryObject.getExtension();
    }

    @Override
    public ExtRepositoryObject getExtRepositoryModel() {
        return this._extRepositoryObject;
    }

    public Date getModifiedDate() {
        return this._extRepositoryObject.getModifiedDate();
    }

    public abstract String getName();

    public Folder getParentFolder() throws PortalException {
        ExtRepositoryAdapter extRepositoryAdapter = this.getRepository();
        ExtRepositoryFolderAdapter parentFolder = extRepositoryAdapter.getParentFolder(this);
        if (parentFolder.isRoot()) {
            return DLAppLocalServiceUtil.getMountFolder((long)this.getRepositoryId());
        }
        return parentFolder;
    }

    public boolean isInTrash() {
        return false;
    }

    public boolean isInTrashContainer() {
        return false;
    }

    public boolean isSupportsMetadata() {
        return false;
    }

    public boolean isSupportsSocial() {
        return false;
    }

    protected ExtRepositoryObjectAdapter(ExtRepositoryAdapter extRepositoryAdapter, long extRepositoryObjectId, String uuid, ExtRepositoryObject extRepositoryObject) {
        super(extRepositoryAdapter, extRepositoryObjectId, uuid, extRepositoryObject);
        this._extRepositoryObject = extRepositoryObject;
    }

    static {
        _unsupportedActionIds.put("OVERRIDE_CHECKOUT", Boolean.FALSE);
        _unsupportedActionIds.put("SUBSCRIBE", Boolean.FALSE);
    }
}

