/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.cmis.internal;

import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.DuplicateFolderNameException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFileVersionException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelCreateDateComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelModifiedDateComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelSizeComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelTitleComparator;
import com.liferay.document.library.repository.cmis.BaseCmisRepository;
import com.liferay.document.library.repository.cmis.CMISRepositoryHandler;
import com.liferay.document.library.repository.cmis.configuration.CMISRepositoryConfiguration;
import com.liferay.document.library.repository.cmis.internal.CMISModelCache;
import com.liferay.document.library.repository.cmis.internal.CMISRepositoryDetector;
import com.liferay.document.library.repository.cmis.internal.CMISSessionCache;
import com.liferay.document.library.repository.cmis.internal.SessionImpl;
import com.liferay.document.library.repository.cmis.internal.model.CMISFileEntry;
import com.liferay.document.library.repository.cmis.internal.model.CMISFileVersion;
import com.liferay.document.library.repository.cmis.internal.model.CMISFolder;
import com.liferay.document.library.repository.cmis.search.CMISSearchQueryBuilder;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchRepositoryEntryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.RepositoryEntry;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.DocumentHelper;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.RepositoryEntryLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.Base64;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;

public class CMISRepository
extends BaseCmisRepository {
    private static final int _DELETE_DEEP = -1;
    private static final int _DELETE_NONE = 0;
    private static final Log _log = LogFactoryUtil.getLog(CMISRepository.class);
    private static final CMISModelCache _cmisModelCache = new CMISModelCache();
    private final CMISRepositoryConfiguration _cmisRepositoryConfiguration;
    private CMISRepositoryDetector _cmisRepositoryDetector;
    private final CMISRepositoryHandler _cmisRepositoryHandler;
    private final CMISSearchQueryBuilder _cmisSearchQueryBuilder;
    private final CMISSessionCache _cmisSessionCache;
    private final LockManager _lockManager;
    private String _sessionKey;

    public CMISRepository(CMISRepositoryConfiguration cmisRepositoryConfiguration, CMISRepositoryHandler cmisRepositoryHandler, CMISSearchQueryBuilder cmisSearchQueryBuilder, CMISSessionCache cmisSessionCache, LockManager lockManager) {
        this._cmisRepositoryConfiguration = cmisRepositoryConfiguration;
        this._cmisRepositoryHandler = cmisRepositoryHandler;
        this._cmisSearchQueryBuilder = cmisSearchQueryBuilder;
        this._cmisSessionCache = cmisSessionCache;
        this._lockManager = lockManager;
    }

    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        if (Validator.isNull((String)title)) {
            if (size == 0L) {
                throw new FileNameException("Title is null");
            }
            title = sourceFileName;
        }
        try {
            Session session = this.getSession();
            this.validateTitle(session, folderId, title);
            org.apache.chemistry.opencmis.client.api.Folder cmisFolder = this.getCmisFolder(session, folderId);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("cmis:name", title);
            properties.put("cmis:objectTypeId", BaseTypeId.CMIS_DOCUMENT.value());
            ContentStreamImpl contentStream = new ContentStreamImpl(title, BigInteger.valueOf(size), mimeType, is);
            Document document = null;
            if (this._cmisRepositoryDetector.isNuxeo5_5OrHigher()) {
                document = cmisFolder.createDocument(properties, (ContentStream)contentStream, VersioningState.NONE);
                document.checkIn(true, Collections.emptyMap(), null, "");
            } else {
                document = cmisFolder.createDocument(properties, (ContentStream)contentStream, null);
            }
            return this.toFileEntry(document);
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public FileShortcut addFileShortcut(long userId, long folderId, long toFileEntryId, ServiceContext serviceContext) {
        throw new UnsupportedOperationException();
    }

    public Folder addFolder(long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        try {
            Session session = this.getSession();
            this.validateTitle(session, parentFolderId, name);
            org.apache.chemistry.opencmis.client.api.Folder cmisFolder = this.getCmisFolder(session, parentFolderId);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("cmis:name", name);
            properties.put("cmis:objectTypeId", BaseTypeId.CMIS_FOLDER.value());
            return this.toFolder(cmisFolder.createFolder(properties));
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public FileVersion cancelCheckOut(long fileEntryId) throws PortalException {
        Document draftDocument = null;
        try {
            Session session = this.getSession();
            String versionSeriesId = this.toFileEntryId(fileEntryId);
            Document document = (Document)session.getObject(versionSeriesId);
            document.refresh();
            String versionSeriesCheckedOutId = document.getVersionSeriesCheckedOutId();
            if (Validator.isNotNull((String)versionSeriesCheckedOutId)) {
                draftDocument = (Document)session.getObject(versionSeriesCheckedOutId);
                draftDocument.cancelCheckOut();
                document = (Document)session.getObject(versionSeriesId);
                document.refresh();
            }
        }
        catch (Exception e) {
            _log.error((Object)("Unable to cancel checkout for file entry with {fileEntryId=" + fileEntryId + "}"), (Throwable)e);
        }
        if (draftDocument != null) {
            return this.toFileVersion(null, draftDocument);
        }
        return null;
    }

    public void checkInFileEntry(long userId, long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) {
        try {
            this.clearManualCheckInRequired(fileEntryId, serviceContext);
            Session session = this.getSession();
            String versionSeriesId = this.toFileEntryId(fileEntryId);
            Document document = (Document)session.getObject(versionSeriesId);
            document.refresh();
            String versionSeriesCheckedOutId = document.getVersionSeriesCheckedOutId();
            if (Validator.isNotNull((String)versionSeriesCheckedOutId)) {
                boolean major = false;
                if (!this.isSupportsMinorVersions() || dlVersionNumberIncrease == DLVersionNumberIncrease.MAJOR) {
                    major = true;
                }
                document = (Document)session.getObject(versionSeriesCheckedOutId);
                document.checkIn(major, null, null, changeLog);
                document = (Document)session.getObject(versionSeriesId);
                document.refresh();
            }
        }
        catch (Exception e) {
            _log.error((Object)("Unable to check in file entry with {fileEntryId=" + fileEntryId + "}"), (Throwable)e);
        }
    }

    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) {
        this.checkInFileEntry(userId, fileEntryId, DLVersionNumberIncrease.MINOR, "", serviceContext);
    }

    public FileEntry checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws PortalException {
        try {
            this.setManualCheckInRequired(fileEntryId, serviceContext);
            Session session = this.getSession();
            String versionSeriesId = this.toFileEntryId(fileEntryId);
            Document document = (Document)session.getObject(versionSeriesId);
            document.refresh();
            document.checkOut();
            document = (Document)session.getObject(versionSeriesId);
            document.refresh();
        }
        catch (Exception e) {
            _log.error((Object)("Unable checkout file entry with {fileEntryId=" + fileEntryId + "}"), (Throwable)e);
        }
        return this.getFileEntry(fileEntryId);
    }

    public FileEntry checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) {
        throw new UnsupportedOperationException();
    }

    public FileEntry copyFileEntry(long userId, long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        try {
            Session session = this.getSession();
            Document document = this.getDocument(session, fileEntryId);
            this.validateTitle(session, destFolderId, document.getName());
            String destFolderObjectId = this.toFolderId(session, destFolderId);
            Document newDocument = document.copy((ObjectId)new ObjectIdImpl(destFolderObjectId));
            return this.toFileEntry(newDocument);
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFolderException("No CMIS folder with {folderId=" + destFolderId + "}", (Throwable)confe);
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException {
        try {
            Session session = this.getSession();
            Document document = this.getDocument(session, fileEntryId);
            this.deleteMappedFileEntry(document);
            document.deleteAllVersions();
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public void deleteFileShortcut(long fileShortcutId) {
        throw new UnsupportedOperationException();
    }

    public void deleteFileShortcuts(long toFileEntryId) {
        throw new UnsupportedOperationException();
    }

    public void deleteFolder(long folderId) throws PortalException {
        try {
            Session session = this.getSession();
            org.apache.chemistry.opencmis.client.api.Folder cmisFolder = this.getCmisFolder(session, folderId);
            this.deleteMappedFolder(cmisFolder);
            cmisFolder.deleteTree(true, UnfileObject.DELETE, false);
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public CMISRepositoryDetector getCMISRepositoryDetector() {
        return this._cmisRepositoryDetector;
    }

    public List<FileEntry> getFileEntries(long folderId, int status, int start, int end, OrderByComparator<FileEntry> obc) {
        return this.getFileEntries(folderId, start, end, obc);
    }

    public List<FileEntry> getFileEntries(long folderId, int start, int end, OrderByComparator<FileEntry> obc) {
        List<FileEntry> fileEntries = this.getFileEntries(folderId);
        return this.subList(fileEntries, start, end, obc);
    }

    public List<FileEntry> getFileEntries(long folderId, long fileEntryTypeId, int start, int end, OrderByComparator<FileEntry> obc) {
        return new ArrayList<FileEntry>();
    }

    public List<FileEntry> getFileEntries(long folderId, String[] mimeTypes, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        List<FileEntry> fileEntries = _cmisModelCache.getFileEntries(folderId);
        if (fileEntries == null || mimeTypes != null) {
            fileEntries = new ArrayList<FileEntry>();
            List<String> documentIds = this.getDocumentIds(this.getSession(), folderId, mimeTypes);
            for (String documentId : documentIds) {
                FileEntry fileEntry = this.toFileEntry(documentId);
                fileEntries.add(fileEntry);
            }
            if (mimeTypes == null) {
                _cmisModelCache.putFileEntries(folderId, fileEntries);
            }
        }
        return this.subList(fileEntries, start, end, obc);
    }

    public int getFileEntriesCount(long folderId) {
        List<FileEntry> fileEntries = this.getFileEntries(folderId);
        return fileEntries.size();
    }

    public int getFileEntriesCount(long folderId, int status) {
        List<FileEntry> fileEntries = this.getFileEntries(folderId);
        return fileEntries.size();
    }

    public int getFileEntriesCount(long folderId, long fileEntryTypeId) {
        List<FileEntry> fileEntries = this.getFileEntries(folderId, fileEntryTypeId);
        return fileEntries.size();
    }

    public int getFileEntriesCount(long folderId, String[] mimeTypes) throws PortalException {
        Session session = this.getSession();
        List<String> documentIds = this.getDocumentIds(session, folderId, mimeTypes);
        return documentIds.size();
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        try {
            FileEntry fileEntry = _cmisModelCache.getFileEntry(fileEntryId);
            if (fileEntry == null) {
                Session session = this.getSession();
                Document document = this.getDocument(session, fileEntryId);
                fileEntry = this.toFileEntry(document);
                _cmisModelCache.putFileEntry(fileEntry);
            }
            return fileEntry;
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public FileEntry getFileEntry(long folderId, String title) throws PortalException {
        try {
            Session session = this.getSession();
            String objectId = this.getObjectId(session, folderId, true, title);
            if (objectId != null) {
                CmisObject cmisObject = session.getObject(objectId);
                Document document = (Document)cmisObject;
                return this.toFileEntry(document);
            }
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFileEntryException(StringBundler.concat((Object[])new Object[]{"No CMIS file entry with {folderId=", folderId, ", title=", title, "}"}), (Throwable)confe);
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
        throw new NoSuchFileEntryException(StringBundler.concat((Object[])new Object[]{"No CMIS file entry with {folderId=", folderId, ", title=", title, "}"}));
    }

    public FileEntry getFileEntryByUuid(String uuid) throws PortalException {
        try {
            Session session = this.getSession();
            RepositoryEntry repositoryEntry = this.repositoryEntryLocalService.getRepositoryEntry(uuid, this.getGroupId());
            String objectId = repositoryEntry.getMappedId();
            return this.toFileEntry((Document)session.getObject(objectId));
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFileEntryException("No CMIS file entry with {uuid=" + uuid + "}", (Throwable)confe);
        }
        catch (NoSuchRepositoryEntryException nsree) {
            throw new NoSuchFileEntryException((Throwable)nsree);
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public FileShortcut getFileShortcut(long fileShortcutId) {
        throw new UnsupportedOperationException();
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        try {
            Session session = this.getSession();
            return this.getFileVersion(session, null, fileVersionId);
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public Folder getFolder(long folderId) throws PortalException {
        try {
            Session session = this.getSession();
            return this.getFolder(session, folderId);
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public Folder getFolder(long parentFolderId, String name) throws PortalException {
        try {
            Session session = this.getSession();
            String objectId = this.getObjectId(session, parentFolderId, false, name);
            if (objectId != null) {
                CmisObject cmisObject = session.getObject(objectId);
                return this.toFolder((org.apache.chemistry.opencmis.client.api.Folder)cmisObject);
            }
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFolderException(StringBundler.concat((Object[])new Object[]{"No CMIS folder with {parentFolderId=", parentFolderId, ", name=", name, "}"}), (Throwable)confe);
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
        throw new NoSuchFolderException(StringBundler.concat((Object[])new Object[]{"No CMIS folder with {parentFolderId=", parentFolderId, ", name=", name, "}"}));
    }

    public List<Folder> getFolders(long parentFolderId, boolean includeMountfolders, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        List<Folder> folders = this.getFolders(parentFolderId);
        return this.subList(folders, start, end, obc);
    }

    public List<Object> getFoldersAndFileEntries(long folderId, int start, int end, OrderByComparator<?> obc) {
        List<Object> foldersAndFileEntries = this.getFoldersAndFileEntries(folderId);
        return this.subList(foldersAndFileEntries, start, end, obc);
    }

    public List<Object> getFoldersAndFileEntries(long folderId, String[] mimeTypes, int start, int end, OrderByComparator<?> obc) throws PortalException {
        List<Object> foldersAndFileEntries = _cmisModelCache.getFoldersAndFileEntries(folderId);
        if (foldersAndFileEntries == null || mimeTypes != null) {
            foldersAndFileEntries = new ArrayList<Object>();
            foldersAndFileEntries.addAll(this.getFolders(folderId));
            List<FileEntry> fileEntries = this.getFileEntries(folderId, mimeTypes, -1, -1, null);
            foldersAndFileEntries.addAll(fileEntries);
            if (mimeTypes == null) {
                _cmisModelCache.putFoldersAndFileEntries(folderId, foldersAndFileEntries);
            }
        }
        return this.subList(foldersAndFileEntries, start, end, obc);
    }

    public int getFoldersAndFileEntriesCount(long folderId) {
        List<Object> foldersAndFileEntries = this.getFoldersAndFileEntries(folderId);
        return foldersAndFileEntries.size();
    }

    public int getFoldersAndFileEntriesCount(long folderId, String[] mimeTypes) throws PortalException {
        if (ArrayUtil.isNotEmpty((Object[])mimeTypes)) {
            List<Folder> folders = this.getFolders(folderId);
            Session session = this.getSession();
            List<String> documentIds = this.getDocumentIds(session, folderId, mimeTypes);
            return folders.size() + documentIds.size();
        }
        List<Object> foldersAndFileEntries = this.getFoldersAndFileEntries(folderId);
        return foldersAndFileEntries.size();
    }

    public int getFoldersCount(long parentFolderId, boolean includeMountfolders) throws PortalException {
        List<Folder> folders = this.getFolders(parentFolderId);
        return folders.size();
    }

    public int getFoldersFileEntriesCount(List<Long> folderIds, int status) {
        int count = 0;
        for (long folderId : folderIds) {
            List<FileEntry> fileEntries = this.getFileEntries(folderId);
            count += fileEntries.size();
        }
        return count;
    }

    public String getLatestVersionId(String objectId) {
        try {
            Session session = this.getSession();
            Document document = (Document)session.getObject(objectId);
            List documentVersions = document.getAllVersions();
            document = (Document)documentVersions.get(0);
            return document.getId();
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public List<Folder> getMountFolders(long parentFolderId, int start, int end, OrderByComparator<Folder> obc) {
        return new ArrayList<Folder>();
    }

    public int getMountFoldersCount(long parentFolderId) {
        return 0;
    }

    public String getObjectName(String objectId) throws PortalException {
        Session session = this.getSession();
        CmisObject cmisObject = session.getObject(objectId);
        return cmisObject.getName();
    }

    public List<String> getObjectPaths(String objectId) throws PortalException {
        Session session = this.getSession();
        CmisObject cmisObject = session.getObject(objectId);
        if (cmisObject instanceof FileableCmisObject) {
            FileableCmisObject fileableCmisObject = (FileableCmisObject)cmisObject;
            return fileableCmisObject.getPaths();
        }
        throw new RepositoryException("CMIS object is unfileable for id " + objectId);
    }

    public Session getSession() throws PortalException {
        Session session = this._cmisSessionCache.get(this._sessionKey);
        if (session == null) {
            SessionImpl sessionImpl = (SessionImpl)this._cmisRepositoryHandler.getSession();
            session = sessionImpl.getSession();
            this._cmisSessionCache.put(this._sessionKey, session);
        }
        if (this._cmisRepositoryDetector == null) {
            RepositoryInfo repositoryInfo = session.getRepositoryInfo();
            this._cmisRepositoryDetector = new CMISRepositoryDetector(repositoryInfo);
        }
        return session;
    }

    public void getSubfolderIds(List<Long> folderIds, long folderId) {
        try {
            List<Folder> subfolders = this.getFolders(folderId, false, -1, -1, null);
            this.getSubfolderIds(folderIds, subfolders, true);
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public List<Long> getSubfolderIds(long folderId, boolean recurse) {
        try {
            ArrayList<Long> subfolderIds = new ArrayList<Long>();
            List<Folder> subfolders = this.getFolders(folderId, false, -1, -1, null);
            this.getSubfolderIds(subfolderIds, subfolders, recurse);
            return subfolderIds;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Deprecated
    public String[][] getSupportedParameters() {
        return this._cmisRepositoryHandler.getSupportedParameters();
    }

    public void initRepository() throws PortalException {
        try {
            this._sessionKey = Session.class.getName().concat("#").concat(String.valueOf(this.getRepositoryId()));
            Session session = this.getSession();
            session.getRepositoryInfo();
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException(StringBundler.concat((Object[])new Object[]{"Unable to initialize CMIS session for repository with ", "{repositoryId=", this.getRepositoryId(), "}"}), (Throwable)e);
        }
    }

    public boolean isCancelCheckOutAllowable(String objectId) throws PortalException {
        return this.isActionAllowable(objectId, Action.CAN_CANCEL_CHECK_OUT);
    }

    public boolean isCheckInAllowable(String objectId) throws PortalException {
        return this.isActionAllowable(objectId, Action.CAN_CHECK_IN);
    }

    public boolean isCheckOutAllowable(String objectId) throws PortalException {
        return this.isActionAllowable(objectId, Action.CAN_CHECK_OUT);
    }

    public boolean isDocumentRetrievableByVersionSeriesId() {
        return this._cmisRepositoryHandler.isDocumentRetrievableByVersionSeriesId();
    }

    public boolean isRefreshBeforePermissionCheck() {
        return this._cmisRepositoryHandler.isRefreshBeforePermissionCheck();
    }

    public boolean isSupportsMinorVersions() throws PortalException {
        try {
            Session session = this.getSession();
            RepositoryInfo repositoryInfo = session.getRepositoryInfo();
            String productName = repositoryInfo.getProductName();
            return this._cmisRepositoryHandler.isSupportsMinorVersions(productName);
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public Lock lockFolder(long folderId) {
        throw new UnsupportedOperationException();
    }

    public Lock lockFolder(long folderId, String owner, boolean inheritable, long expirationTime) {
        throw new UnsupportedOperationException();
    }

    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        try {
            String newObjectId;
            Session session = this.getSession();
            String newFolderObjectId = this.toFolderId(session, newFolderId);
            Document document = this.getDocument(session, fileEntryId);
            this.validateTitle(session, newFolderId, document.getName());
            List parentFolders = document.getParents();
            org.apache.chemistry.opencmis.client.api.Folder oldFolder = (org.apache.chemistry.opencmis.client.api.Folder)parentFolders.get(0);
            String oldFolderObjectId = oldFolder.getId();
            if (oldFolderObjectId.equals(newFolderObjectId)) {
                return this.toFileEntry(document);
            }
            document = (Document)document.move((ObjectId)new ObjectIdImpl(oldFolderObjectId), (ObjectId)new ObjectIdImpl(newFolderObjectId));
            String versionSeriesId = this.toFileEntryId(fileEntryId);
            if (!versionSeriesId.equals(newObjectId = document.getVersionSeriesId())) {
                document = (Document)session.getObject(newObjectId);
                this.updateMappedId(fileEntryId, document.getVersionSeriesId());
            }
            return this.toFileEntry(document);
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFolderException("No CMIS folder with {folderId=" + newFolderId + "}", (Throwable)confe);
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public Folder moveFolder(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        try {
            String targetFolderId;
            Session session = this.getSession();
            org.apache.chemistry.opencmis.client.api.Folder cmisFolder = this.getCmisFolder(session, folderId);
            this.validateTitle(session, parentFolderId, cmisFolder.getName());
            org.apache.chemistry.opencmis.client.api.Folder parentCmisFolder = cmisFolder.getFolderParent();
            if (parentCmisFolder == null) {
                throw new RepositoryException("Unable to move CMIS root folder with {folderId=" + folderId + "}");
            }
            String objectId = this.toFolderId(session, folderId);
            String sourceFolderId = parentCmisFolder.getId();
            if (!sourceFolderId.equals(targetFolderId = this.toFolderId(session, parentFolderId)) && !targetFolderId.equals(objectId)) {
                cmisFolder = (org.apache.chemistry.opencmis.client.api.Folder)cmisFolder.move((ObjectId)new ObjectIdImpl(sourceFolderId), (ObjectId)new ObjectIdImpl(targetFolderId));
            }
            return this.toFolder(cmisFolder);
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFolderException("No CMIS folder with {folderId=" + parentFolderId + "}", (Throwable)confe);
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public Lock refreshFileEntryLock(String lockUuid, long companyId, long expirationTime) {
        throw new UnsupportedOperationException();
    }

    public Lock refreshFolderLock(String lockUuid, long companyId, long expirationTime) {
        throw new UnsupportedOperationException();
    }

    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        try {
            Session session = this.getSession();
            Document document = this.getDocument(session, fileEntryId);
            Document oldVersion = null;
            List documentVersions = document.getAllVersions();
            for (Document currentVersion : documentVersions) {
                String currentVersionLabel = currentVersion.getVersionLabel();
                if (Validator.isNull((String)currentVersionLabel)) {
                    currentVersionLabel = "1.0";
                }
                if (!currentVersionLabel.equals(version)) continue;
                oldVersion = currentVersion;
                break;
            }
            String mimeType = oldVersion.getContentStreamMimeType();
            String changeLog = LanguageUtil.format((Locale)serviceContext.getLocale(), (String)"reverted-to-x", (Object)version, (boolean)false);
            String title = oldVersion.getName();
            ContentStream contentStream = oldVersion.getContentStream();
            this.updateFileEntry(userId, fileEntryId, contentStream.getFileName(), mimeType, title, "", changeLog, DLVersionNumberIncrease.MAJOR, contentStream.getStream(), contentStream.getLength(), serviceContext);
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public Hits search(long creatorUserId, int status, int start, int end) {
        throw new UnsupportedOperationException();
    }

    public Hits search(long creatorUserId, long folderId, String[] mimeTypes, int status, int start, int end) {
        throw new UnsupportedOperationException();
    }

    public Hits search(SearchContext searchContext, Query query) throws SearchException {
        try {
            QueryConfig queryConfig = searchContext.getQueryConfig();
            queryConfig.setScoreEnabled(false);
            return this.doSearch(searchContext, query);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public FileEntry toFileEntry(Document document) throws PortalException {
        return this.toFileEntry(document, false);
    }

    public FileEntry toFileEntry(String objectId) throws PortalException {
        return this.toFileEntry(objectId, false);
    }

    public FileVersion toFileVersion(FileEntry fileEntry, Document version) throws PortalException {
        RepositoryEntry repositoryEntry = this.getRepositoryEntry(version.getId());
        return new CMISFileVersion(this, fileEntry, repositoryEntry.getUuid(), repositoryEntry.getRepositoryEntryId(), version);
    }

    public Folder toFolder(org.apache.chemistry.opencmis.client.api.Folder cmisFolder) throws PortalException {
        RepositoryEntry repositoryEntry = this.getRepositoryEntry(cmisFolder.getId());
        return new CMISFolder(this, repositoryEntry.getUuid(), repositoryEntry.getRepositoryEntryId(), cmisFolder);
    }

    public Folder toFolder(String objectId) throws PortalException {
        try {
            Session session = this.getSession();
            org.apache.chemistry.opencmis.client.api.Folder cmisFolder = (org.apache.chemistry.opencmis.client.api.Folder)session.getObject(objectId);
            return this.toFolder(cmisFolder);
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFolderException("No CMIS folder with {objectId=" + objectId + "}", (Throwable)confe);
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public void unlockFolder(long folderId, String lockUuid) {
        throw new UnsupportedOperationException();
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        Document document = null;
        ObjectId checkOutDocumentObjectId = null;
        try {
            Session session = this.getSession();
            document = this.getDocument(session, fileEntryId);
            String versionSeriesCheckedOutId = document.getVersionSeriesCheckedOutId();
            if (Validator.isNotNull((String)versionSeriesCheckedOutId)) {
                document = (Document)session.getObject(versionSeriesCheckedOutId);
                document.refresh();
            }
            String currentTitle = document.getName();
            AllowableActions allowableActions = document.getAllowableActions();
            Set allowableActionsSet = allowableActions.getAllowableActions();
            if (allowableActionsSet.contains(Action.CAN_CHECK_OUT)) {
                checkOutDocumentObjectId = document.checkOut();
                document = (Document)session.getObject(checkOutDocumentObjectId);
            }
            HashMap<String, String> properties = null;
            ContentStreamImpl contentStream = null;
            if (Validator.isNotNull((String)title) && !title.equals(currentTitle)) {
                properties = new HashMap<String, String>();
                properties.put("cmis:name", title);
            }
            if (is != null) {
                contentStream = new ContentStreamImpl(sourceFileName, BigInteger.valueOf(size), mimeType, is);
            }
            this.checkUpdatable(allowableActionsSet, (Map<String, Object>)properties, (ContentStream)contentStream);
            if (checkOutDocumentObjectId != null) {
                boolean majorVersion = false;
                if (!this.isSupportsMinorVersions() || dlVersionNumberIncrease == DLVersionNumberIncrease.MAJOR) {
                    majorVersion = true;
                }
                document.checkIn(majorVersion, properties, (ContentStream)contentStream, changeLog);
                checkOutDocumentObjectId = null;
            } else {
                if (properties != null) {
                    document = (Document)document.updateProperties(properties);
                }
                if (contentStream != null) {
                    document.setContentStream((ContentStream)contentStream, true, false);
                }
            }
            String versionSeriesId = this.toFileEntryId(fileEntryId);
            document = (Document)session.getObject(versionSeriesId);
            FileEntry fileEntry = this.toFileEntry(document);
            return fileEntry;
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (checkOutDocumentObjectId != null) {
                document.cancelCheckOut();
            }
        }
    }

    public FileEntry updateFileEntry(String objectId, String mimeType, Map<String, Object> properties, InputStream is, String sourceFileName, long size, ServiceContext serviceContext) throws PortalException {
        try {
            Session session = this.getSession();
            Document document = (Document)session.getObject(objectId);
            AllowableActions allowableActions = document.getAllowableActions();
            Set allowableActionsSet = allowableActions.getAllowableActions();
            ContentStreamImpl contentStream = null;
            if (is != null) {
                is = new Base64.InputStream(is, 1);
                contentStream = new ContentStreamImpl(sourceFileName, BigInteger.valueOf(size), mimeType, is);
            }
            this.checkUpdatable(allowableActionsSet, properties, (ContentStream)contentStream);
            if (properties != null) {
                document = (Document)document.updateProperties(properties);
            }
            if (contentStream != null) {
                document.setContentStream(contentStream, true, false);
            }
            return this.toFileEntry(document);
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public FileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) {
        throw new UnsupportedOperationException();
    }

    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) {
        throw new UnsupportedOperationException();
    }

    public Folder updateFolder(long folderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        try {
            ObjectId cmisFolderObjectId;
            String newObjectId;
            Session session = this.getSession();
            String objectId = this.toFolderId(session, folderId);
            org.apache.chemistry.opencmis.client.api.Folder cmisFolder = (org.apache.chemistry.opencmis.client.api.Folder)session.getObject(objectId);
            String currentTitle = cmisFolder.getName();
            HashMap<String, String> properties = new HashMap<String, String>();
            if (Validator.isNotNull((String)name) && !name.equals(currentTitle)) {
                properties.put("cmis:name", name);
            }
            if (!objectId.equals(newObjectId = (cmisFolderObjectId = cmisFolder.updateProperties(properties, true)).getId())) {
                cmisFolder = (org.apache.chemistry.opencmis.client.api.Folder)session.getObject(newObjectId);
                this.updateMappedId(folderId, newObjectId);
            }
            return this.toFolder(cmisFolder);
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFolderException("No CMIS folder with {folderId=" + folderId + "}", (Throwable)confe);
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean verifyFileEntryCheckOut(long fileEntryId, String lockUuid) {
        throw new UnsupportedOperationException();
    }

    public boolean verifyInheritableLock(long folderId, String lockUuid) {
        throw new UnsupportedOperationException();
    }

    protected void cacheFoldersAndFileEntries(long folderId) {
        try {
            if (_cmisModelCache.getFoldersAndFileEntries(folderId) != null) {
                return;
            }
            ArrayList<Object> foldersAndFileEntries = new ArrayList<Object>();
            ArrayList<Folder> folders = new ArrayList<Folder>();
            ArrayList<FileEntry> fileEntries = new ArrayList<FileEntry>();
            Session session = this.getSession();
            org.apache.chemistry.opencmis.client.api.Folder cmisParentFolder = this.getCmisFolder(session, folderId);
            Folder parentFolder = this.toFolder(cmisParentFolder);
            OperationContext operationContext = session.createOperationContext();
            operationContext.setFilter(this._toSet("cmis:contentStreamLength", "cmis:isPrivateWorkingCopy", "cmis:isVersionSeriesCheckedOut", "cmis:lastModificationDate", "cmis:lastModifiedBy", "cmis:name", "cmis:versionLabel", "cmis:versionSeriesId"));
            ItemIterable cmisObjects = cmisParentFolder.getChildren(operationContext);
            for (CmisObject cmisObject : cmisObjects) {
                if (cmisObject instanceof org.apache.chemistry.opencmis.client.api.Folder) {
                    CMISFolder cmisFolder = (CMISFolder)this.toFolder((org.apache.chemistry.opencmis.client.api.Folder)cmisObject);
                    cmisFolder.setParentFolder(parentFolder);
                    foldersAndFileEntries.add(cmisFolder);
                    folders.add(cmisFolder);
                    _cmisModelCache.putFolder(cmisFolder);
                    continue;
                }
                if (!(cmisObject instanceof Document)) continue;
                Document document = (Document)cmisObject;
                CMISFileEntry cmisFileEntry = (CMISFileEntry)this.toFileEntry(document);
                cmisFileEntry.setParentFolder(parentFolder);
                Boolean privateWorkingCopy = document.isPrivateWorkingCopy();
                if (privateWorkingCopy != null && privateWorkingCopy.booleanValue() || Objects.equals(document.getVersionLabel(), "pwc")) {
                    foldersAndFileEntries.remove(cmisFileEntry);
                    fileEntries.remove(cmisFileEntry);
                }
                foldersAndFileEntries.add(cmisFileEntry);
                fileEntries.add(cmisFileEntry);
                _cmisModelCache.putFileEntry(cmisFileEntry);
            }
            _cmisModelCache.putFoldersAndFileEntries(folderId, foldersAndFileEntries);
            _cmisModelCache.putFolders(folderId, folders);
            _cmisModelCache.putFileEntries(folderId, fileEntries);
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void checkUpdatable(Set<Action> allowableActionsSet, Map<String, Object> properties, ContentStream contentStream) throws PrincipalException {
        if (properties != null && !allowableActionsSet.contains(Action.CAN_UPDATE_PROPERTIES)) {
            throw new PrincipalException.MustHavePermission(0L, new String[]{Action.CAN_UPDATE_PROPERTIES.toString()});
        }
        if (contentStream != null && !allowableActionsSet.contains(Action.CAN_SET_CONTENT_STREAM)) {
            throw new PrincipalException.MustHavePermission(0L, new String[]{Action.CAN_SET_CONTENT_STREAM.toString()});
        }
    }

    protected void deleteMappedFileEntry(Document document) throws PortalException {
        if (this._cmisRepositoryConfiguration.deleteDepth() == 0) {
            return;
        }
        List documentVersions = document.getAllVersions();
        ArrayList<String> mappedIds = new ArrayList<String>(documentVersions.size() + 1);
        for (Document version : documentVersions) {
            mappedIds.add(version.getId());
        }
        mappedIds.add(document.getId());
        this.repositoryEntryLocalService.deleteRepositoryEntries(this.getRepositoryId(), mappedIds);
    }

    protected void deleteMappedFolder(org.apache.chemistry.opencmis.client.api.Folder cmisFolder) throws PortalException {
        if (this._cmisRepositoryConfiguration.deleteDepth() == 0) {
            return;
        }
        ItemIterable cmisObjects = cmisFolder.getChildren();
        for (CmisObject cmisObject : cmisObjects) {
            if (cmisObject instanceof Document) {
                Document document = (Document)cmisObject;
                this.deleteMappedFileEntry(document);
                continue;
            }
            if (!(cmisObject instanceof org.apache.chemistry.opencmis.client.api.Folder)) continue;
            org.apache.chemistry.opencmis.client.api.Folder cmisSubfolder = (org.apache.chemistry.opencmis.client.api.Folder)cmisObject;
            try {
                this.repositoryEntryLocalService.deleteRepositoryEntry(this.getRepositoryId(), cmisObject.getId());
                if (this._cmisRepositoryConfiguration.deleteDepth() != -1) continue;
                this.deleteMappedFolder(cmisSubfolder);
            }
            catch (NoSuchRepositoryEntryException nsree) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)nsree, (Throwable)nsree);
            }
        }
    }

    protected Hits doSearch(SearchContext searchContext, Query query) throws Exception {
        long startTime = System.currentTimeMillis();
        Session session = this.getSession();
        RepositoryInfo repositoryInfo = session.getRepositoryInfo();
        RepositoryCapabilities repositoryCapabilities = repositoryInfo.getCapabilities();
        QueryConfig queryConfig = searchContext.getQueryConfig();
        CapabilityQuery capabilityQuery = repositoryCapabilities.getQueryCapability();
        queryConfig.setAttribute("capabilityQuery", (Serializable)((Object)capabilityQuery.value()));
        String productName = repositoryInfo.getProductName();
        String productVersion = repositoryInfo.getProductVersion();
        queryConfig.setAttribute("repositoryProductName", (Serializable)((Object)productName));
        queryConfig.setAttribute("repositoryProductVersion", (Serializable)((Object)productVersion));
        String queryString = this._cmisSearchQueryBuilder.buildQuery(searchContext, query);
        if (this._cmisRepositoryDetector.isNuxeo5_4()) {
            queryString = queryString + " AND (cmis:isLatestVersion = true)";
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("CMIS search query: " + queryString));
        }
        boolean searchAllVersions = this._cmisRepositoryDetector.isNuxeo5_5OrHigher();
        ItemIterable queryResults = session.query(queryString, searchAllVersions);
        int start = searchContext.getStart();
        int end = searchContext.getEnd();
        if (start == -1 && end == -1) {
            start = 0;
        }
        int total = 0;
        ArrayList<DocumentImpl> documents = new ArrayList<DocumentImpl>();
        ArrayList<String> snippets = new ArrayList<String>();
        ArrayList<Float> scores = new ArrayList<Float>();
        for (QueryResult queryResult : queryResults) {
            if (++total <= start || total > end && end != -1) continue;
            String objectId = (String)queryResult.getPropertyValueByQueryName("cmis:objectId");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Search result object ID " + objectId));
            }
            FileEntry fileEntry = null;
            try {
                fileEntry = this.toFileEntry(objectId, true);
            }
            catch (Exception e) {
                if (_log.isDebugEnabled()) {
                    Throwable cause = e.getCause();
                    if (cause != null) {
                        cause = cause.getCause();
                    }
                    if (cause instanceof CmisObjectNotFoundException) {
                        _log.debug((Object)("Search result ignored for CMIS document which has a version with an invalid object ID " + cause.getMessage()));
                    } else {
                        _log.debug((Object)"Search result ignored for invalid object ID", (Throwable)e);
                    }
                }
                --total;
                continue;
            }
            DocumentImpl document = new DocumentImpl();
            DocumentHelper documentHelper = new DocumentHelper((com.liferay.portal.kernel.search.Document)document);
            documentHelper.setEntryKey(fileEntry.getModelClassName(), fileEntry.getFileEntryId());
            document.addKeyword("title", fileEntry.getTitle());
            documents.add(document);
            if (queryConfig.isScoreEnabled()) {
                Object scoreObj = queryResult.getPropertyValueByQueryName("HITS");
                if (scoreObj != null) {
                    scores.add(Float.valueOf(scoreObj.toString()));
                } else {
                    scores.add(Float.valueOf(1.0f));
                }
            } else {
                scores.add(Float.valueOf(1.0f));
            }
            snippets.add("");
        }
        float searchTime = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
        HitsImpl hits = new HitsImpl();
        hits.setDocs(documents.toArray(new com.liferay.portal.kernel.search.Document[0]));
        hits.setLength(total);
        hits.setQuery(query);
        hits.setQueryTerms(new String[0]);
        hits.setScores(ArrayUtil.toFloatArray(scores));
        hits.setSearchTime(searchTime);
        hits.setSnippets(snippets.toArray(new String[0]));
        hits.setStart(startTime);
        return hits;
    }

    protected org.apache.chemistry.opencmis.client.api.Folder getCmisFolder(Session session, long folderId) throws PortalException {
        Folder folder = this.getFolder(session, folderId);
        return (org.apache.chemistry.opencmis.client.api.Folder)folder.getModel();
    }

    protected List<String> getCmisFolderIds(Session session, long folderId) throws PortalException {
        StringBundler sb = new StringBundler(4);
        sb.append("SELECT cmis:objectId FROM cmis:folder");
        if (folderId > 0L) {
            sb.append(" WHERE IN_FOLDER(");
            String objectId = this.toFolderId(session, folderId);
            sb.append(StringUtil.quote((String)objectId));
            sb.append(")");
        }
        String query = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Calling query " + query));
        }
        ItemIterable queryResults = session.query(query, this.isAllVersionsSearchableSupported(session));
        ArrayList<String> cmsFolderIds = new ArrayList<String>();
        for (QueryResult queryResult : queryResults) {
            PropertyData propertyData = queryResult.getPropertyById("cmis:objectId");
            List values = propertyData.getValues();
            String value = (String)values.get(0);
            cmsFolderIds.add(value);
        }
        return cmsFolderIds;
    }

    protected Document getDocument(Session session, long fileEntryId) throws PortalException {
        try {
            String versionSeriesId = this.toFileEntryId(fileEntryId);
            CmisObject object = session.getObject(versionSeriesId);
            if (!(object instanceof Document)) {
                throw new NoSuchFileEntryException("No CMIS file entry with {fileEntryId=" + fileEntryId + "}");
            }
            return (Document)object;
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFileEntryException("No CMIS file entry with {fileEntryId=" + fileEntryId + "}", (Throwable)confe);
        }
    }

    protected List<String> getDocumentIds(Session session, long folderId, String[] mimeTypes) throws PortalException {
        StringBundler sb = new StringBundler();
        sb.append("SELECT cmis:objectId FROM cmis:document");
        if (ArrayUtil.isNotEmpty((Object[])mimeTypes)) {
            sb.append(" WHERE cmis:contentStreamMimeType IN (");
            for (int i = 0; i < mimeTypes.length; ++i) {
                sb.append(StringUtil.quote((String)mimeTypes[i]));
                if (i + 1 >= mimeTypes.length) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        if (folderId > 0L) {
            if (ArrayUtil.isNotEmpty((Object[])mimeTypes)) {
                sb.append(" AND ");
            } else {
                sb.append(" WHERE ");
            }
            sb.append("IN_FOLDER(");
            String objectId = this.toFolderId(session, folderId);
            sb.append(StringUtil.quote((String)objectId));
            sb.append(")");
        }
        String query = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Calling query " + query));
        }
        ItemIterable queryResults = session.query(query, false);
        ArrayList<String> cmisDocumentIds = new ArrayList<String>();
        for (QueryResult queryResult : queryResults) {
            String objectId = (String)queryResult.getPropertyValueByQueryName("cmis:objectId");
            cmisDocumentIds.add(objectId);
        }
        return cmisDocumentIds;
    }

    protected List<FileEntry> getFileEntries(long folderId) {
        this.cacheFoldersAndFileEntries(folderId);
        return _cmisModelCache.getFileEntries(folderId);
    }

    protected List<FileEntry> getFileEntries(long folderId, long repositoryId) {
        return new ArrayList<FileEntry>();
    }

    protected FileVersion getFileVersion(Session session, FileEntry fileEntry, long fileVersionId) throws PortalException {
        try {
            String objectId = this.toFileVersionId(fileVersionId);
            return this.toFileVersion(fileEntry, (Document)session.getObject(objectId));
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFileVersionException("No CMIS file version with {fileVersionId=" + fileVersionId + "}", (Throwable)confe);
        }
    }

    protected Folder getFolder(Session session, long folderId) throws PortalException {
        try {
            Folder folder = _cmisModelCache.getFolder(folderId);
            if (folder == null) {
                String objectId = this.toFolderId(session, folderId);
                CmisObject cmisObject = session.getObject(objectId);
                Object object = this.toFolderOrFileEntry(cmisObject);
                if (!(object instanceof Folder)) {
                    throw new NoSuchFolderException("No CMIS folder with {folderId=" + folderId + "}");
                }
                folder = (Folder)object;
                _cmisModelCache.putFolder(folder);
            }
            return folder;
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFolderException("No CMIS folder with {folderId=" + folderId + "}", (Throwable)confe);
        }
    }

    protected List<Folder> getFolders(long parentFolderId) throws PortalException {
        List<Folder> folders = _cmisModelCache.getFolders(parentFolderId);
        if (folders == null) {
            List<String> folderIds = this.getCmisFolderIds(this.getSession(), parentFolderId);
            folders = new ArrayList<Folder>(folderIds.size());
            for (String folderId : folderIds) {
                folders.add(this.toFolder(folderId));
            }
            _cmisModelCache.putFolders(parentFolderId, folders);
        }
        return folders;
    }

    protected List<Object> getFoldersAndFileEntries(long folderId) {
        this.cacheFoldersAndFileEntries(folderId);
        return _cmisModelCache.getFoldersAndFileEntries(folderId);
    }

    protected String getObjectId(Session session, long folderId, boolean fileEntry, String name) throws PortalException {
        ItemIterable queryResults;
        Iterator itr;
        String objectId = this.toFolderId(session, folderId);
        StringBundler sb = new StringBundler(7);
        sb.append("SELECT cmis:objectId FROM ");
        if (fileEntry) {
            sb.append("cmis:document ");
        } else {
            sb.append("cmis:folder ");
        }
        sb.append("WHERE cmis:name = '");
        sb.append(name);
        sb.append("' AND IN_FOLDER('");
        sb.append(objectId);
        sb.append("')");
        String query = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Calling query " + query));
        }
        if ((itr = (queryResults = session.query(query, false)).iterator()).hasNext()) {
            QueryResult queryResult = (QueryResult)itr.next();
            PropertyData propertyData = queryResult.getPropertyById("cmis:objectId");
            List values = propertyData.getValues();
            return (String)values.get(0);
        }
        return null;
    }

    protected void getSubfolderIds(List<Long> subfolderIds, List<Folder> subfolders, boolean recurse) throws PortalException {
        for (Folder subfolder : subfolders) {
            long subfolderId = subfolder.getFolderId();
            subfolderIds.add(subfolderId);
            if (!recurse) continue;
            List<Folder> subSubFolders = this.getFolders(subfolderId, false, -1, -1, null);
            this.getSubfolderIds(subfolderIds, subSubFolders, recurse);
        }
    }

    protected boolean isActionAllowable(String objectId, Action action) throws PortalException {
        Session session = this.getSession();
        Document document = (Document)session.getObject(objectId);
        AllowableActions allowableActions = document.getAllowableActions();
        Set allowableActionsSet = allowableActions.getAllowableActions();
        return allowableActionsSet.contains(action);
    }

    protected boolean isAllVersionsSearchableSupported(Session session) {
        RepositoryInfo repositoryInfo = session.getRepositoryInfo();
        RepositoryCapabilities repositoryCapabilities = repositoryInfo.getCapabilities();
        return repositoryCapabilities.isAllVersionsSearchableSupported();
    }

    protected void processException(Exception e) throws PortalException {
        String message = e.getMessage();
        if (e instanceof CmisRuntimeException && message.contains("authorized") || e instanceof CmisPermissionDeniedException) {
            String login = null;
            try {
                login = this._cmisRepositoryHandler.getLogin();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new PrincipalException.MustBeAuthenticated(login);
        }
    }

    protected <E> List<E> subList(List<E> list, int start, int end, OrderByComparator<E> obc) {
        if (obc != null && (obc instanceof RepositoryModelCreateDateComparator || obc instanceof RepositoryModelModifiedDateComparator || obc instanceof RepositoryModelSizeComparator || obc instanceof RepositoryModelTitleComparator)) {
            list = ListUtil.sort(list, obc);
        }
        return ListUtil.subList(list, (int)start, (int)end);
    }

    protected FileEntry toFileEntry(Document document, boolean strict) throws PortalException {
        RepositoryEntry repositoryEntry = null;
        repositoryEntry = this.isDocumentRetrievableByVersionSeriesId() ? this.getRepositoryEntry(document.getVersionSeriesId()) : this.getRepositoryEntry(document.getId());
        return new CMISFileEntry(this, repositoryEntry.getUuid(), repositoryEntry.getRepositoryEntryId(), document, this._lockManager);
    }

    protected FileEntry toFileEntry(String objectId, boolean strict) throws PortalException {
        try {
            Session session = this.getSession();
            Document document = (Document)session.getObject(objectId);
            return this.toFileEntry(document, strict);
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFileEntryException("No CMIS file entry with {objectId=" + objectId + "}", (Throwable)confe);
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            this.processException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    protected String toFileEntryId(long fileEntryId) throws PortalException {
        RepositoryEntry repositoryEntry = this.repositoryEntryLocalService.fetchRepositoryEntry(fileEntryId);
        if (repositoryEntry == null) {
            throw new NoSuchFileEntryException("No CMIS file entry with {fileEntryId=" + fileEntryId + "}");
        }
        return repositoryEntry.getMappedId();
    }

    protected String toFileVersionId(long fileVersionId) throws PortalException {
        RepositoryEntry repositoryEntry = this.repositoryEntryLocalService.fetchRepositoryEntry(fileVersionId);
        if (repositoryEntry == null) {
            throw new NoSuchFileVersionException("No CMIS file version with {fileVersionId=" + fileVersionId + "}");
        }
        return repositoryEntry.getMappedId();
    }

    protected String toFolderId(Session session, long folderId) throws PortalException {
        RepositoryEntry repositoryEntry = this.repositoryEntryLocalService.fetchRepositoryEntry(folderId);
        if (repositoryEntry != null) {
            return repositoryEntry.getMappedId();
        }
        DLFolder dlFolder = this.dlFolderLocalService.fetchFolder(folderId);
        if (dlFolder == null) {
            throw new NoSuchFolderException("No CMIS folder with {folderId=" + folderId + "}");
        }
        if (!dlFolder.isMountPoint()) {
            throw new RepositoryException("CMIS repository should not be used with {folderId=" + folderId + "}");
        }
        RepositoryInfo repositoryInfo = session.getRepositoryInfo();
        String rootFolderId = repositoryInfo.getRootFolderId();
        repositoryEntry = this.repositoryEntryLocalService.getRepositoryEntry(dlFolder.getUserId(), this.getGroupId(), this.getRepositoryId(), rootFolderId);
        return repositoryEntry.getMappedId();
    }

    protected Object toFolderOrFileEntry(CmisObject cmisObject) throws PortalException {
        if (cmisObject instanceof Document) {
            return this.toFileEntry((Document)cmisObject);
        }
        if (cmisObject instanceof org.apache.chemistry.opencmis.client.api.Folder) {
            org.apache.chemistry.opencmis.client.api.Folder cmisFolder = (org.apache.chemistry.opencmis.client.api.Folder)cmisObject;
            return this.toFolder(cmisFolder);
        }
        return null;
    }

    protected void updateMappedId(long repositoryEntryId, String mappedId) throws PortalException {
        RepositoryEntry repositoryEntry = this.repositoryEntryLocalService.getRepositoryEntry(repositoryEntryId);
        if (!mappedId.equals(repositoryEntry.getMappedId())) {
            RepositoryEntryLocalServiceUtil.updateRepositoryEntry((long)repositoryEntryId, (String)mappedId);
        }
    }

    protected void validateTitle(Session session, long folderId, String title) throws PortalException {
        String objectId = this.getObjectId(session, folderId, true, title);
        if (objectId != null) {
            throw new DuplicateFileEntryException(title);
        }
        objectId = this.getObjectId(session, folderId, false, title);
        if (objectId != null) {
            throw new DuplicateFolderNameException(title);
        }
    }

    private final <T> Set<T> _toSet(T ... items) {
        HashSet<T> set = new HashSet<T>();
        for (T item : items) {
            set.add(item);
        }
        return set;
    }
}

