/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.cmis.internal;

import com.liferay.document.library.repository.cmis.internal.CMISRepository;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CMISModelCache {
    private final ThreadLocal<Map<Long, List<FileEntry>>> _fileEntriesMaps = new CentralizedThreadLocal(CMISRepository.class + "._fileEntriesMaps", HashMap::new);
    private final ThreadLocal<Map<Long, FileEntry>> _fileEntryMaps = new CentralizedThreadLocal(CMISRepository.class + "._fileEntryMaps", HashMap::new);
    private final ThreadLocal<Map<Long, Folder>> _folderMaps = new CentralizedThreadLocal(CMISRepository.class + "._folderMaps", HashMap::new);
    private final ThreadLocal<Map<Long, List<Object>>> _foldersAndFileEntriesMaps = new CentralizedThreadLocal(CMISRepository.class + "._foldersAndFileEntriesMaps", HashMap::new);
    private final ThreadLocal<Map<Long, List<Folder>>> _foldersMap = new CentralizedThreadLocal(CMISRepository.class + "._foldersMap", HashMap::new);

    public List<FileEntry> getFileEntries(long folderId) {
        Map<Long, List<FileEntry>> fileEntriesMap = this._fileEntriesMaps.get();
        return fileEntriesMap.get(folderId);
    }

    public FileEntry getFileEntry(long fileEntryId) {
        Map<Long, FileEntry> fileEntryMap = this._fileEntryMaps.get();
        return fileEntryMap.get(fileEntryId);
    }

    public Folder getFolder(long folderId) {
        Map<Long, Folder> folderMap = this._folderMaps.get();
        return folderMap.get(folderId);
    }

    public List<Folder> getFolders(long folderId) {
        Map<Long, List<Folder>> foldersMap = this._foldersMap.get();
        return foldersMap.get(folderId);
    }

    public List<Object> getFoldersAndFileEntries(long folderId) {
        Map<Long, List<Object>> foldersAndFileEntriesMap = this._foldersAndFileEntriesMaps.get();
        return foldersAndFileEntriesMap.get(folderId);
    }

    public void putFileEntries(long folderId, List<FileEntry> fileEntries) {
        Map<Long, List<FileEntry>> fileEntriesMap = this._fileEntriesMaps.get();
        fileEntriesMap.put(folderId, fileEntries);
    }

    public void putFileEntry(FileEntry fileEntry) {
        if (fileEntry == null) {
            return;
        }
        Map<Long, FileEntry> fileEntryMap = this._fileEntryMaps.get();
        fileEntryMap.put(fileEntry.getFileEntryId(), fileEntry);
    }

    public void putFolder(Folder folder) {
        if (folder == null) {
            return;
        }
        Map<Long, Folder> folderMap = this._folderMaps.get();
        folderMap.put(folder.getFolderId(), folder);
    }

    public void putFolders(long folderId, List<Folder> folders) {
        Map<Long, List<Folder>> foldersMap = this._foldersMap.get();
        foldersMap.put(folderId, folders);
    }

    public void putFoldersAndFileEntries(long folderId, List<Object> foldersAndFileEntries) {
        Map<Long, List<Object>> foldersAndFileEntriesMap = this._foldersAndFileEntriesMaps.get();
        foldersAndFileEntriesMap.put(folderId, foldersAndFileEntries);
    }
}

