/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.cmis.internal;

import com.liferay.document.library.repository.cmis.CMISRepositoryHandler;
import com.liferay.document.library.repository.cmis.Session;
import com.liferay.document.library.repository.cmis.internal.CMISRepositoryUtil;
import com.liferay.portal.kernel.exception.InvalidRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Locale;
import org.apache.chemistry.opencmis.commons.enums.BindingType;

public class CMISAtomPubRepository
extends CMISRepositoryHandler {
    private static final String _DL_REPOSITORY_GUEST_PASSWORD = GetterUtil.getString((String)PropsUtil.get((String)"dl.repository.guest.password"));
    private static final String _DL_REPOSITORY_GUEST_USERNAME = GetterUtil.getString((String)PropsUtil.get((String)"dl.repository.guest.username"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession() throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        String login = this.getLogin();
        String password = null;
        if (Validator.isNotNull((String)login)) {
            password = PrincipalThreadLocal.getPassword();
        } else {
            login = _DL_REPOSITORY_GUEST_USERNAME;
            password = _DL_REPOSITORY_GUEST_PASSWORD;
        }
        HashMap parameters = HashMapBuilder.put((Object)"org.apache.chemistry.opencmis.binding.atompub.url", (Object)this.getTypeSettingsValue("ATOMPUB_URL")).put((Object)"org.apache.chemistry.opencmis.binding.spi.type", (Object)BindingType.ATOMPUB.value()).put((Object)"org.apache.chemistry.opencmis.binding.compression", (Object)Boolean.TRUE.toString()).put((Object)"org.apache.chemistry.opencmis.locale.iso639", (Object)locale.getLanguage()).put((Object)"org.apache.chemistry.opencmis.locale.iso3166", (Object)locale.getCountry()).put((Object)"org.apache.chemistry.opencmis.password", (Object)password).put((Object)"org.apache.chemistry.opencmis.user", (Object)login).build();
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        thread.setContextClassLoader(clazz.getClassLoader());
        try {
            CMISRepositoryUtil.checkRepository(this.getRepositoryId(), parameters, this.getTypeSettingsProperties(), "REPOSITORY_ID");
            Session session = CMISRepositoryUtil.createSession(parameters);
            return session;
        }
        finally {
            thread.setContextClassLoader(contextClassLoader);
        }
    }

    protected String getTypeSettingsValue(String typeSettingsKey) throws InvalidRepositoryException {
        return CMISRepositoryUtil.getTypeSettingsValue(this.getTypeSettingsProperties(), typeSettingsKey);
    }
}

