/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.cmis.internal;

import com.liferay.document.library.repository.cmis.Session;
import com.liferay.document.library.repository.cmis.internal.ContextClassLoaderSetter;
import com.liferay.document.library.repository.cmis.internal.SessionImpl;
import com.liferay.portal.kernel.exception.InvalidRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.RepositoryLocalServiceUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;

public class CMISRepositoryUtil {
    private static final OperationContext _operationContext;
    private static final SessionFactory _sessionFactory;

    public static void checkRepository(long repositoryId, Map<String, String> parameters, UnicodeProperties typeSettingsProperties, String typeSettingsKey) throws PortalException, RepositoryException {
        if (!typeSettingsProperties.containsKey((Object)typeSettingsKey) || Validator.isNull((String)typeSettingsProperties.getProperty(typeSettingsKey))) {
            Repository cmisRepository = CMISRepositoryUtil.getCMISRepository(parameters);
            typeSettingsProperties.setProperty(typeSettingsKey, cmisRepository.getId());
            try {
                RepositoryLocalServiceUtil.updateRepository((long)repositoryId, (UnicodeProperties)typeSettingsProperties);
            }
            catch (PortalException | SystemException e) {
                throw new RepositoryException(e);
            }
        }
        parameters.put("org.apache.chemistry.opencmis.session.repository.id", CMISRepositoryUtil.getTypeSettingsValue(typeSettingsProperties, typeSettingsKey));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Session createSession(Map<String, String> parameters) throws PrincipalException, RepositoryException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(CMISRepositoryUtil.class.getClassLoader());){
            org.apache.chemistry.opencmis.client.api.Session session = _sessionFactory.createSession(parameters);
            session.setDefaultContext(_operationContext);
            SessionImpl sessionImpl = new SessionImpl(session);
            return sessionImpl;
        }
        catch (CmisPermissionDeniedException cpde) {
            throw new PrincipalException.MustBeAuthenticated(parameters.get("org.apache.chemistry.opencmis.user"), (Throwable)cpde);
        }
        catch (CmisUnauthorizedException cue) {
            throw new PrincipalException.MustBeAuthenticated(parameters.get("org.apache.chemistry.opencmis.user"), (Throwable)cue);
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public static String getTypeSettingsValue(UnicodeProperties typeSettingsProperties, String typeSettingsKey) throws InvalidRepositoryException {
        String value = typeSettingsProperties.getProperty(typeSettingsKey);
        if (Validator.isNull((String)value)) {
            throw new InvalidRepositoryException("Properties value cannot be null for key " + typeSettingsKey);
        }
        return value;
    }

    protected static Repository getCMISRepository(Map<String, String> parameters) {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(CMISRepositoryUtil.class.getClassLoader());){
            List repositories = _sessionFactory.getRepositories(parameters);
            Repository repository = (Repository)repositories.get(0);
            return repository;
        }
    }

    static {
        _sessionFactory = SessionFactoryImpl.newInstance();
        HashSet<String> defaultFilterSet = new HashSet<String>();
        defaultFilterSet.add("cmis:baseTypeId");
        defaultFilterSet.add("cmis:createdBy");
        defaultFilterSet.add("cmis:creationDate");
        defaultFilterSet.add("cmis:lastModificationDate");
        defaultFilterSet.add("cmis:lastModifiedBy");
        defaultFilterSet.add("cmis:name");
        defaultFilterSet.add("cmis:objectId");
        defaultFilterSet.add("cmis:objectTypeId");
        defaultFilterSet.add("cmis:contentStreamLength");
        defaultFilterSet.add("cmis:contentStreamMimeType");
        defaultFilterSet.add("cmis:isVersionSeriesCheckedOut");
        defaultFilterSet.add("cmis:versionLabel");
        defaultFilterSet.add("cmis:versionSeriesCheckedOutBy");
        defaultFilterSet.add("cmis:versionSeriesCheckedOutId");
        defaultFilterSet.add("cmis:versionSeriesId");
        defaultFilterSet.add("cmis:parentId");
        defaultFilterSet.add("cmis:path");
        _operationContext = new OperationContextImpl(defaultFilterSet, false, true, false, IncludeRelationships.NONE, null, false, "cmis:name ASC", true, 1000);
    }
}

