/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.cmis.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.capabilities.PortalCapabilityLocator;
import com.liferay.portal.kernel.repository.capabilities.ProcessorCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.registry.BaseRepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.CapabilityRegistry;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.chemistry.opencmis.client.api.Document;

public abstract class BaseCMISRepositoryDefiner
extends BaseRepositoryDefiner {
    private static final String _MODEL_RESOURCE_NAME_PREFIX = "model.resource.";

    public String getRepositoryTypeLabel(Locale locale) {
        ResourceBundleLoader resourceBundleLoader = this.getResourceBundleLoader();
        ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
        return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)(_MODEL_RESOURCE_NAME_PREFIX + this.getClassName()));
    }

    public void registerCapabilities(CapabilityRegistry<DocumentRepository> capabilityRegistry) {
        DocumentRepository documentRepository = (DocumentRepository)capabilityRegistry.getTarget();
        PortalCapabilityLocator portalCapabilityLocator = this.getPortalCapabilityLocator();
        capabilityRegistry.addSupportedCapability(ProcessorCapability.class, (Capability)new RefreshingProcessorCapability(portalCapabilityLocator.getProcessorCapability(documentRepository, ProcessorCapability.ResourceGenerationStrategy.REUSE)));
    }

    protected abstract PortalCapabilityLocator getPortalCapabilityLocator();

    protected ResourceBundleLoader getResourceBundleLoader() {
        return ResourceBundleLoaderUtil.getResourceBundleLoaderByBundleSymbolicName((String)"com.liferay.document.library.repository.cmis.impl");
    }

    private static class RefreshingProcessorCapability
    implements ProcessorCapability {
        private final ProcessorCapability _processorCapability;

        public RefreshingProcessorCapability(ProcessorCapability processorCapability) {
            this._processorCapability = processorCapability;
        }

        public void cleanUp(FileEntry fileEntry) throws PortalException {
            this._refresh(fileEntry);
            this._processorCapability.cleanUp(fileEntry);
        }

        public void cleanUp(FileVersion fileVersion) throws PortalException {
            this._refresh(fileVersion);
            this._processorCapability.cleanUp(fileVersion);
        }

        public void copy(FileEntry fileEntry, FileVersion fileVersion) throws PortalException {
            this._refresh(fileEntry);
            this._refresh(fileVersion);
            this._processorCapability.copy(fileEntry, fileVersion);
        }

        public void generateNew(FileEntry fileEntry) throws PortalException {
            this._refresh(fileEntry);
            this._processorCapability.generateNew(fileEntry);
        }

        private void _refresh(FileEntry fileEntry) {
            Document document = (Document)fileEntry.getModel();
            document.refresh();
        }

        private void _refresh(FileVersion fileVersion) throws PortalException {
            Document document = (Document)fileVersion.getModel();
            document.refresh();
            this._refresh(fileVersion.getFileEntry());
        }
    }
}

