/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.cmis.internal;

import com.liferay.document.library.repository.cmis.CMISRepositoryHandler;
import com.liferay.document.library.repository.cmis.Session;
import com.liferay.document.library.repository.cmis.internal.CMISRepositoryUtil;
import com.liferay.portal.kernel.exception.InvalidRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.HashMap;
import java.util.Locale;
import org.apache.chemistry.opencmis.commons.enums.BindingType;

public class CMISWebServicesRepository
extends CMISRepositoryHandler {
    public Session getSession() throws PortalException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
        parameters.put("org.apache.chemistry.opencmis.binding.compression", Boolean.TRUE.toString());
        Locale locale = LocaleUtil.getSiteDefault();
        parameters.put("org.apache.chemistry.opencmis.locale.iso3166", locale.getCountry());
        parameters.put("org.apache.chemistry.opencmis.locale.iso639", locale.getLanguage());
        String password = PrincipalThreadLocal.getPassword();
        parameters.put("org.apache.chemistry.opencmis.password", password);
        String login = this.getLogin();
        parameters.put("org.apache.chemistry.opencmis.user", login);
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", this.getTypeSettingsValue("WEBSERVICES_ACL_SERVICE"));
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", this.getTypeSettingsValue("WEBSERVICES_DISCOVERY_SERVICE"));
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", this.getTypeSettingsValue("WEBSERVICES_MULTIFILING_SERVICE"));
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", this.getTypeSettingsValue("WEBSERVICES_NAVIGATION_SERVICE"));
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", this.getTypeSettingsValue("WEBSERVICES_OBJECT_SERVICE"));
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", this.getTypeSettingsValue("WEBSERVICES_POLICY_SERVICE"));
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", this.getTypeSettingsValue("WEBSERVICES_RELATIONSHIP_SERVICE"));
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", this.getTypeSettingsValue("WEBSERVICES_REPOSITORY_SERVICE"));
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", this.getTypeSettingsValue("WEBSERVICES_VERSIONING_SERVICE"));
        CMISRepositoryUtil.checkRepository(this.getRepositoryId(), parameters, this.getTypeSettingsProperties(), "REPOSITORY_ID");
        return CMISRepositoryUtil.createSession(parameters);
    }

    protected String getTypeSettingsValue(String typeSettingsKey) throws InvalidRepositoryException {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        return CMISRepositoryUtil.getTypeSettingsValue(typeSettingsProperties, typeSettingsKey);
    }
}

