/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.cmis.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class CMISParameterValueUtil {
    private static final String _INDEX_DATE_FORMAT_PATTERN = PropsUtil.get((String)"index.date.format.pattern");
    private static final Log _log = LogFactoryUtil.getLog(CMISParameterValueUtil.class);

    public static String formatParameterValue(String field, String value) {
        return CMISParameterValueUtil.formatParameterValue(field, value, false, null);
    }

    public static String formatParameterValue(String field, String value, boolean wildcard) {
        return CMISParameterValueUtil.formatParameterValue(field, value, wildcard, null);
    }

    public static String formatParameterValue(String field, String value, boolean wildcard, QueryConfig queryConfig) {
        if (field.equals("createDate") || field.equals("modified")) {
            try {
                DateFormat searchSimpleDateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)_INDEX_DATE_FORMAT_PATTERN);
                Date date = searchSimpleDateFormat.parse(value);
                DateFormat cmisSimpleDateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.000'Z'");
                value = cmisSimpleDateFormat.format(date);
            }
            catch (ParseException pe) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to parse date ", value, " for field ", field}));
                }
            }
        } else {
            String productName = "";
            if (queryConfig != null) {
                productName = (String)((Object)queryConfig.getAttribute("repositoryProductName"));
            }
            value = Validator.isNotNull((String)productName) && productName.startsWith("Alfresco") ? StringUtil.replace((String)value, (char)'\'', (String)"\\'") : StringUtil.replace((String)value, (char[])new char[]{'\'', '_'}, (String[])new String[]{"\\'", "\\_"});
            if (wildcard) {
                value = StringUtil.replace((String)value, (char[])new char[]{'%', '*'}, (String[])new String[]{"\\%", "%"});
            }
        }
        return value;
    }
}

