/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.cmis.search;

import com.liferay.document.library.repository.cmis.search.CMISBetweenExpression;
import com.liferay.document.library.repository.cmis.search.CMISConjunction;
import com.liferay.document.library.repository.cmis.search.CMISContainsExpression;
import com.liferay.document.library.repository.cmis.search.CMISContainsNotExpression;
import com.liferay.document.library.repository.cmis.search.CMISContainsValueExpression;
import com.liferay.document.library.repository.cmis.search.CMISCriterion;
import com.liferay.document.library.repository.cmis.search.CMISDisjunction;
import com.liferay.document.library.repository.cmis.search.CMISFullTextConjunction;
import com.liferay.document.library.repository.cmis.search.CMISInFolderExpression;
import com.liferay.document.library.repository.cmis.search.CMISInTreeExpression;
import com.liferay.document.library.repository.cmis.search.CMISJunction;
import com.liferay.document.library.repository.cmis.search.CMISNotExpression;
import com.liferay.document.library.repository.cmis.search.CMISParameterValueUtil;
import com.liferay.document.library.repository.cmis.search.CMISSearchQueryBuilder;
import com.liferay.document.library.repository.cmis.search.CMISSimpleExpression;
import com.liferay.document.library.repository.cmis.search.CMISSimpleExpressionOperator;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.RepositoryEntry;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.QueryTerm;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermRangeQuery;
import com.liferay.portal.kernel.search.WildcardQuery;
import com.liferay.portal.kernel.search.generic.MatchQuery;
import com.liferay.portal.kernel.service.RepositoryEntryLocalService;
import com.liferay.portal.kernel.service.RepositoryEntryLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class BaseCmisSearchQueryBuilder
implements CMISSearchQueryBuilder {
    private static final String _STAR_PATTERN = Pattern.quote("*");
    private static final Log _log = LogFactoryUtil.getLog(BaseCmisSearchQueryBuilder.class);
    private static final Map<String, String> _cmisFields = new HashMap<String, String>();
    private static final Set<String> _supportedFields;
    private final RepositoryEntryLocalService _repositoryEntryLocalService;
    private final UserLocalService _userLocalService;

    public BaseCmisSearchQueryBuilder() {
        this(RepositoryEntryLocalServiceUtil.getService(), UserLocalServiceUtil.getService());
    }

    @Override
    public String buildQuery(SearchContext searchContext, Query query) throws SearchException {
        StringBundler sb = new StringBundler();
        sb.append("SELECT cmis:objectId");
        QueryConfig queryConfig = searchContext.getQueryConfig();
        if (queryConfig.isScoreEnabled()) {
            sb.append(", SCORE() AS HITS");
        }
        sb.append(" FROM cmis:document");
        CMISDisjunction cmisDisjunction = new CMISDisjunction();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Repository query support " + queryConfig.getAttribute("capabilityQuery")));
        }
        if (!this.isSupportsOnlyFullText(queryConfig)) {
            this.traversePropertiesQuery(cmisDisjunction, query, queryConfig);
        }
        if (this.isSupportsFullText(queryConfig)) {
            CMISContainsExpression cmisContainsExpression = new CMISContainsExpression();
            this.traverseContentQuery(cmisContainsExpression, query, queryConfig);
            if (!cmisContainsExpression.isEmpty()) {
                cmisDisjunction.add(cmisContainsExpression);
            }
        }
        if (!cmisDisjunction.isEmpty()) {
            sb.append(" WHERE ");
            sb.append(cmisDisjunction.toQueryFragment());
        }
        Object[] sorts = searchContext.getSorts();
        if (queryConfig.isScoreEnabled() || ArrayUtil.isNotEmpty((Object[])sorts)) {
            sb.append(" ORDER BY ");
        }
        if (ArrayUtil.isNotEmpty((Object[])sorts)) {
            int i = 0;
            for (Object sort : sorts) {
                String fieldName = sort.getFieldName();
                if (!this.isSupportedField(fieldName)) continue;
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getCmisField(fieldName));
                if (sort.isReverse()) {
                    sb.append(" DESC");
                } else {
                    sb.append(" ASC");
                }
                ++i;
            }
        } else if (queryConfig.isScoreEnabled()) {
            sb.append("HITS DESC");
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("CMIS query " + sb));
        }
        return sb.toString();
    }

    protected BaseCmisSearchQueryBuilder(RepositoryEntryLocalService repositoryEntryLocalService, UserLocalService userLocalService) {
        this._repositoryEntryLocalService = repositoryEntryLocalService;
        this._userLocalService = userLocalService;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CMISCriterion buildFieldExpression(String field, String value, CMISSimpleExpressionOperator cmisSimpleExpressionOperator, QueryConfig queryConfig) throws SearchException {
        void var5_11;
        Object var5_5 = null;
        boolean wildcard = false;
        if (CMISSimpleExpressionOperator.LIKE == cmisSimpleExpressionOperator) {
            wildcard = true;
        }
        if (field.equals("folderId")) {
            long folderId = GetterUtil.getLong((String)value);
            try {
                RepositoryEntry repositoryEntry = this._repositoryEntryLocalService.fetchRepositoryEntry(folderId);
                if (repositoryEntry == null) return var5_11;
                String objectId = repositoryEntry.getMappedId();
                objectId = CMISParameterValueUtil.formatParameterValue(field, objectId, wildcard, queryConfig);
                if (queryConfig.isSearchSubfolders()) {
                    CMISInTreeExpression cMISInTreeExpression = new CMISInTreeExpression(objectId);
                    return var5_11;
                }
                CMISInFolderExpression cMISInFolderExpression = new CMISInFolderExpression(objectId);
                return var5_11;
            }
            catch (SystemException se) {
                throw new SearchException("Unable to determine folder {folderId=" + folderId + "}", (Throwable)se);
            }
        } else if (field.equals("userId")) {
            try {
                long userId = GetterUtil.getLong((String)value);
                User user = this._userLocalService.getUserById(userId);
                String screenName = CMISParameterValueUtil.formatParameterValue(field, user.getScreenName(), wildcard, queryConfig);
                CMISSimpleExpression cMISSimpleExpression = new CMISSimpleExpression(this.getCmisField(field), screenName, cmisSimpleExpressionOperator);
                return var5_11;
            }
            catch (Exception e) {
                if (!(e instanceof SearchException)) throw new SearchException("Unable to determine user {" + field + "=" + value + "}", (Throwable)e);
                throw (SearchException)e;
            }
        } else {
            value = CMISParameterValueUtil.formatParameterValue(field, value, wildcard, queryConfig);
            CMISSimpleExpression cMISSimpleExpression = new CMISSimpleExpression(this.getCmisField(field), value, cmisSimpleExpressionOperator);
        }
        return var5_11;
    }

    protected String getCmisField(String field) {
        return _cmisFields.get(field);
    }

    protected boolean isSupportedField(String field) {
        return _supportedFields.contains(field);
    }

    protected boolean isSupportsFullText(QueryConfig queryConfig) {
        String capabilityQuery = (String)((Object)queryConfig.getAttribute("capabilityQuery"));
        if (Validator.isNull((String)capabilityQuery)) {
            return false;
        }
        return capabilityQuery.equals("bothcombined") || capabilityQuery.equals("fulltextonly");
    }

    protected boolean isSupportsOnlyFullText(QueryConfig queryConfig) {
        String capabilityQuery = (String)((Object)queryConfig.getAttribute("capabilityQuery"));
        if (Validator.isNull((String)capabilityQuery)) {
            return false;
        }
        return capabilityQuery.equals("fulltextonly");
    }

    protected void traverseContentQuery(CMISJunction cmisJunction, Query query, QueryConfig queryConfig) throws SearchException {
        if (query instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            List booleanClauses = booleanQuery.clauses();
            CMISFullTextConjunction anyCMISConjunction = new CMISFullTextConjunction();
            CMISDisjunction cmisDisjunction = new CMISDisjunction();
            CMISFullTextConjunction notCMISConjunction = new CMISFullTextConjunction();
            for (BooleanClause booleanClause : booleanClauses) {
                CMISJunction currentCMISJunction = cmisDisjunction;
                BooleanClauseOccur booleanClauseOccur = booleanClause.getBooleanClauseOccur();
                if (booleanClauseOccur.equals(BooleanClauseOccur.MUST)) {
                    currentCMISJunction = anyCMISConjunction;
                } else if (booleanClauseOccur.equals(BooleanClauseOccur.MUST_NOT)) {
                    currentCMISJunction = notCMISConjunction;
                }
                Query booleanClauseQuery = (Query)booleanClause.getClause();
                this.traverseContentQuery(currentCMISJunction, booleanClauseQuery, queryConfig);
            }
            if (!anyCMISConjunction.isEmpty()) {
                cmisJunction.add(anyCMISConjunction);
            }
            if (!cmisDisjunction.isEmpty()) {
                cmisJunction.add(cmisDisjunction);
            }
            if (!notCMISConjunction.isEmpty()) {
                CMISContainsNotExpression cmisContainsNotExpression = new CMISContainsNotExpression(notCMISConjunction);
                cmisJunction.add(cmisContainsNotExpression);
            }
        } else if (query instanceof TermQuery) {
            TermQuery termQuery = (TermQuery)query;
            QueryTerm queryTerm = termQuery.getQueryTerm();
            if (!this._isContentFieldQueryTerm(queryTerm)) {
                return;
            }
            String field = queryTerm.getField();
            String value = queryTerm.getValue();
            value = CMISParameterValueUtil.formatParameterValue(field, value, false, queryConfig);
            CMISContainsValueExpression cmisContainsValueExpression = new CMISContainsValueExpression(value);
            cmisJunction.add(cmisContainsValueExpression);
        } else if (query instanceof WildcardQuery) {
            WildcardQuery wildcardQuery = (WildcardQuery)query;
            QueryTerm queryTerm = wildcardQuery.getQueryTerm();
            if (!this._isContentFieldQueryTerm(queryTerm)) {
                return;
            }
            String value = queryTerm.getValue();
            String[] terms = value.split(_STAR_PATTERN);
            CMISConjunction cmisConjunction = new CMISConjunction();
            for (String term : terms) {
                if (!Validator.isNotNull((String)term)) continue;
                CMISContainsValueExpression containsValueExpression = new CMISContainsValueExpression(term);
                cmisConjunction.add(containsValueExpression);
            }
            cmisJunction.add(cmisConjunction);
        } else if (query instanceof TermRangeQuery) {
            return;
        }
    }

    protected void traversePropertiesQuery(CMISJunction cmisJunction, Query query, QueryConfig queryConfig) throws SearchException {
        if (query instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            List booleanClauses = booleanQuery.clauses();
            CMISConjunction anyCMISConjunction = new CMISConjunction();
            CMISDisjunction cmisDisjunction = new CMISDisjunction();
            CMISConjunction notCMISConjunction = new CMISConjunction();
            for (BooleanClause booleanClause : booleanClauses) {
                CMISJunction currentCMISJunction = cmisDisjunction;
                BooleanClauseOccur booleanClauseOccur = booleanClause.getBooleanClauseOccur();
                if (booleanClauseOccur.equals(BooleanClauseOccur.MUST)) {
                    currentCMISJunction = anyCMISConjunction;
                } else if (booleanClauseOccur.equals(BooleanClauseOccur.MUST_NOT)) {
                    currentCMISJunction = notCMISConjunction;
                }
                Query booleanClauseQuery = (Query)booleanClause.getClause();
                this.traversePropertiesQuery(currentCMISJunction, booleanClauseQuery, queryConfig);
            }
            if (!anyCMISConjunction.isEmpty()) {
                cmisJunction.add(anyCMISConjunction);
            }
            if (!cmisDisjunction.isEmpty()) {
                cmisJunction.add(cmisDisjunction);
            }
            if (!notCMISConjunction.isEmpty()) {
                cmisJunction.add(new CMISNotExpression(notCMISConjunction));
            }
        } else if (query instanceof MatchQuery) {
            MatchQuery matchQuery = (MatchQuery)query;
            if (!this.isSupportedField(matchQuery.getField())) {
                return;
            }
            CMISCriterion cmisCriterion = this.buildFieldExpression(matchQuery.getField(), matchQuery.getValue(), CMISSimpleExpressionOperator.EQ, queryConfig);
            if (cmisCriterion != null) {
                cmisJunction.add(cmisCriterion);
            }
        } else if (query instanceof TermQuery) {
            TermQuery termQuery = (TermQuery)query;
            QueryTerm queryTerm = termQuery.getQueryTerm();
            if (!this.isSupportedField(queryTerm.getField())) {
                return;
            }
            CMISCriterion cmisCriterion = this.buildFieldExpression(queryTerm.getField(), queryTerm.getValue(), CMISSimpleExpressionOperator.EQ, queryConfig);
            if (cmisCriterion != null) {
                cmisJunction.add(cmisCriterion);
            }
        } else if (query instanceof TermRangeQuery) {
            TermRangeQuery termRangeQuery = (TermRangeQuery)query;
            if (!this.isSupportedField(termRangeQuery.getField())) {
                return;
            }
            String fieldName = termRangeQuery.getField();
            String cmisField = this.getCmisField(fieldName);
            String cmisLowerTerm = CMISParameterValueUtil.formatParameterValue(fieldName, termRangeQuery.getLowerTerm(), false, queryConfig);
            String cmisUpperTerm = CMISParameterValueUtil.formatParameterValue(fieldName, termRangeQuery.getUpperTerm(), false, queryConfig);
            CMISBetweenExpression cmisCriterion = new CMISBetweenExpression(cmisField, cmisLowerTerm, cmisUpperTerm, termRangeQuery.includesLower(), termRangeQuery.includesUpper());
            cmisJunction.add(cmisCriterion);
        } else if (query instanceof WildcardQuery) {
            WildcardQuery wildcardQuery = (WildcardQuery)query;
            QueryTerm queryTerm = wildcardQuery.getQueryTerm();
            if (!this.isSupportedField(queryTerm.getField())) {
                return;
            }
            CMISCriterion cmisCriterion = this.buildFieldExpression(queryTerm.getField(), queryTerm.getValue(), CMISSimpleExpressionOperator.LIKE, queryConfig);
            if (cmisCriterion != null) {
                cmisJunction.add(cmisCriterion);
            }
        }
    }

    private boolean _isContentFieldQueryTerm(QueryTerm queryTerm) {
        String fieldName = queryTerm.getField();
        return fieldName.equals("content");
    }

    static {
        _cmisFields.put("createDate", "cmis:creationDate");
        _cmisFields.put("modified", "cmis:lastModificationDate");
        _cmisFields.put("name", "cmis:name");
        _cmisFields.put("title", "cmis:name");
        _cmisFields.put("userId", "cmis:createdBy");
        _cmisFields.put("userName", "cmis:createdBy");
        _supportedFields = new HashSet<String>();
        _supportedFields.add("createDate");
        _supportedFields.add("folderId");
        _supportedFields.add("modified");
        _supportedFields.add("name");
        _supportedFields.add("title");
        _supportedFields.add("userId");
        _supportedFields.add("userName");
    }
}

