/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.preview.pdf.internal.messaging;

import com.liferay.document.library.kernel.processor.PDFProcessorUtil;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portlet.documentlibrary.messaging.BaseProcessorMessageListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/document_library_pdf_processor"}, service={MessageListener.class})
public class PDFProcessorMessageListener
extends BaseProcessorMessageListener {
    @Reference
    private DestinationFactory _destinationFactory;
    private ServiceRegistration<Destination> _serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext) {
        Destination destination = this._destinationFactory.createDestination(new DestinationConfiguration("serial", "liferay/document_library_pdf_processor"));
        this._serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    protected void generate(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        if (CTCollectionThreadLocal.isProductionMode() || !(destinationFileVersion instanceof LiferayFileVersion)) {
            PDFProcessorUtil.generateImages((FileVersion)sourceFileVersion, (FileVersion)destinationFileVersion);
            return;
        }
        LiferayFileVersion liferayFileVersion = (LiferayFileVersion)destinationFileVersion;
        long ctCollectionId = liferayFileVersion.getCTCollectionId();
        if (ctCollectionId == CTCollectionThreadLocal.getCTCollectionId()) {
            PDFProcessorUtil.generateImages((FileVersion)sourceFileVersion, (FileVersion)destinationFileVersion);
        } else {
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollectionId);){
                PDFProcessorUtil.generateImages((FileVersion)sourceFileVersion, (FileVersion)destinationFileVersion);
            }
        }
    }
}

