/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.preview.pdf.internal;

import com.liferay.portal.image.ImageToolUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class LiferayPDFBoxUtil {
    public static void generateImagesPB(PDDocument pdDocument, File thumbnailFile, File[] previewFiles, String extension, String thumbnailExtension, int dpi, int height, int width, boolean generatePreview, boolean generateThumbnail, int maxNumberOfPages) throws Exception {
        PDFRenderer pdfRenderer = new PDFRenderer(pdDocument);
        PDPageTree pdPageTree = pdDocument.getPages();
        if (maxNumberOfPages == 0 || maxNumberOfPages > pdPageTree.getCount()) {
            maxNumberOfPages = pdPageTree.getCount();
        }
        for (int i = 0; i < maxNumberOfPages; ++i) {
            RenderedImage renderedImage = LiferayPDFBoxUtil._toRenderedImage(pdfRenderer, i, dpi, height, width);
            if (generateThumbnail && i == 0) {
                ImageIO.write(renderedImage, thumbnailExtension, thumbnailFile);
            }
            if (!generatePreview) break;
            ImageIO.write(renderedImage, extension, previewFiles[i]);
        }
    }

    private static RenderedImage _toRenderedImage(PDFRenderer pdfRenderer, int pageIndex, int dpi, int height, int width) throws Exception {
        BufferedImage renderedImage = pdfRenderer.renderImageWithDPI(pageIndex, (float)dpi, ImageType.RGB);
        if (height == 0) {
            return ImageToolUtil.scale((RenderedImage)renderedImage, (int)width);
        }
        return ImageToolUtil.scale((RenderedImage)renderedImage, (int)height, (int)width);
    }
}

