/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.preview.image.internal;

import com.liferay.document.library.kernel.util.DLProcessorRegistryUtil;
import com.liferay.document.library.kernel.util.ImageProcessorUtil;
import com.liferay.document.library.preview.DLPreviewRenderer;
import com.liferay.document.library.preview.DLPreviewRendererProvider;
import com.liferay.document.library.preview.exception.DLFileEntryPreviewGenerationException;
import com.liferay.document.library.preview.exception.DLPreviewGenerationInProcessException;
import com.liferay.document.library.preview.exception.DLPreviewSizeException;
import com.liferay.document.library.service.DLFileVersionPreviewLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileVersion;
import java.util.Optional;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ImageDLPreviewRendererProvider
implements DLPreviewRendererProvider {
    private final DLFileVersionPreviewLocalService _dlFileVersionPreviewLocalService;
    private final ServletContext _servletContext;

    public ImageDLPreviewRendererProvider(DLFileVersionPreviewLocalService dlFileVersionPreviewLocalService, ServletContext servletContext) {
        this._dlFileVersionPreviewLocalService = dlFileVersionPreviewLocalService;
        this._servletContext = servletContext;
    }

    public Optional<DLPreviewRenderer> getPreviewDLPreviewRendererOptional(FileVersion fileVersion) {
        if (!DLProcessorRegistryUtil.isPreviewableSize((FileVersion)fileVersion)) {
            return Optional.of((httpServletRequest, httpServletResponse) -> {
                throw new DLPreviewSizeException();
            });
        }
        if (!ImageProcessorUtil.isImageSupported((FileVersion)fileVersion)) {
            return Optional.empty();
        }
        return Optional.of((request, response) -> {
            this.checkForPreviewGenerationExceptions(fileVersion);
            RequestDispatcher requestDispatcher = this._servletContext.getRequestDispatcher("/preview/view.jsp");
            request.setAttribute("DOCUMENT_LIBRARY_FILE_VERSION", (Object)fileVersion);
            requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
        });
    }

    public Optional<DLPreviewRenderer> getThumbnailDLPreviewRendererOptional(FileVersion fileVersion) {
        return Optional.empty();
    }

    protected void checkForPreviewGenerationExceptions(FileVersion fileVersion) throws PortalException {
        if (this._dlFileVersionPreviewLocalService.hasDLFileVersionPreview(fileVersion.getFileEntryId(), fileVersion.getFileVersionId(), 1)) {
            throw new DLFileEntryPreviewGenerationException();
        }
        if (!ImageProcessorUtil.hasImages((FileVersion)fileVersion)) {
            throw new DLPreviewGenerationInProcessException();
        }
    }
}

