/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.opener.google.drive.constants;

import com.liferay.document.library.opener.constants.DLOpenerMimeTypes;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;

public class DLOpenerGoogleDriveMimeTypes {
    @Deprecated
    public static final String APPLICATION_RTF = "application/rtf";
    @Deprecated
    public static final String APPLICATION_VND_DOCX = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    public static final String APPLICATION_VND_GOOGLE_APPS_DOCUMENT = "application/vnd.google-apps.document";
    public static final String APPLICATION_VND_GOOGLE_APPS_PRESENTATION = "application/vnd.google-apps.presentation";
    public static final String APPLICATION_VND_GOOGLE_APPS_SPREADSHEET = "application/vnd.google-apps.spreadsheet";
    @Deprecated
    public static final String APPLICATION_VND_ODP = "application/vnd.oasis.opendocument.presentation";
    @Deprecated
    public static final String APPLICATION_VND_ODS = "application/vnd.oasis.opendocument.spreadsheet";
    @Deprecated
    public static final String APPLICATION_VND_ODT = "application/vnd.oasis.opendocument.text";
    @Deprecated
    public static final String APPLICATION_VND_PPTX = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
    @Deprecated
    public static final String APPLICATION_VND_XSLX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    @Deprecated
    public static final String TEXT_TAB_SEPARATED_VALUES = "text/tab-separated-values";
    private static final Map<String, String> _googleDocsMimeTypes = MapUtil.fromArray((Object[])new String[]{"application/pdf", "application/vnd.google-apps.document", "application/rtf", "application/vnd.google-apps.document", "application/text", "application/vnd.google-apps.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.google-apps.document", "application/vnd.oasis.opendocument.presentation", "application/vnd.google-apps.presentation", "application/vnd.oasis.opendocument.spreadsheet", "application/vnd.google-apps.spreadsheet", "application/vnd.oasis.opendocument.text", "application/vnd.google-apps.document", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.google-apps.presentation", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.google-apps.spreadsheet", "text", "application/vnd.google-apps.document", "text/csv", "application/vnd.google-apps.spreadsheet", "text/html", "application/vnd.google-apps.document", "text/plain", "application/vnd.google-apps.document", "text/tab-separated-values", "application/vnd.google-apps.spreadsheet"});

    public static String getGoogleDocsMimeType(String mimeType) {
        if (!DLOpenerGoogleDriveMimeTypes.isGoogleMimeTypeSupported(mimeType)) {
            throw new UnsupportedOperationException(StringBundler.concat((String[])new String[]{"Google Docs does not support edition of documents of ", "type ", mimeType}));
        }
        return _googleDocsMimeTypes.get(mimeType);
    }

    public static String getMimeTypeExtension(String mimeType) {
        return DLOpenerMimeTypes.extensions.getOrDefault(mimeType, "");
    }

    public static boolean isGoogleMimeTypeSupported(String mimeType) {
        return _googleDocsMimeTypes.containsKey(mimeType);
    }

    @Deprecated
    public static boolean isMimeTypeSupported(String mimeType) {
        return DLOpenerGoogleDriveMimeTypes.isGoogleMimeTypeSupported(mimeType);
    }
}

