/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.item.selector.web.internal.display.context;

import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetVocabularyService;
import com.liferay.document.library.item.selector.web.internal.DLItemSelectorView;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.ItemSelectorReturnTypeResolver;
import com.liferay.item.selector.ItemSelectorReturnTypeResolverHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.staging.StagingGroupHelper;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class DLItemSelectorViewDisplayContext<T extends ItemSelectorCriterion> {
    private final AssetVocabularyService _assetVocabularyService;
    private final ClassNameLocalService _classNameLocalService;
    private final DLItemSelectorView<T> _dlItemSelectorView;
    private final String _itemSelectedEventName;
    private final T _itemSelectorCriterion;
    private final ItemSelectorReturnTypeResolverHandler _itemSelectorReturnTypeResolverHandler;
    private final PortletURL _portletURL;
    private final boolean _search;
    private final StagingGroupHelper _stagingGroupHelper;

    public DLItemSelectorViewDisplayContext(T itemSelectorCriterion, DLItemSelectorView<T> dlItemSelectorView, ItemSelectorReturnTypeResolverHandler itemSelectorReturnTypeResolverHandler, String itemSelectedEventName, boolean search, PortletURL portletURL, AssetVocabularyService assetVocabularyService, ClassNameLocalService classNameLocalService, StagingGroupHelper stagingGroupHelper) {
        this._itemSelectorCriterion = itemSelectorCriterion;
        this._dlItemSelectorView = dlItemSelectorView;
        this._itemSelectorReturnTypeResolverHandler = itemSelectorReturnTypeResolverHandler;
        this._itemSelectedEventName = itemSelectedEventName;
        this._search = search;
        this._portletURL = portletURL;
        this._assetVocabularyService = assetVocabularyService;
        this._classNameLocalService = classNameLocalService;
        this._stagingGroupHelper = stagingGroupHelper;
    }

    public String[] getExtensions() {
        return this._dlItemSelectorView.getExtensions();
    }

    public long getFolderId(HttpServletRequest httpServletRequest) {
        return ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"folderId", (long)0L);
    }

    public String getItemSelectedEventName() {
        return this._itemSelectedEventName;
    }

    public T getItemSelectorCriterion() {
        return this._itemSelectorCriterion;
    }

    public ItemSelectorReturnTypeResolver getItemSelectorReturnTypeResolver() {
        return this._itemSelectorReturnTypeResolverHandler.getItemSelectorReturnTypeResolver(this._itemSelectorCriterion, this._dlItemSelectorView, FileEntry.class);
    }

    public String[] getMimeTypes() {
        return this._dlItemSelectorView.getMimeTypes();
    }

    public PortletURL getPortletURL(HttpServletRequest httpServletRequest, LiferayPortletResponse liferayPortletResponse) throws PortletException {
        PortletURL portletURL = PortletURLUtil.clone((PortletURL)this._portletURL, (LiferayPortletResponse)liferayPortletResponse);
        portletURL.setParameter("folderId", String.valueOf(this.getFolderId(httpServletRequest)));
        portletURL.setParameter("selectedTab", String.valueOf(this.getTitle(httpServletRequest.getLocale())));
        return portletURL;
    }

    public long getStagingAwareGroupId(long scopeGroupId) {
        Group group;
        long groupId = scopeGroupId;
        if (this._stagingGroupHelper.isStagingGroup(scopeGroupId) && !this._stagingGroupHelper.isStagedPortlet(scopeGroupId, "com_liferay_document_library_web_portlet_DLPortlet") && (group = this._stagingGroupHelper.fetchLiveGroup(scopeGroupId)) != null) {
            groupId = group.getGroupId();
        }
        return groupId;
    }

    public String getTitle(Locale locale) {
        return this._dlItemSelectorView.getTitle(locale);
    }

    public PortletURL getUploadURL(HttpServletRequest httpServletRequest, LiferayPortletResponse liferayPortletResponse) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        List assetVocabularies = this._assetVocabularyService.getGroupVocabularies(this.getStagingAwareGroupId(themeDisplay.getScopeGroupId()));
        if (!assetVocabularies.isEmpty()) {
            long classNameId = this._classNameLocalService.getClassNameId(DLFileEntryConstants.getClassName());
            for (AssetVocabulary assetVocabulary : assetVocabularies) {
                if (!assetVocabulary.isRequired(classNameId, 0L)) continue;
                return null;
            }
        }
        LiferayPortletURL portletURL = liferayPortletResponse.createActionURL("com_liferay_document_library_web_portlet_DLPortlet");
        portletURL.setParameter("javax.portlet.action", "/document_library/upload_file_entry");
        portletURL.setParameter("folderId", String.valueOf(this.getFolderId(httpServletRequest)));
        return portletURL;
    }

    public boolean isSearch() {
        return this._search;
    }
}

