/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.jsontoken.discovery;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.List;
import net.oauth.jsontoken.crypto.RsaSHA256Verifier;
import net.oauth.jsontoken.crypto.Verifier;
import net.oauth.jsontoken.discovery.ServerDescriptorProvider;
import net.oauth.jsontoken.discovery.ServerInfoResolver;
import net.oauth.jsontoken.discovery.VerifierProvider;

public class DefaultPublicKeyLocator
implements VerifierProvider {
    private final ServerDescriptorProvider descriptorProvider;
    private final ServerInfoResolver descriptorResolver;

    public DefaultPublicKeyLocator(ServerDescriptorProvider descriptorProvider, ServerInfoResolver resolver) {
        this.descriptorProvider = descriptorProvider;
        this.descriptorResolver = resolver;
    }

    @Override
    public List<Verifier> findVerifier(String issuer, String keyId) {
        URI serverDescriptor = this.descriptorProvider.getServerDescriptor(issuer);
        RsaSHA256Verifier rsaVerifier = new RsaSHA256Verifier(this.descriptorResolver.resolve(serverDescriptor).getVerificationKey(keyId));
        return Lists.newArrayList(rsaVerifier);
    }
}

