/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.demo.data.creator.internal;

import com.liferay.document.library.demo.data.creator.FileEntryDemoDataCreator;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"source=unsplash", "type=image"}, service={FileEntryDemoDataCreator.class})
public class UnsplashFileEntryDemoDataCreatorImpl
implements FileEntryDemoDataCreator {
    private static final List<String> _categories = new ArrayList<String>();
    private static final Log _log = LogFactoryUtil.getLog(UnsplashFileEntryDemoDataCreatorImpl.class);
    private int _categoryIndex = -1;
    private DLAppLocalService _dlAppLocalService;
    private final List<Long> _fileEntryIds = new CopyOnWriteArrayList<Long>();

    public FileEntry create(long userId, long folderId) throws IOException, PortalException {
        UUID uuid = UUID.randomUUID();
        String sourceFileName = uuid.toString() + ".jpeg";
        return this.create(userId, folderId, sourceFileName);
    }

    public FileEntry create(long userId, long folderId, String name) throws IOException, PortalException {
        Folder folder = this._dlAppLocalService.getFolder(folderId);
        FileEntry fileEntry = this._dlAppLocalService.addFileEntry(userId, folder.getGroupId(), folderId, name, "image/jpeg", this._getBytes(), new ServiceContext());
        this._fileEntryIds.add(fileEntry.getFileEntryId());
        return fileEntry;
    }

    public void delete() throws PortalException {
        block3: {
            try {
                for (long fileEntryId : this._fileEntryIds) {
                    this._fileEntryIds.remove(fileEntryId);
                    this._dlAppLocalService.deleteFileEntry(fileEntryId);
                }
            }
            catch (NoSuchFileEntryException nsfee) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)nsfee, (Throwable)nsfee);
            }
        }
    }

    @Reference(unbind="-")
    protected void setDlAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _getBytes() throws IOException {
        URL url = this._getNextUrl();
        try (InputStream inputStream = null;){
            inputStream = url.openStream();
            byte[] byArray = FileUtil.getBytes((InputStream)inputStream);
            return byArray;
        }
    }

    private URL _getNextUrl() throws MalformedURLException {
        ++this._categoryIndex;
        if (this._categoryIndex == _categories.size()) {
            this._categoryIndex = 0;
        }
        String urlString = String.format("https://source.unsplash.com/category/%s/1920x1080", _categories.get(this._categoryIndex));
        return new URL(urlString);
    }

    static {
        _categories.add("buildings");
        _categories.add("food");
        _categories.add("nature");
        _categories.add("people");
        _categories.add("technology");
        _categories.add("objects");
    }
}

