/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.demo.data.creator.internal;

import com.liferay.document.library.demo.data.creator.RootFolderDemoDataCreator;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RootFolderDemoDataCreator.class})
public class RootFolderDemoDataCreatorImpl
implements RootFolderDemoDataCreator {
    private static final Log _log = LogFactoryUtil.getLog(RootFolderDemoDataCreatorImpl.class);
    private DLAppLocalService _dlAppLocalService;
    private final List<Long> _folderIds = new CopyOnWriteArrayList<Long>();

    public Folder create(long userId, long groupId) throws PortalException {
        return this.create(userId, groupId, "Demo");
    }

    public Folder create(long userId, long groupId, String name) throws PortalException {
        Folder folder = this._dlAppLocalService.addFolder(userId, groupId, 0L, name, "", new ServiceContext());
        this._folderIds.add(folder.getFolderId());
        return folder;
    }

    public void delete() throws PortalException {
        block3: {
            try {
                for (long folderId : this._folderIds) {
                    this._folderIds.remove(folderId);
                    this._dlAppLocalService.deleteFolder(folderId);
                }
            }
            catch (NoSuchFolderException nsfe) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)nsfe, (Throwable)nsfe);
            }
        }
        this._folderIds.clear();
    }

    @Reference(unbind="-")
    protected void setDlAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }
}

