/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.content.service.persistence.impl;

import com.liferay.document.library.content.exception.NoSuchContentException;
import com.liferay.document.library.content.model.DLContent;
import com.liferay.document.library.content.model.DLContentTable;
import com.liferay.document.library.content.model.impl.DLContentImpl;
import com.liferay.document.library.content.model.impl.DLContentModelImpl;
import com.liferay.document.library.content.service.persistence.DLContentPersistence;
import com.liferay.document.library.content.service.persistence.impl.constants.DLPersistenceConstants;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.change.tracking.helper.CTPersistenceHelper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLContentPersistence.class})
public class DLContentPersistenceImpl
extends BasePersistenceImpl<DLContent>
implements DLContentPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = DLContentImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByC_R;
    private FinderPath _finderPathWithoutPaginationFindByC_R;
    private FinderPath _finderPathCountByC_R;
    private static final String _FINDER_COLUMN_C_R_COMPANYID_2 = "dlContent.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_R_REPOSITORYID_2 = "dlContent.repositoryId = ?";
    private FinderPath _finderPathWithPaginationFindByC_R_P;
    private FinderPath _finderPathWithoutPaginationFindByC_R_P;
    private FinderPath _finderPathCountByC_R_P;
    private static final String _FINDER_COLUMN_C_R_P_COMPANYID_2 = "dlContent.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_R_P_REPOSITORYID_2 = "dlContent.repositoryId = ? AND ";
    private static final String _FINDER_COLUMN_C_R_P_PATH_2 = "dlContent.path = ?";
    private static final String _FINDER_COLUMN_C_R_P_PATH_3 = "(dlContent.path IS NULL OR dlContent.path = '')";
    private FinderPath _finderPathWithPaginationFindByC_R_LikeP;
    private FinderPath _finderPathWithPaginationCountByC_R_LikeP;
    private static final String _FINDER_COLUMN_C_R_LIKEP_COMPANYID_2 = "dlContent.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_R_LIKEP_REPOSITORYID_2 = "dlContent.repositoryId = ? AND ";
    private static final String _FINDER_COLUMN_C_R_LIKEP_PATH_2 = "dlContent.path LIKE ?";
    private static final String _FINDER_COLUMN_C_R_LIKEP_PATH_3 = "(dlContent.path IS NULL OR dlContent.path LIKE '')";
    private FinderPath _finderPathFetchByC_R_P_V;
    private FinderPath _finderPathCountByC_R_P_V;
    private static final String _FINDER_COLUMN_C_R_P_V_COMPANYID_2 = "dlContent.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_R_P_V_REPOSITORYID_2 = "dlContent.repositoryId = ? AND ";
    private static final String _FINDER_COLUMN_C_R_P_V_PATH_2 = "dlContent.path = ? AND ";
    private static final String _FINDER_COLUMN_C_R_P_V_PATH_3 = "(dlContent.path IS NULL OR dlContent.path = '') AND ";
    private static final String _FINDER_COLUMN_C_R_P_V_VERSION_2 = "dlContent.version = ?";
    private static final String _FINDER_COLUMN_C_R_P_V_VERSION_3 = "(dlContent.version IS NULL OR dlContent.version = '')";
    private static final Map<CTColumnResolutionType, Set<String>> _ctColumnNamesMap = new EnumMap<CTColumnResolutionType, Set<String>>(CTColumnResolutionType.class);
    private static final List<String> _mappingTableNames = new ArrayList<String>();
    private static final List<String[]> _uniqueIndexColumnNames = new ArrayList<String[]>();
    private BundleContext _bundleContext;
    @Reference
    protected CTPersistenceHelper ctPersistenceHelper;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_DLCONTENT = "SELECT dlContent FROM DLContent dlContent";
    private static final String _SQL_SELECT_DLCONTENT_WHERE = "SELECT dlContent FROM DLContent dlContent WHERE ";
    private static final String _SQL_COUNT_DLCONTENT = "SELECT COUNT(dlContent) FROM DLContent dlContent";
    private static final String _SQL_COUNT_DLCONTENT_WHERE = "SELECT COUNT(dlContent) FROM DLContent dlContent WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "dlContent.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No DLContent exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No DLContent exists with the key {";
    private static final Log _log;
    private static final Set<String> _badColumnNames;
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;
    private Set<ServiceRegistration<FinderPath>> _serviceRegistrations = new HashSet<ServiceRegistration<FinderPath>>();

    public List<DLContent> findByC_R(long companyId, long repositoryId) {
        return this.findByC_R(companyId, repositoryId, -1, -1, null);
    }

    public List<DLContent> findByC_R(long companyId, long repositoryId, int start, int end) {
        return this.findByC_R(companyId, repositoryId, start, end, null);
    }

    public List<DLContent> findByC_R(long companyId, long repositoryId, int start, int end, OrderByComparator<DLContent> orderByComparator) {
        return this.findByC_R(companyId, repositoryId, start, end, orderByComparator, true);
    }

    public List<DLContent> findByC_R(long companyId, long repositoryId, int start, int end, OrderByComparator<DLContent> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLContent.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByC_R;
                finderArgs = new Object[]{companyId, repositoryId};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByC_R;
            finderArgs = new Object[]{companyId, repositoryId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DLContent dlContent : list) {
                if (companyId == dlContent.getCompanyId() && repositoryId == dlContent.getRepositoryId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_DLCONTENT_WHERE);
            sb.append("dlContent.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_R_REPOSITORYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY dlContent.version DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(repositoryId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DLContent findByC_R_First(long companyId, long repositoryId, OrderByComparator<DLContent> orderByComparator) throws NoSuchContentException {
        DLContent dlContent = this.fetchByC_R_First(companyId, repositoryId, orderByComparator);
        if (dlContent != null) {
            return dlContent;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", repositoryId=");
        sb.append(repositoryId);
        sb.append("}");
        throw new NoSuchContentException(sb.toString());
    }

    public DLContent fetchByC_R_First(long companyId, long repositoryId, OrderByComparator<DLContent> orderByComparator) {
        List<DLContent> list = this.findByC_R(companyId, repositoryId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DLContent findByC_R_Last(long companyId, long repositoryId, OrderByComparator<DLContent> orderByComparator) throws NoSuchContentException {
        DLContent dlContent = this.fetchByC_R_Last(companyId, repositoryId, orderByComparator);
        if (dlContent != null) {
            return dlContent;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", repositoryId=");
        sb.append(repositoryId);
        sb.append("}");
        throw new NoSuchContentException(sb.toString());
    }

    public DLContent fetchByC_R_Last(long companyId, long repositoryId, OrderByComparator<DLContent> orderByComparator) {
        int count = this.countByC_R(companyId, repositoryId);
        if (count == 0) {
            return null;
        }
        List<DLContent> list = this.findByC_R(companyId, repositoryId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DLContent[] findByC_R_PrevAndNext(long contentId, long companyId, long repositoryId, OrderByComparator<DLContent> orderByComparator) throws NoSuchContentException {
        DLContent dlContent = this.findByPrimaryKey(contentId);
        Session session = null;
        try {
            session = this.openSession();
            DLContent[] array = new DLContentImpl[]{this.getByC_R_PrevAndNext(session, dlContent, companyId, repositoryId, orderByComparator, true), dlContent, this.getByC_R_PrevAndNext(session, dlContent, companyId, repositoryId, orderByComparator, false)};
            DLContent[] dLContentArray = array;
            return dLContentArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLContent getByC_R_PrevAndNext(Session session, DLContent dlContent, long companyId, long repositoryId, OrderByComparator<DLContent> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_DLCONTENT_WHERE);
        sb.append("dlContent.companyId = ? AND ");
        sb.append(_FINDER_COLUMN_C_R_REPOSITORYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY dlContent.version DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(repositoryId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)dlContent)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (DLContent)list.get(1);
        }
        return null;
    }

    public void removeByC_R(long companyId, long repositoryId) {
        for (DLContent dlContent : this.findByC_R(companyId, repositoryId, -1, -1, null)) {
            this.remove((BaseModel)dlContent);
        }
    }

    public int countByC_R(long companyId, long repositoryId) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLContent.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByC_R;
            finderArgs = new Object[]{companyId, repositoryId};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_DLCONTENT_WHERE);
            sb.append("dlContent.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_R_REPOSITORYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(repositoryId);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<DLContent> findByC_R_P(long companyId, long repositoryId, String path) {
        return this.findByC_R_P(companyId, repositoryId, path, -1, -1, null);
    }

    public List<DLContent> findByC_R_P(long companyId, long repositoryId, String path, int start, int end) {
        return this.findByC_R_P(companyId, repositoryId, path, start, end, null);
    }

    public List<DLContent> findByC_R_P(long companyId, long repositoryId, String path, int start, int end, OrderByComparator<DLContent> orderByComparator) {
        return this.findByC_R_P(companyId, repositoryId, path, start, end, orderByComparator, true);
    }

    public List<DLContent> findByC_R_P(long companyId, long repositoryId, String path, int start, int end, OrderByComparator<DLContent> orderByComparator, boolean useFinderCache) {
        path = Objects.toString(path, "");
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLContent.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByC_R_P;
                finderArgs = new Object[]{companyId, repositoryId, path};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByC_R_P;
            finderArgs = new Object[]{companyId, repositoryId, path, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DLContent dlContent : list) {
                if (companyId == dlContent.getCompanyId() && repositoryId == dlContent.getRepositoryId() && path.equals(dlContent.getPath())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            sb.append(_SQL_SELECT_DLCONTENT_WHERE);
            sb.append("dlContent.companyId = ? AND ");
            sb.append("dlContent.repositoryId = ? AND ");
            boolean bindPath = false;
            if (path.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_R_P_PATH_3);
            } else {
                bindPath = true;
                sb.append(_FINDER_COLUMN_C_R_P_PATH_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY dlContent.version DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(repositoryId);
                if (bindPath) {
                    queryPos.add(path);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DLContent findByC_R_P_First(long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) throws NoSuchContentException {
        DLContent dlContent = this.fetchByC_R_P_First(companyId, repositoryId, path, orderByComparator);
        if (dlContent != null) {
            return dlContent;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", repositoryId=");
        sb.append(repositoryId);
        sb.append(", path=");
        sb.append(path);
        sb.append("}");
        throw new NoSuchContentException(sb.toString());
    }

    public DLContent fetchByC_R_P_First(long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) {
        List<DLContent> list = this.findByC_R_P(companyId, repositoryId, path, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DLContent findByC_R_P_Last(long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) throws NoSuchContentException {
        DLContent dlContent = this.fetchByC_R_P_Last(companyId, repositoryId, path, orderByComparator);
        if (dlContent != null) {
            return dlContent;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", repositoryId=");
        sb.append(repositoryId);
        sb.append(", path=");
        sb.append(path);
        sb.append("}");
        throw new NoSuchContentException(sb.toString());
    }

    public DLContent fetchByC_R_P_Last(long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) {
        int count = this.countByC_R_P(companyId, repositoryId, path);
        if (count == 0) {
            return null;
        }
        List<DLContent> list = this.findByC_R_P(companyId, repositoryId, path, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DLContent[] findByC_R_P_PrevAndNext(long contentId, long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) throws NoSuchContentException {
        path = Objects.toString(path, "");
        DLContent dlContent = this.findByPrimaryKey(contentId);
        Session session = null;
        try {
            session = this.openSession();
            DLContent[] array = new DLContentImpl[]{this.getByC_R_P_PrevAndNext(session, dlContent, companyId, repositoryId, path, orderByComparator, true), dlContent, this.getByC_R_P_PrevAndNext(session, dlContent, companyId, repositoryId, path, orderByComparator, false)};
            DLContent[] dLContentArray = array;
            return dLContentArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLContent getByC_R_P_PrevAndNext(Session session, DLContent dlContent, long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        sb.append(_SQL_SELECT_DLCONTENT_WHERE);
        sb.append("dlContent.companyId = ? AND ");
        sb.append("dlContent.repositoryId = ? AND ");
        boolean bindPath = false;
        if (path.isEmpty()) {
            sb.append(_FINDER_COLUMN_C_R_P_PATH_3);
        } else {
            bindPath = true;
            sb.append(_FINDER_COLUMN_C_R_P_PATH_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY dlContent.version DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(repositoryId);
        if (bindPath) {
            queryPos.add(path);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)dlContent)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (DLContent)list.get(1);
        }
        return null;
    }

    public void removeByC_R_P(long companyId, long repositoryId, String path) {
        for (DLContent dlContent : this.findByC_R_P(companyId, repositoryId, path, -1, -1, null)) {
            this.remove((BaseModel)dlContent);
        }
    }

    public int countByC_R_P(long companyId, long repositoryId, String path) {
        path = Objects.toString(path, "");
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLContent.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByC_R_P;
            finderArgs = new Object[]{companyId, repositoryId, path};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_DLCONTENT_WHERE);
            sb.append("dlContent.companyId = ? AND ");
            sb.append("dlContent.repositoryId = ? AND ");
            boolean bindPath = false;
            if (path.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_R_P_PATH_3);
            } else {
                bindPath = true;
                sb.append(_FINDER_COLUMN_C_R_P_PATH_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(repositoryId);
                if (bindPath) {
                    queryPos.add(path);
                }
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<DLContent> findByC_R_LikeP(long companyId, long repositoryId, String path) {
        return this.findByC_R_LikeP(companyId, repositoryId, path, -1, -1, null);
    }

    public List<DLContent> findByC_R_LikeP(long companyId, long repositoryId, String path, int start, int end) {
        return this.findByC_R_LikeP(companyId, repositoryId, path, start, end, null);
    }

    public List<DLContent> findByC_R_LikeP(long companyId, long repositoryId, String path, int start, int end, OrderByComparator<DLContent> orderByComparator) {
        return this.findByC_R_LikeP(companyId, repositoryId, path, start, end, orderByComparator, true);
    }

    public List<DLContent> findByC_R_LikeP(long companyId, long repositoryId, String path, int start, int end, OrderByComparator<DLContent> orderByComparator, boolean useFinderCache) {
        path = Objects.toString(path, "");
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLContent.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByC_R_LikeP;
        finderArgs = new Object[]{companyId, repositoryId, path, start, end, orderByComparator};
        List list = null;
        if (useFinderCache && productionMode && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DLContent dlContent : list) {
                if (companyId == dlContent.getCompanyId() && repositoryId == dlContent.getRepositoryId() && StringUtil.wildcardMatches((String)dlContent.getPath(), (String)path, (char)'_', (char)'%', (char)'\\', (boolean)true)) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            sb.append(_SQL_SELECT_DLCONTENT_WHERE);
            sb.append("dlContent.companyId = ? AND ");
            sb.append("dlContent.repositoryId = ? AND ");
            boolean bindPath = false;
            if (path.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_R_LIKEP_PATH_3);
            } else {
                bindPath = true;
                sb.append(_FINDER_COLUMN_C_R_LIKEP_PATH_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY dlContent.version DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(repositoryId);
                if (bindPath) {
                    queryPos.add(path);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DLContent findByC_R_LikeP_First(long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) throws NoSuchContentException {
        DLContent dlContent = this.fetchByC_R_LikeP_First(companyId, repositoryId, path, orderByComparator);
        if (dlContent != null) {
            return dlContent;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", repositoryId=");
        sb.append(repositoryId);
        sb.append(", pathLIKE");
        sb.append(path);
        sb.append("}");
        throw new NoSuchContentException(sb.toString());
    }

    public DLContent fetchByC_R_LikeP_First(long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) {
        List<DLContent> list = this.findByC_R_LikeP(companyId, repositoryId, path, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DLContent findByC_R_LikeP_Last(long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) throws NoSuchContentException {
        DLContent dlContent = this.fetchByC_R_LikeP_Last(companyId, repositoryId, path, orderByComparator);
        if (dlContent != null) {
            return dlContent;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", repositoryId=");
        sb.append(repositoryId);
        sb.append(", pathLIKE");
        sb.append(path);
        sb.append("}");
        throw new NoSuchContentException(sb.toString());
    }

    public DLContent fetchByC_R_LikeP_Last(long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) {
        int count = this.countByC_R_LikeP(companyId, repositoryId, path);
        if (count == 0) {
            return null;
        }
        List<DLContent> list = this.findByC_R_LikeP(companyId, repositoryId, path, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DLContent[] findByC_R_LikeP_PrevAndNext(long contentId, long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) throws NoSuchContentException {
        path = Objects.toString(path, "");
        DLContent dlContent = this.findByPrimaryKey(contentId);
        Session session = null;
        try {
            session = this.openSession();
            DLContent[] array = new DLContentImpl[]{this.getByC_R_LikeP_PrevAndNext(session, dlContent, companyId, repositoryId, path, orderByComparator, true), dlContent, this.getByC_R_LikeP_PrevAndNext(session, dlContent, companyId, repositoryId, path, orderByComparator, false)};
            DLContent[] dLContentArray = array;
            return dLContentArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLContent getByC_R_LikeP_PrevAndNext(Session session, DLContent dlContent, long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        sb.append(_SQL_SELECT_DLCONTENT_WHERE);
        sb.append("dlContent.companyId = ? AND ");
        sb.append("dlContent.repositoryId = ? AND ");
        boolean bindPath = false;
        if (path.isEmpty()) {
            sb.append(_FINDER_COLUMN_C_R_LIKEP_PATH_3);
        } else {
            bindPath = true;
            sb.append(_FINDER_COLUMN_C_R_LIKEP_PATH_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY dlContent.version DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(repositoryId);
        if (bindPath) {
            queryPos.add(path);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)dlContent)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (DLContent)list.get(1);
        }
        return null;
    }

    public void removeByC_R_LikeP(long companyId, long repositoryId, String path) {
        for (DLContent dlContent : this.findByC_R_LikeP(companyId, repositoryId, path, -1, -1, null)) {
            this.remove((BaseModel)dlContent);
        }
    }

    public int countByC_R_LikeP(long companyId, long repositoryId, String path) {
        path = Objects.toString(path, "");
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLContent.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathWithPaginationCountByC_R_LikeP;
            finderArgs = new Object[]{companyId, repositoryId, path};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_DLCONTENT_WHERE);
            sb.append("dlContent.companyId = ? AND ");
            sb.append("dlContent.repositoryId = ? AND ");
            boolean bindPath = false;
            if (path.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_R_LIKEP_PATH_3);
            } else {
                bindPath = true;
                sb.append(_FINDER_COLUMN_C_R_LIKEP_PATH_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(repositoryId);
                if (bindPath) {
                    queryPos.add(path);
                }
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DLContent findByC_R_P_V(long companyId, long repositoryId, String path, String version) throws NoSuchContentException {
        DLContent dlContent = this.fetchByC_R_P_V(companyId, repositoryId, path, version);
        if (dlContent == null) {
            StringBundler sb = new StringBundler(10);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", repositoryId=");
            sb.append(repositoryId);
            sb.append(", path=");
            sb.append(path);
            sb.append(", version=");
            sb.append(version);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchContentException(sb.toString());
        }
        return dlContent;
    }

    public DLContent fetchByC_R_P_V(long companyId, long repositoryId, String path, String version) {
        return this.fetchByC_R_P_V(companyId, repositoryId, path, version, true);
    }

    public DLContent fetchByC_R_P_V(long companyId, long repositoryId, String path, String version, boolean useFinderCache) {
        DLContent dlContent;
        path = Objects.toString(path, "");
        version = Objects.toString(version, "");
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLContent.class);
        Object[] finderArgs = null;
        if (useFinderCache && productionMode) {
            finderArgs = new Object[]{companyId, repositoryId, path, version};
        }
        Object result = null;
        if (useFinderCache && productionMode) {
            result = this.finderCache.getResult(this._finderPathFetchByC_R_P_V, finderArgs, (BasePersistenceImpl)this);
        }
        if (!(!(result instanceof DLContent) || companyId == (dlContent = (DLContent)result).getCompanyId() && repositoryId == dlContent.getRepositoryId() && Objects.equals(path, dlContent.getPath()) && Objects.equals(version, dlContent.getVersion()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_SQL_SELECT_DLCONTENT_WHERE);
            sb.append("dlContent.companyId = ? AND ");
            sb.append("dlContent.repositoryId = ? AND ");
            boolean bindPath = false;
            if (path.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_R_P_V_PATH_3);
            } else {
                bindPath = true;
                sb.append(_FINDER_COLUMN_C_R_P_V_PATH_2);
            }
            boolean bindVersion = false;
            if (version.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_R_P_V_VERSION_3);
            } else {
                bindVersion = true;
                sb.append(_FINDER_COLUMN_C_R_P_V_VERSION_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(repositoryId);
                if (bindPath) {
                    queryPos.add(path);
                }
                if (bindVersion) {
                    queryPos.add(version);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache && productionMode) {
                        this.finderCache.putResult(this._finderPathFetchByC_R_P_V, finderArgs, (Object)list);
                    }
                } else {
                    DLContent dlContent2 = (DLContent)list.get(0);
                    result = dlContent2;
                    this.cacheResult(dlContent2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (DLContent)result;
    }

    public DLContent removeByC_R_P_V(long companyId, long repositoryId, String path, String version) throws NoSuchContentException {
        DLContent dlContent = this.findByC_R_P_V(companyId, repositoryId, path, version);
        return (DLContent)this.remove((BaseModel)dlContent);
    }

    public int countByC_R_P_V(long companyId, long repositoryId, String path, String version) {
        path = Objects.toString(path, "");
        version = Objects.toString(version, "");
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLContent.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByC_R_P_V;
            finderArgs = new Object[]{companyId, repositoryId, path, version};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(5);
            sb.append(_SQL_COUNT_DLCONTENT_WHERE);
            sb.append("dlContent.companyId = ? AND ");
            sb.append("dlContent.repositoryId = ? AND ");
            boolean bindPath = false;
            if (path.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_R_P_V_PATH_3);
            } else {
                bindPath = true;
                sb.append(_FINDER_COLUMN_C_R_P_V_PATH_2);
            }
            boolean bindVersion = false;
            if (version.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_R_P_V_VERSION_3);
            } else {
                bindVersion = true;
                sb.append(_FINDER_COLUMN_C_R_P_V_VERSION_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(repositoryId);
                if (bindPath) {
                    queryPos.add(path);
                }
                if (bindVersion) {
                    queryPos.add(version);
                }
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DLContentPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("path", "path_");
        dbColumnNames.put("data", "data_");
        dbColumnNames.put("size", "size_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(DLContent.class);
        this.setModelImplClass(DLContentImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)DLContentTable.INSTANCE);
    }

    public void cacheResult(DLContent dlContent) {
        if (dlContent.getCtCollectionId() != 0L) {
            return;
        }
        this.entityCache.putResult(DLContentImpl.class, (Serializable)Long.valueOf(dlContent.getPrimaryKey()), (Serializable)dlContent);
        this.finderCache.putResult(this._finderPathFetchByC_R_P_V, new Object[]{dlContent.getCompanyId(), dlContent.getRepositoryId(), dlContent.getPath(), dlContent.getVersion()}, (Object)dlContent);
    }

    public void cacheResult(List<DLContent> dlContents) {
        for (DLContent dlContent : dlContents) {
            if (dlContent.getCtCollectionId() != 0L || this.entityCache.getResult(DLContentImpl.class, (Serializable)Long.valueOf(dlContent.getPrimaryKey())) != null) continue;
            this.cacheResult(dlContent);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(DLContentImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(DLContent dlContent) {
        this.entityCache.removeResult(DLContentImpl.class, (BaseModel)dlContent);
    }

    public void clearCache(List<DLContent> dlContents) {
        for (DLContent dlContent : dlContents) {
            this.entityCache.removeResult(DLContentImpl.class, (BaseModel)dlContent);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(DLContentImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(DLContentModelImpl dlContentModelImpl) {
        Object[] args = new Object[]{dlContentModelImpl.getCompanyId(), dlContentModelImpl.getRepositoryId(), dlContentModelImpl.getPath(), dlContentModelImpl.getVersion()};
        this.finderCache.putResult(this._finderPathCountByC_R_P_V, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByC_R_P_V, args, (Object)dlContentModelImpl, false);
    }

    public DLContent create(long contentId) {
        DLContentImpl dlContent = new DLContentImpl();
        dlContent.setNew(true);
        dlContent.setPrimaryKey(contentId);
        dlContent.setCompanyId(CompanyThreadLocal.getCompanyId());
        return dlContent;
    }

    public DLContent remove(long contentId) throws NoSuchContentException {
        return this.remove(Long.valueOf(contentId));
    }

    public DLContent remove(Serializable primaryKey) throws NoSuchContentException {
        Session session = null;
        try {
            session = this.openSession();
            DLContent dlContent = (DLContent)session.get(DLContentImpl.class, primaryKey);
            if (dlContent == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchContentException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            DLContent dLContent = (DLContent)this.remove((BaseModel)dlContent);
            return dLContent;
        }
        catch (NoSuchContentException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLContent removeImpl(DLContent dlContent) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)dlContent)) {
                dlContent = (DLContent)session.get(DLContentImpl.class, dlContent.getPrimaryKeyObj());
            }
            if (dlContent != null && this.ctPersistenceHelper.isRemove((CTModel)dlContent)) {
                session.delete((Object)dlContent);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (dlContent != null) {
            this.clearCache(dlContent);
        }
        return dlContent;
    }

    public DLContent updateImpl(DLContent dlContent) {
        boolean isNew = dlContent.isNew();
        if (!(dlContent instanceof DLContentModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(dlContent.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)dlContent);
                throw new IllegalArgumentException("Implement ModelWrapper in dlContent proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom DLContent implementation " + dlContent.getClass());
        }
        DLContentModelImpl dlContentModelImpl = (DLContentModelImpl)dlContent;
        Session session = null;
        try {
            session = this.openSession();
            if (this.ctPersistenceHelper.isInsert((CTModel)dlContent)) {
                if (!isNew) {
                    session.evict(DLContentImpl.class, dlContent.getPrimaryKeyObj());
                }
                session.save((Object)dlContent);
            } else {
                session.evict(DLContentImpl.class, dlContent.getPrimaryKeyObj());
                session.saveOrUpdate((Object)dlContent);
            }
            session.flush();
            session.clear();
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (dlContent.getCtCollectionId() != 0L) {
            if (isNew) {
                dlContent.setNew(false);
            }
            dlContent.resetOriginalValues();
            return dlContent;
        }
        this.entityCache.putResult(DLContentImpl.class, (BaseModel)dlContentModelImpl, false, true);
        this.cacheUniqueFindersCache(dlContentModelImpl);
        if (isNew) {
            dlContent.setNew(false);
        }
        dlContent.resetOriginalValues();
        return dlContent;
    }

    public DLContent findByPrimaryKey(Serializable primaryKey) throws NoSuchContentException {
        DLContent dlContent = this.fetchByPrimaryKey(primaryKey);
        if (dlContent == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchContentException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return dlContent;
    }

    public DLContent findByPrimaryKey(long contentId) throws NoSuchContentException {
        return this.findByPrimaryKey(Long.valueOf(contentId));
    }

    public DLContent fetchByPrimaryKey(Serializable primaryKey) {
        if (this.ctPersistenceHelper.isProductionMode(DLContent.class)) {
            return (DLContent)super.fetchByPrimaryKey(primaryKey);
        }
        DLContent dlContent = null;
        Session session = null;
        try {
            session = this.openSession();
            dlContent = (DLContent)session.get(DLContentImpl.class, primaryKey);
            if (dlContent != null) {
                this.cacheResult(dlContent);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return dlContent;
    }

    public DLContent fetchByPrimaryKey(long contentId) {
        return this.fetchByPrimaryKey(Long.valueOf(contentId));
    }

    public Map<Serializable, DLContent> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (this.ctPersistenceHelper.isProductionMode(DLContent.class)) {
            return super.fetchByPrimaryKeys(primaryKeys);
        }
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, DLContent> map = new HashMap<Serializable, DLContent>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            DLContent dlContent = this.fetchByPrimaryKey(primaryKey);
            if (dlContent != null) {
                map.put(primaryKey, dlContent);
            }
            return map;
        }
        StringBundler sb = new StringBundler(primaryKeys.size() * 2 + 1);
        sb.append(this.getSelectSQL());
        sb.append(" WHERE ");
        sb.append(this.getPKDBName());
        sb.append(" IN (");
        for (Serializable primaryKey : primaryKeys) {
            sb.append(((Long)primaryKey).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String sql = sb.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(sql);
            for (DLContent dlContent : query.list()) {
                map.put(dlContent.getPrimaryKeyObj(), dlContent);
                this.cacheResult(dlContent);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<DLContent> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<DLContent> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<DLContent> findAll(int start, int end, OrderByComparator<DLContent> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<DLContent> findAll(int start, int end, OrderByComparator<DLContent> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLContent.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_DLCONTENT);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_DLCONTENT;
                sql = sql.concat(" ORDER BY dlContent.version DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (DLContent dlContent : this.findAll()) {
            this.remove((BaseModel)dlContent);
        }
    }

    public int countAll() {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLContent.class);
        Long count = null;
        if (productionMode) {
            count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        }
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_DLCONTENT);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "contentId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_DLCONTENT;
    }

    public Set<String> getCTColumnNames(CTColumnResolutionType ctColumnResolutionType) {
        return _ctColumnNamesMap.get(ctColumnResolutionType);
    }

    public List<String> getMappingTableNames() {
        return _mappingTableNames;
    }

    public Map<String, Integer> getTableColumnsMap() {
        return DLContentModelImpl.TABLE_COLUMNS_MAP;
    }

    public String getTableName() {
        return "DLContent";
    }

    public List<String[]> getUniqueIndexColumnNames() {
        return _uniqueIndexColumnNames;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new DLContentModelArgumentsResolver(), MapUtil.singletonDictionary((Object)"model.class.name", (Object)DLContent.class.getName()));
        this._finderPathWithPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByC_R = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_R", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "repositoryId"}, true);
        this._finderPathWithoutPaginationFindByC_R = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_R", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"companyId", "repositoryId"}, true);
        this._finderPathCountByC_R = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_R", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"companyId", "repositoryId"}, false);
        this._finderPathWithPaginationFindByC_R_P = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_R_P", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "repositoryId", "path_"}, true);
        this._finderPathWithoutPaginationFindByC_R_P = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_R_P", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()}, new String[]{"companyId", "repositoryId", "path_"}, true);
        this._finderPathCountByC_R_P = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_R_P", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()}, new String[]{"companyId", "repositoryId", "path_"}, false);
        this._finderPathWithPaginationFindByC_R_LikeP = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_R_LikeP", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "repositoryId", "path_"}, true);
        this._finderPathWithPaginationCountByC_R_LikeP = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByC_R_LikeP", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()}, new String[]{"companyId", "repositoryId", "path_"}, false);
        this._finderPathFetchByC_R_P_V = this._createFinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_R_P_V", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), String.class.getName()}, new String[]{"companyId", "repositoryId", "path_", "version"}, true);
        this._finderPathCountByC_R_P_V = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_R_P_V", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), String.class.getName()}, new String[]{"companyId", "repositoryId", "path_", "version"}, false);
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(DLContentImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
        for (ServiceRegistration<FinderPath> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.document.library.content.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.document.library.content.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.document.library.content.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    private FinderPath _createFinderPath(String cacheName, String methodName, String[] params, String[] columnNames, boolean baseModelResult) {
        FinderPath finderPath = new FinderPath(cacheName, methodName, params, columnNames, baseModelResult);
        if (!cacheName.equals(FINDER_CLASS_NAME_LIST_WITH_PAGINATION)) {
            this._serviceRegistrations.add((ServiceRegistration<FinderPath>)this._bundleContext.registerService(FinderPath.class, (Object)finderPath, MapUtil.singletonDictionary((Object)"cache.name", (Object)cacheName)));
        }
        return finderPath;
    }

    static {
        HashSet<String> ctControlColumnNames = new HashSet<String>();
        HashSet ctIgnoreColumnNames = new HashSet();
        HashSet ctMergeColumnNames = new HashSet();
        HashSet<String> ctStrictColumnNames = new HashSet<String>();
        ctControlColumnNames.add("mvccVersion");
        ctControlColumnNames.add("ctCollectionId");
        ctStrictColumnNames.add("groupId");
        ctStrictColumnNames.add("companyId");
        ctStrictColumnNames.add("repositoryId");
        ctStrictColumnNames.add("path_");
        ctStrictColumnNames.add("version");
        ctStrictColumnNames.add("data_");
        ctStrictColumnNames.add("size_");
        _ctColumnNamesMap.put(CTColumnResolutionType.CONTROL, ctControlColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.IGNORE, ctIgnoreColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.MERGE, ctMergeColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.PK, Collections.singleton("contentId"));
        _ctColumnNamesMap.put(CTColumnResolutionType.STRICT, ctStrictColumnNames);
        _uniqueIndexColumnNames.add(new String[]{"companyId", "repositoryId", "path_", "version"});
        _log = LogFactoryUtil.getLog(DLContentPersistenceImpl.class);
        _badColumnNames = SetUtil.fromArray((Object[])new String[]{"path", "data", "size"});
        try {
            Class.forName(DLPersistenceConstants.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionInInitializerError(classNotFoundException);
        }
    }

    private static class DLContentModelArgumentsResolver
    implements ArgumentsResolver {
        private static Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

        private DLContentModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            DLContentModelImpl dlContentModelImpl = (DLContentModelImpl)baseModel;
            long columnBitmask = dlContentModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return this._getValue(dlContentModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | DLContentModelImpl.getColumnBitmask(columnName);
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return this._getValue(dlContentModelImpl, columnNames, original);
            }
            return null;
        }

        private Object[] _getValue(DLContentModelImpl dlContentModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? dlContentModelImpl.getColumnOriginalValue(columnName) : dlContentModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }
    }
}

