/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.content.service.impl;

import com.liferay.document.library.content.exception.NoSuchContentException;
import com.liferay.document.library.content.model.DLContent;
import com.liferay.document.library.content.service.base.DLContentLocalServiceBaseImpl;
import com.liferay.document.library.content.service.util.comparator.DLContentVersionComparator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.jdbc.OutputBlob;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.document.library.content.model.DLContent"}, service={AopService.class})
public class DLContentLocalServiceImpl
extends DLContentLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DLContentLocalServiceImpl.class);

    public DLContent addContent(long companyId, long repositoryId, String path, String version, byte[] bytes) {
        long contentId = this.counterLocalService.increment();
        DLContent dlContent = this.dlContentPersistence.create(contentId);
        dlContent.setCompanyId(companyId);
        dlContent.setRepositoryId(repositoryId);
        dlContent.setPath(path);
        dlContent.setVersion(version);
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(bytes);
        OutputBlob dataOutputBlob = new OutputBlob((InputStream)unsyncByteArrayInputStream, (long)bytes.length);
        dlContent.setData((Blob)dataOutputBlob);
        dlContent.setSize((long)bytes.length);
        this.dlContentPersistence.update((BaseModel)dlContent);
        return dlContent;
    }

    public DLContent addContent(long companyId, long repositoryId, String path, String version, InputStream inputStream, long size) {
        DLContent dlContent;
        block14: {
            dlContent = null;
            try (InputStream is = inputStream;){
                long contentId = this.counterLocalService.increment();
                dlContent = this.dlContentPersistence.create(contentId);
                dlContent.setCompanyId(companyId);
                dlContent.setRepositoryId(repositoryId);
                dlContent.setPath(path);
                dlContent.setVersion(version);
                OutputBlob dataOutputBlob = new OutputBlob(is, size);
                dlContent.setData((Blob)dataOutputBlob);
                dlContent.setSize(size);
                this.dlContentPersistence.update((BaseModel)dlContent);
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn((Object)ioe, (Throwable)ioe);
            }
        }
        return dlContent;
    }

    public void deleteContent(long companyId, long repositoryId, String path, String version) throws PortalException {
        this.dlContentPersistence.removeByC_R_P_V(companyId, repositoryId, path, version);
    }

    public void deleteContents(long companyId, long repositoryId, String path) {
        this.dlContentPersistence.removeByC_R_P(companyId, repositoryId, path);
    }

    public void deleteContentsByDirectory(long companyId, long repositoryId, String dirName) {
        if (!dirName.endsWith("/")) {
            dirName = dirName.concat("/");
        }
        dirName = dirName.concat("%");
        this.dlContentPersistence.removeByC_R_LikeP(companyId, repositoryId, dirName);
    }

    public DLContent getContent(long companyId, long repositoryId, String path) throws NoSuchContentException {
        DLContentVersionComparator orderByComparator = new DLContentVersionComparator();
        List dlContents = this.dlContentPersistence.findByC_R_P(companyId, repositoryId, path, 0, 1, (OrderByComparator)orderByComparator);
        if (dlContents == null || dlContents.isEmpty()) {
            throw new NoSuchContentException(path);
        }
        return (DLContent)dlContents.get(0);
    }

    public DLContent getContent(long companyId, long repositoryId, String path, String version) throws NoSuchContentException {
        return this.dlContentPersistence.findByC_R_P_V(companyId, repositoryId, path, version);
    }

    public List<DLContent> getContents(long companyId, long repositoryId) {
        return this.dlContentPersistence.findByC_R(companyId, repositoryId);
    }

    public List<DLContent> getContents(long companyId, long repositoryId, String path) {
        return this.dlContentPersistence.findByC_R_P(companyId, repositoryId, path);
    }

    public List<DLContent> getContentsByDirectory(long companyId, long repositoryId, String dirName) {
        if (!dirName.endsWith("/")) {
            dirName = dirName.concat("/");
        }
        dirName = dirName.concat("%");
        return this.dlContentPersistence.findByC_R_LikeP(companyId, repositoryId, dirName);
    }

    public boolean hasContent(long companyId, long repositoryId, String path, String version) {
        int count = this.dlContentPersistence.countByC_R_P_V(companyId, repositoryId, path, version);
        return count > 0;
    }

    public void updateDLContent(long companyId, long oldRepositoryId, long newRepositoryId, String oldPath, String newPath) {
        List dlContents = this.dlContentPersistence.findByC_R_P(companyId, oldRepositoryId, oldPath);
        for (DLContent dLContent : dlContents) {
            dLContent.setRepositoryId(newRepositoryId);
            dLContent.setPath(newPath);
            this.dlContentPersistence.update((BaseModel)dLContent);
        }
    }
}

