/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.directory.web.asset;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseAssetRendererFactory;
import com.liferay.directory.web.asset.UserAssetRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_directory_web_portlet_DirectoryPortlet", "javax.portlet.name=com_liferay_directory_web_portlet_FriendsDirectoryPortlet", "javax.portlet.name=com_liferay_directory_web_portlet_MySitesDirectoryPortlet", "javax.portlet.name=com_liferay_directory_web_portlet_SiteMembersDirectoryPortlet"}, service={AssetRendererFactory.class})
public class UserAssetRendererFactory
extends BaseAssetRendererFactory<User> {
    public static final String TYPE = "user";
    private GroupLocalService _groupLocalService;
    private UserLocalService _userLocalService;

    public UserAssetRendererFactory() {
        this.setSearchable(true);
        this.setSelectable(false);
    }

    public AssetRenderer<User> getAssetRenderer(long classPK, int type) throws PortalException {
        User user = this._userLocalService.getUserById(classPK);
        UserAssetRenderer userAssetRenderer = new UserAssetRenderer(user);
        userAssetRenderer.setAssetRendererType(type);
        return userAssetRenderer;
    }

    public AssetRenderer<User> getAssetRenderer(long groupId, String urlTitle) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        User user = this._userLocalService.getUserByScreenName(group.getCompanyId(), urlTitle);
        return new UserAssetRenderer(user);
    }

    public String getClassName() {
        return User.class.getName();
    }

    public String getIconCssClass() {
        return TYPE;
    }

    public String getType() {
        return TYPE;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)classPK, (String)actionId);
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

