/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.diff.internal;

import com.liferay.diff.Diff;
import com.liferay.diff.DiffResult;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.FileUtil;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.incava.util.diff.Difference;
import org.osgi.service.component.annotations.Component;

@Component(service={Diff.class})
public class DiffImpl
implements Diff {
    private static final int _DIFF_MAX_LINE_LENGTH = 5000;

    public List<DiffResult>[] diff(Reader source, Reader target) {
        int margin = 2;
        return this.diff(source, target, "<ins>", "</ins>", "<del>", "</del>", margin);
    }

    public List<DiffResult>[] diff(Reader source, Reader target, String addedMarkerStart, String addedMarkerEnd, String deletedMarkerStart, String deletedMarkerEnd, int margin) {
        ArrayList<DiffResult> sourceResults = new ArrayList<DiffResult>();
        ArrayList<DiffResult> targetResults = new ArrayList<DiffResult>();
        List[] results = new List[]{sourceResults, targetResults};
        List sourceStringList = FileUtil.toList((Reader)source);
        List targetStringList = FileUtil.toList((Reader)target);
        org.incava.util.diff.Diff diff = new org.incava.util.diff.Diff(sourceStringList, targetStringList);
        List differences = diff.diff();
        for (Difference difference : differences) {
            DiffResult diffResult;
            List<String> changedLines;
            if (difference.getAddedEnd() == -1) {
                this._highlightLines(sourceStringList, deletedMarkerStart, deletedMarkerEnd, difference.getDeletedStart(), difference.getDeletedEnd());
                margin = this._calculateMargin(sourceResults, targetResults, difference.getDeletedStart(), difference.getAddedStart(), margin);
                changedLines = this._addMargins(sourceStringList, difference.getDeletedStart(), margin);
                this._addResults(sourceResults, sourceStringList, changedLines, difference.getDeletedStart(), difference.getDeletedEnd());
                changedLines = this._addMargins(targetStringList, difference.getAddedStart(), margin);
                int deletedLines = difference.getDeletedEnd() + 1 - difference.getDeletedStart();
                for (int i = 0; i < deletedLines; ++i) {
                    changedLines.add("#context#line#");
                }
                diffResult = new DiffResult(difference.getDeletedStart(), changedLines);
                targetResults.add(diffResult);
                continue;
            }
            if (difference.getDeletedEnd() == -1) {
                this._highlightLines(targetStringList, addedMarkerStart, addedMarkerEnd, difference.getAddedStart(), difference.getAddedEnd());
                margin = this._calculateMargin(sourceResults, targetResults, difference.getDeletedStart(), difference.getAddedStart(), margin);
                changedLines = this._addMargins(sourceStringList, difference.getDeletedStart(), margin);
                int addedLines = difference.getAddedEnd() + 1 - difference.getAddedStart();
                for (int i = 0; i < addedLines; ++i) {
                    changedLines.add("#context#line#");
                }
                diffResult = new DiffResult(difference.getAddedStart(), changedLines);
                sourceResults.add(diffResult);
                changedLines = this._addMargins(targetStringList, difference.getAddedStart(), margin);
                this._addResults(targetResults, targetStringList, changedLines, difference.getAddedStart(), difference.getAddedEnd());
                continue;
            }
            this._checkCharDiffs(sourceResults, targetResults, sourceStringList, targetStringList, addedMarkerStart, addedMarkerEnd, deletedMarkerStart, deletedMarkerEnd, difference);
        }
        return results;
    }

    private List<String> _addMargins(List<String> stringList, int startPos, int margin) {
        int i;
        ArrayList<String> changedLines = new ArrayList<String>();
        if (margin == 0 || startPos == 0) {
            return changedLines;
        }
        for (i = startPos - margin; i < 0; ++i) {
            changedLines.add("#context#line#");
        }
        while (i < startPos) {
            if (i < stringList.size()) {
                changedLines.add(stringList.get(i));
            }
            ++i;
        }
        return changedLines;
    }

    private void _addResults(List<DiffResult> results, List<String> stringList, List<String> changedLines, int start, int end) {
        changedLines.addAll(stringList.subList(start, end + 1));
        DiffResult diffResult = new DiffResult(start, changedLines);
        results.add(diffResult);
    }

    private int _calculateMargin(List<DiffResult> sourceResults, List<DiffResult> targetResults, int sourceBeginPos, int targetBeginPos, int margin) {
        int targetMargin;
        int sourceMargin = this._checkOverlapping(sourceResults, sourceBeginPos, margin);
        if (sourceMargin < (targetMargin = this._checkOverlapping(targetResults, targetBeginPos, margin))) {
            return sourceMargin;
        }
        return targetMargin;
    }

    private void _checkCharDiffs(List<DiffResult> sourceResults, List<DiffResult> targetResults, List<String> sourceStringList, List<String> targetStringList, String addedMarkerStart, String addedMarkerEnd, String deletedMarkerStart, String deletedMarkerEnd, Difference difference) {
        DiffResult sourceResult;
        DiffResult targetResult;
        int i;
        boolean aligned = false;
        int j = difference.getAddedStart();
        for (i = difference.getDeletedStart(); i <= difference.getDeletedEnd(); ++i) {
            while (j <= difference.getAddedEnd()) {
                if (!this._isMaxLineLengthExceeded(sourceStringList.get(i), targetStringList.get(j)) && this._lineDiff(sourceResults, targetResults, sourceStringList, targetStringList, addedMarkerStart, addedMarkerEnd, deletedMarkerStart, deletedMarkerEnd, i, j, false)) {
                    aligned = true;
                    break;
                }
                this._highlightLines(targetStringList, addedMarkerStart, addedMarkerEnd, j, j);
                targetResult = new DiffResult(j, targetStringList.subList(j, j + 1));
                targetResults.add(targetResult);
                sourceResults.add(new DiffResult(j, "#context#line#"));
                ++j;
            }
            if (aligned) break;
            this._highlightLines(sourceStringList, deletedMarkerStart, deletedMarkerEnd, i, i);
            sourceResult = new DiffResult(i, sourceStringList.subList(i, i + 1));
            sourceResults.add(sourceResult);
            targetResults.add(new DiffResult(i, "#context#line#"));
        }
        ++i;
        ++j;
        while (i <= difference.getDeletedEnd() && j <= difference.getAddedEnd()) {
            if (!this._isMaxLineLengthExceeded(sourceStringList.get(i), targetStringList.get(j))) {
                this._lineDiff(sourceResults, targetResults, sourceStringList, targetStringList, addedMarkerStart, addedMarkerEnd, deletedMarkerStart, deletedMarkerEnd, i, j, true);
            } else {
                this._highlightLines(sourceStringList, deletedMarkerStart, deletedMarkerEnd, i, i);
                sourceResult = new DiffResult(i, sourceStringList.subList(i, i + 1));
                sourceResults.add(sourceResult);
                targetResults.add(new DiffResult(i, "#context#line#"));
                this._highlightLines(targetStringList, addedMarkerStart, addedMarkerEnd, j, j);
                DiffResult targetResult2 = new DiffResult(j, targetStringList.subList(j, j + 1));
                targetResults.add(targetResult2);
                sourceResults.add(new DiffResult(j, "#context#line#"));
            }
            ++i;
            ++j;
        }
        while (i <= difference.getDeletedEnd()) {
            this._highlightLines(sourceStringList, deletedMarkerStart, deletedMarkerEnd, i, i);
            sourceResult = new DiffResult(i, sourceStringList.subList(i, i + 1));
            sourceResults.add(sourceResult);
            targetResults.add(new DiffResult(i, "#context#line#"));
            ++i;
        }
        while (j <= difference.getAddedEnd()) {
            this._highlightLines(targetStringList, addedMarkerStart, addedMarkerEnd, j, j);
            targetResult = new DiffResult(j, targetStringList.subList(j, j + 1));
            targetResults.add(targetResult);
            sourceResults.add(new DiffResult(j, "#context#line#"));
            ++j;
        }
    }

    private int _checkOverlapping(List<DiffResult> results, int startPos, int margin) {
        String changedLine;
        if (results.isEmpty() || startPos - margin < 0) {
            return margin;
        }
        DiffResult lastDiff = results.get(results.size() - 1);
        List changedLines = lastDiff.getChangedLines();
        if (changedLines.isEmpty()) {
            return margin;
        }
        int lastChangedLine = lastDiff.getLineNumber() - 1 + changedLines.size();
        int currentChangedLine = startPos - margin;
        if (changedLines.size() == 1 && (changedLine = (String)changedLines.get(0)).equals("#context#line#")) {
            ++currentChangedLine;
        }
        if (currentChangedLine < lastChangedLine) {
            return margin + currentChangedLine - lastChangedLine;
        }
        return margin;
    }

    private void _highlightChars(List<String> stringList, String markerStart, String markerEnd, int startPos, int endPos) {
        String start = markerStart + stringList.get(startPos);
        stringList.set(startPos, start);
        String end = stringList.get(endPos) + markerEnd;
        stringList.set(endPos, end);
    }

    private void _highlightLines(List<String> stringList, String markerStart, String markerEnd, int startPos, int endPos) {
        for (int i = startPos; i <= endPos; ++i) {
            stringList.set(i, markerStart + stringList.get(i) + markerEnd);
        }
    }

    private boolean _isMaxLineLengthExceeded(String sourceString, String targetString) {
        return sourceString.length() > 5000 || targetString.length() > 5000;
    }

    private boolean _lineDiff(List<DiffResult> sourceResults, List<DiffResult> targetResults, List<String> sourceStringList, List<String> targetStringList, String addedMarkerStart, String addedMarkerEnd, String deletedMarkerStart, String deletedMarkerEnd, int sourceChangedLine, int targetChangedLine, boolean aligned) {
        DiffResult sourceResult;
        String source = sourceStringList.get(sourceChangedLine);
        String target = targetStringList.get(targetChangedLine);
        List<String> sourceList = this._toList(source);
        List<String> targetList = this._toList(target);
        org.incava.util.diff.Diff diff = new org.incava.util.diff.Diff(sourceList, targetList);
        List differences = diff.diff();
        int deletedChars = 0;
        int addedChars = 0;
        if (!aligned) {
            for (Difference difference : differences) {
                if (difference.getDeletedEnd() != -1) {
                    deletedChars += difference.getDeletedEnd() - difference.getDeletedStart() + 1;
                }
                if (difference.getAddedEnd() == -1) continue;
                addedChars += difference.getAddedEnd() - difference.getAddedStart() + 1;
            }
        }
        if (deletedChars > sourceList.size() / 2 || addedChars > sourceList.size() / 2) {
            return false;
        }
        boolean sourceChanged = false;
        boolean targetChanged = false;
        for (Difference difference : differences) {
            if (difference.getAddedEnd() == -1) {
                this._highlightChars(sourceList, deletedMarkerStart, deletedMarkerEnd, difference.getDeletedStart(), difference.getDeletedEnd());
                sourceChanged = true;
                continue;
            }
            if (difference.getDeletedEnd() == -1) {
                this._highlightChars(targetList, addedMarkerStart, addedMarkerEnd, difference.getAddedStart(), difference.getAddedEnd());
                targetChanged = true;
                continue;
            }
            this._highlightChars(sourceList, deletedMarkerStart, deletedMarkerEnd, difference.getDeletedStart(), difference.getDeletedEnd());
            sourceChanged = true;
            this._highlightChars(targetList, addedMarkerStart, addedMarkerEnd, difference.getAddedStart(), difference.getAddedEnd());
            targetChanged = true;
        }
        if (sourceChanged) {
            sourceResult = new DiffResult(sourceChangedLine, this._toString(sourceList));
            sourceResults.add(sourceResult);
            if (!targetChanged) {
                DiffResult targetResult = new DiffResult(targetChangedLine, target);
                targetResults.add(targetResult);
            }
        }
        if (targetChanged) {
            if (!sourceChanged) {
                sourceResult = new DiffResult(sourceChangedLine, source);
                sourceResults.add(sourceResult);
            }
            DiffResult targetResult = new DiffResult(targetChangedLine, this._toString(targetList));
            targetResults.add(targetResult);
        }
        return true;
    }

    private List<String> _toList(String line) {
        ArrayList<String> result = new ArrayList<String>(line.length());
        for (int i = 0; i < line.length(); ++i) {
            result.add(line.substring(i, i + 1));
        }
        return result;
    }

    private String _toString(List<String> line) {
        if (line.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(line.size());
        for (String linePart : line) {
            sb.append(linePart);
        }
        return sb.toString();
    }
}

