/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.depot.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the DepotEntry service. Represents a row in the &quot;DepotEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.depot.model.impl.DepotEntryModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.depot.model.impl.DepotEntryImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DepotEntry
 * @generated
 */
@ProviderType
public interface DepotEntryModel
	extends BaseModel<DepotEntry>, GroupedModel, MVCCModel, ShardedModel,
			StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a depot entry model instance should use the {@link DepotEntry} interface instead.
	 */

	/**
	 * Returns the primary key of this depot entry.
	 *
	 * @return the primary key of this depot entry
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this depot entry.
	 *
	 * @param primaryKey the primary key of this depot entry
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this depot entry.
	 *
	 * @return the mvcc version of this depot entry
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this depot entry.
	 *
	 * @param mvccVersion the mvcc version of this depot entry
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the uuid of this depot entry.
	 *
	 * @return the uuid of this depot entry
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this depot entry.
	 *
	 * @param uuid the uuid of this depot entry
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the depot entry ID of this depot entry.
	 *
	 * @return the depot entry ID of this depot entry
	 */
	public long getDepotEntryId();

	/**
	 * Sets the depot entry ID of this depot entry.
	 *
	 * @param depotEntryId the depot entry ID of this depot entry
	 */
	public void setDepotEntryId(long depotEntryId);

	/**
	 * Returns the group ID of this depot entry.
	 *
	 * @return the group ID of this depot entry
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this depot entry.
	 *
	 * @param groupId the group ID of this depot entry
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this depot entry.
	 *
	 * @return the company ID of this depot entry
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this depot entry.
	 *
	 * @param companyId the company ID of this depot entry
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this depot entry.
	 *
	 * @return the user ID of this depot entry
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this depot entry.
	 *
	 * @param userId the user ID of this depot entry
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this depot entry.
	 *
	 * @return the user uuid of this depot entry
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this depot entry.
	 *
	 * @param userUuid the user uuid of this depot entry
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this depot entry.
	 *
	 * @return the user name of this depot entry
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this depot entry.
	 *
	 * @param userName the user name of this depot entry
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this depot entry.
	 *
	 * @return the create date of this depot entry
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this depot entry.
	 *
	 * @param createDate the create date of this depot entry
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this depot entry.
	 *
	 * @return the modified date of this depot entry
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this depot entry.
	 *
	 * @param modifiedDate the modified date of this depot entry
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	@Override
	public DepotEntry cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}