/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.spi.field.type.util;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class LocalizedValueUtil {
    public static Object getLocalizedValue(Locale locale, Map<String, Object> localizedValues) {
        if (MapUtil.isEmpty(localizedValues)) {
            return null;
        }
        return localizedValues.get(LocaleUtil.toLanguageId((Locale)locale));
    }

    public static <V> JSONObject toJSONObject(Map<String, V> map) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (MapUtil.isEmpty(map)) {
            return jsonObject;
        }
        for (Map.Entry<String, V> entry : map.entrySet()) {
            jsonObject.put(entry.getKey(), entry.getValue());
        }
        return jsonObject;
    }

    public static Map<Locale, String> toLocaleStringMap(Map<String, Object> localizedValues) {
        if (MapUtil.isEmpty(localizedValues)) {
            return Collections.emptyMap();
        }
        HashMap<Locale, String> localeStringMap = new HashMap<Locale, String>();
        for (Map.Entry<String, Object> entry : localizedValues.entrySet()) {
            localeStringMap.put(LocaleUtil.fromLanguageId((String)entry.getKey()), (String)entry.getValue());
        }
        return localeStringMap;
    }

    public static <V> Map<String, V> toLocalizedValues(JSONObject jsonObject) {
        HashMap<String, Object> localizedValues = new HashMap<String, Object>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            localizedValues.put(key, jsonObject.get(key));
        }
        return localizedValues;
    }

    public static Map<String, Object> toStringObjectMap(Map<Locale, String> localizedValues) {
        HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
        for (Map.Entry<Locale, String> entry : localizedValues.entrySet()) {
            stringObjectMap.put(String.valueOf(entry.getKey()), entry.getValue());
        }
        return stringObjectMap;
    }
}

