/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.client.resource.v2_0;

import com.liferay.data.engine.rest.client.dto.v2_0.DataRecord;
import com.liferay.data.engine.rest.client.http.HttpInvoker;
import com.liferay.data.engine.rest.client.pagination.Page;
import com.liferay.data.engine.rest.client.pagination.Pagination;
import com.liferay.data.engine.rest.client.problem.Problem;
import com.liferay.data.engine.rest.client.serdes.v2_0.DataRecordSerDes;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface DataRecordResource {
    public static Builder builder() {
        return new Builder();
    }

    public Page<DataRecord> getDataDefinitionDataRecordsPage(Long var1, Long var2, String var3, Pagination var4, String var5) throws Exception;

    public HttpInvoker.HttpResponse getDataDefinitionDataRecordsPageHttpResponse(Long var1, Long var2, String var3, Pagination var4, String var5) throws Exception;

    public DataRecord postDataDefinitionDataRecord(Long var1, DataRecord var2) throws Exception;

    public HttpInvoker.HttpResponse postDataDefinitionDataRecordHttpResponse(Long var1, DataRecord var2) throws Exception;

    public void postDataDefinitionDataRecordBatch(Long var1, String var2, Object var3) throws Exception;

    public HttpInvoker.HttpResponse postDataDefinitionDataRecordBatchHttpResponse(Long var1, String var2, Object var3) throws Exception;

    public Page<DataRecord> getDataRecordCollectionDataRecordsPage(Long var1, Long var2, String var3, Pagination var4, String var5) throws Exception;

    public HttpInvoker.HttpResponse getDataRecordCollectionDataRecordsPageHttpResponse(Long var1, Long var2, String var3, Pagination var4, String var5) throws Exception;

    public DataRecord postDataRecordCollectionDataRecord(Long var1, DataRecord var2) throws Exception;

    public HttpInvoker.HttpResponse postDataRecordCollectionDataRecordHttpResponse(Long var1, DataRecord var2) throws Exception;

    public void postDataRecordCollectionDataRecordBatch(Long var1, String var2, Object var3) throws Exception;

    public HttpInvoker.HttpResponse postDataRecordCollectionDataRecordBatchHttpResponse(Long var1, String var2, Object var3) throws Exception;

    public String getDataRecordCollectionDataRecordExport(Long var1, Pagination var2) throws Exception;

    public HttpInvoker.HttpResponse getDataRecordCollectionDataRecordExportHttpResponse(Long var1, Pagination var2) throws Exception;

    public void deleteDataRecord(Long var1) throws Exception;

    public HttpInvoker.HttpResponse deleteDataRecordHttpResponse(Long var1) throws Exception;

    public void deleteDataRecordBatch(String var1, Object var2) throws Exception;

    public HttpInvoker.HttpResponse deleteDataRecordBatchHttpResponse(String var1, Object var2) throws Exception;

    public DataRecord getDataRecord(Long var1) throws Exception;

    public HttpInvoker.HttpResponse getDataRecordHttpResponse(Long var1) throws Exception;

    public DataRecord patchDataRecord(Long var1, DataRecord var2) throws Exception;

    public HttpInvoker.HttpResponse patchDataRecordHttpResponse(Long var1, DataRecord var2) throws Exception;

    public DataRecord putDataRecord(Long var1, DataRecord var2) throws Exception;

    public HttpInvoker.HttpResponse putDataRecordHttpResponse(Long var1, DataRecord var2) throws Exception;

    public void putDataRecordBatch(String var1, Object var2) throws Exception;

    public HttpInvoker.HttpResponse putDataRecordBatchHttpResponse(String var1, Object var2) throws Exception;

    public static class DataRecordResourceImpl
    implements DataRecordResource {
        private static final Logger _logger = Logger.getLogger(DataRecordResource.class.getName());
        private Builder _builder;

        @Override
        public Page<DataRecord> getDataDefinitionDataRecordsPage(Long dataDefinitionId, Long dataListViewId, String keywords, Pagination pagination, String sortString) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getDataDefinitionDataRecordsPageHttpResponse(dataDefinitionId, dataListViewId, keywords, pagination, sortString);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, DataRecordSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getDataDefinitionDataRecordsPageHttpResponse(Long dataDefinitionId, Long dataListViewId, String keywords, Pagination pagination, String sortString) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (dataListViewId != null) {
                httpInvoker.parameter("dataListViewId", String.valueOf(dataListViewId));
            }
            if (keywords != null) {
                httpInvoker.parameter("keywords", String.valueOf(keywords));
            }
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            if (sortString != null) {
                httpInvoker.parameter("sort", sortString);
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/data-engine/v2.0/data-definitions/{dataDefinitionId}/data-records", dataDefinitionId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public DataRecord postDataDefinitionDataRecord(Long dataDefinitionId, DataRecord dataRecord) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postDataDefinitionDataRecordHttpResponse(dataDefinitionId, dataRecord);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return DataRecordSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postDataDefinitionDataRecordHttpResponse(Long dataDefinitionId, DataRecord dataRecord) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(dataRecord.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/data-engine/v2.0/data-definitions/{dataDefinitionId}/data-records", dataDefinitionId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void postDataDefinitionDataRecordBatch(Long dataDefinitionId, String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postDataDefinitionDataRecordBatchHttpResponse(dataDefinitionId, callbackURL, object);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postDataDefinitionDataRecordBatchHttpResponse(Long dataDefinitionId, String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/data-engine/v2.0/data-definitions/{dataDefinitionId}/data-records/batch", dataDefinitionId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Page<DataRecord> getDataRecordCollectionDataRecordsPage(Long dataRecordCollectionId, Long dataListViewId, String keywords, Pagination pagination, String sortString) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getDataRecordCollectionDataRecordsPageHttpResponse(dataRecordCollectionId, dataListViewId, keywords, pagination, sortString);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, DataRecordSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getDataRecordCollectionDataRecordsPageHttpResponse(Long dataRecordCollectionId, Long dataListViewId, String keywords, Pagination pagination, String sortString) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (dataListViewId != null) {
                httpInvoker.parameter("dataListViewId", String.valueOf(dataListViewId));
            }
            if (keywords != null) {
                httpInvoker.parameter("keywords", String.valueOf(keywords));
            }
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            if (sortString != null) {
                httpInvoker.parameter("sort", sortString);
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/data-engine/v2.0/data-record-collections/{dataRecordCollectionId}/data-records", dataRecordCollectionId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public DataRecord postDataRecordCollectionDataRecord(Long dataRecordCollectionId, DataRecord dataRecord) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postDataRecordCollectionDataRecordHttpResponse(dataRecordCollectionId, dataRecord);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return DataRecordSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postDataRecordCollectionDataRecordHttpResponse(Long dataRecordCollectionId, DataRecord dataRecord) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(dataRecord.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/data-engine/v2.0/data-record-collections/{dataRecordCollectionId}/data-records", dataRecordCollectionId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void postDataRecordCollectionDataRecordBatch(Long dataRecordCollectionId, String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postDataRecordCollectionDataRecordBatchHttpResponse(dataRecordCollectionId, callbackURL, object);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postDataRecordCollectionDataRecordBatchHttpResponse(Long dataRecordCollectionId, String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/data-engine/v2.0/data-record-collections/{dataRecordCollectionId}/data-records/batch", dataRecordCollectionId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public String getDataRecordCollectionDataRecordExport(Long dataRecordCollectionId, Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getDataRecordCollectionDataRecordExportHttpResponse(dataRecordCollectionId, pagination);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return content;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getDataRecordCollectionDataRecordExportHttpResponse(Long dataRecordCollectionId, Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/data-engine/v2.0/data-record-collections/{dataRecordCollectionId}/data-records/export", dataRecordCollectionId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteDataRecord(Long dataRecordId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteDataRecordHttpResponse(dataRecordId);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteDataRecordHttpResponse(Long dataRecordId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/data-engine/v2.0/data-records/{dataRecordId}", dataRecordId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteDataRecordBatch(String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteDataRecordBatchHttpResponse(callbackURL, object);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteDataRecordBatchHttpResponse(String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/data-engine/v2.0/data-records/batch", new Object[0]);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public DataRecord getDataRecord(Long dataRecordId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getDataRecordHttpResponse(dataRecordId);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return DataRecordSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getDataRecordHttpResponse(Long dataRecordId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/data-engine/v2.0/data-records/{dataRecordId}", dataRecordId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public DataRecord patchDataRecord(Long dataRecordId, DataRecord dataRecord) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.patchDataRecordHttpResponse(dataRecordId, dataRecord);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return DataRecordSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse patchDataRecordHttpResponse(Long dataRecordId, DataRecord dataRecord) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(dataRecord.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PATCH);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/data-engine/v2.0/data-records/{dataRecordId}", dataRecordId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public DataRecord putDataRecord(Long dataRecordId, DataRecord dataRecord) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putDataRecordHttpResponse(dataRecordId, dataRecord);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return DataRecordSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse putDataRecordHttpResponse(Long dataRecordId, DataRecord dataRecord) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(dataRecord.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/data-engine/v2.0/data-records/{dataRecordId}", dataRecordId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void putDataRecordBatch(String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putDataRecordBatchHttpResponse(callbackURL, object);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse putDataRecordBatchHttpResponse(String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/data-engine/v2.0/data-records/batch", new Object[0]);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        private DataRecordResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }

    public static class Builder {
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login = "";
        private String _password = "";
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public DataRecordResource build() {
            return new DataRecordResourceImpl(this);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        private Builder() {
        }
    }
}

