/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.resource.exception;

import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataDefinitionValidationException
extends RuntimeException {
    public DataDefinitionValidationException() {
    }

    public DataDefinitionValidationException(String msg) {
        super(msg);
    }

    public DataDefinitionValidationException(String msg, Throwable throwable) {
        super(msg, throwable);
    }

    public DataDefinitionValidationException(Throwable throwable) {
        super(throwable);
    }

    private static class MustSetValidFieldExpression
    extends DataDefinitionValidationException {
        protected String expression;
        protected String fieldName;

        public MustSetValidFieldExpression(String fieldName, String expression, String message) {
            super(message);
            this.fieldName = fieldName;
            this.expression = expression;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }

    public static class MustSetValidVisibilityExpression
    extends MustSetValidFieldExpression {
        public MustSetValidVisibilityExpression(String fieldName, String expression) {
            super(fieldName, "visibility", expression);
        }

        public String getVisibilityExpression() {
            return this.expression;
        }
    }

    public static class MustSetValidValidationExpression
    extends MustSetValidFieldExpression {
        private static final Pattern _validationExpressionPattern = Pattern.compile("(contains|match)\\((.+), \"(.+)\"\\)");

        public MustSetValidValidationExpression(String fieldName, String expression) {
            super(fieldName, "validation", expression);
        }

        public String getValidationExpression() {
            return this.expression;
        }

        public String getValidationExpressionArgument() {
            Matcher matcher = _validationExpressionPattern.matcher(this.expression);
            if (matcher.find()) {
                return matcher.group(3);
            }
            return "";
        }
    }

    public static class MustSetValidType
    extends DataDefinitionValidationException {
        private final String _fieldType;

        public MustSetValidType(String fieldType) {
            super(String.format("Invalid type set for field type %s", fieldType));
            this._fieldType = fieldType;
        }

        public String getFieldType() {
            return this._fieldType;
        }
    }

    public static class MustSetValidRuleExpression
    extends DataDefinitionValidationException {
        private final String _expression;

        public MustSetValidRuleExpression(String expression, String message) {
            super(message);
            this._expression = expression;
        }

        public String getExpression() {
            return this._expression;
        }
    }

    public static class MustSetValidName
    extends DataDefinitionValidationException {
        public MustSetValidName(String message) {
            super(message);
        }
    }

    public static class MustSetValidIndexType
    extends DataDefinitionValidationException {
        private String _fieldName;

        public MustSetValidIndexType(String fieldName) {
            super(String.format("Invalid index type set for field %s", fieldName));
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetValidDefaultLocaleForProperty
    extends DataDefinitionValidationException {
        private String _fieldName;
        private String _property;

        public MustSetValidDefaultLocaleForProperty(String fieldName, String property) {
            super(String.format("Invalid default locale set for the property '%s' of field name %s", property, fieldName));
            this._fieldName = fieldName;
            this._property = property;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public String getProperty() {
            return this._property;
        }
    }

    public static class MustSetValidContentType
    extends DataDefinitionValidationException {
        private final String _contentType;

        public MustSetValidContentType(String contentType) {
            super(String.format("Invalid content type %s", contentType));
            this._contentType = contentType;
        }

        public String getContentType() {
            return this._contentType;
        }
    }

    public static class MustSetValidCharactersForFieldType
    extends DataDefinitionValidationException {
        private final String _fieldType;

        public MustSetValidCharactersForFieldType(String fieldType) {
            super(String.format("Invalid characters entered for field type %s", fieldType));
            this._fieldType = fieldType;
        }

        public String getFieldType() {
            return this._fieldType;
        }
    }

    public static class MustSetValidCharactersForFieldName
    extends DataDefinitionValidationException {
        private String _fieldName;

        public MustSetValidCharactersForFieldName(String fieldName) {
            super(String.format("Invalid characters entered for field name %s", fieldName));
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetValidAvailableLocalesForProperty
    extends DataDefinitionValidationException {
        private String _fieldName;
        private String _property;

        public MustSetValidAvailableLocalesForProperty(String fieldName, String property) {
            super(String.format("Invalid available locales set for the property '%s' of field name %s", property, fieldName));
            this._fieldName = fieldName;
            this._property = property;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public String getProperty() {
            return this._property;
        }
    }

    public static class MustSetOptionsForField
    extends DataDefinitionValidationException {
        private String _fieldName;

        public MustSetOptionsForField(String fieldName) {
            super(String.format("At least one option must be set for field %s", fieldName));
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetFieldType
    extends DataDefinitionValidationException {
        private String _fieldName;

        public MustSetFieldType(String fieldName) {
            super(String.format("The field type was never set for the data definition field with the field name %s", fieldName));
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetFields
    extends DataDefinitionValidationException {
        public MustSetFields() {
            super("There are no fields for the data definition");
        }
    }

    public static class MustSetDefaultLocaleAsAvailableLocale
    extends DataDefinitionValidationException {
        private final Locale _defaultLocale;

        public MustSetDefaultLocaleAsAvailableLocale(Locale defaultLocale) {
            super(String.format("The default locale %s must be set to a valid available locale", defaultLocale));
            this._defaultLocale = defaultLocale;
        }

        public Locale getDefaultLocale() {
            return this._defaultLocale;
        }
    }

    public static class MustSetDefaultLocale
    extends DataDefinitionValidationException {
        public MustSetDefaultLocale() {
            super("The default locale property was not set for the data definition");
        }
    }

    public static class MustSetAvailableLocales
    extends DataDefinitionValidationException {
        public MustSetAvailableLocales() {
            super("The available locales property was not set for the data definition");
        }
    }

    public static class MustNotRemoveNativeField
    extends DataDefinitionValidationException {
        private final Set<String> _removedFieldNames;

        public MustNotRemoveNativeField(Set<String> removedFieldNames) {
            super(String.format("Native fields %s were removed", removedFieldNames));
            this._removedFieldNames = removedFieldNames;
        }

        public Set<String> getRemovedFieldNames() {
            return this._removedFieldNames;
        }
    }

    public static class MustNotDuplicateFieldName
    extends DataDefinitionValidationException {
        private final Set<String> _duplicatedFieldNames;

        public MustNotDuplicateFieldName(Set<String> duplicatedFieldNames) {
            super(String.format("Field names %s were defined more than once", duplicatedFieldNames));
            this._duplicatedFieldNames = duplicatedFieldNames;
        }

        public Set<String> getDuplicatedFieldNames() {
            return this._duplicatedFieldNames;
        }
    }
}

