/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.field.type;

import com.liferay.data.engine.field.type.FieldType;
import com.liferay.data.engine.field.type.FieldTypeTracker;
import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.spi.dto.SPIDataDefinitionField;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseFieldType
implements FieldType {
    @Override
    public SPIDataDefinitionField deserialize(FieldTypeTracker fieldTypeTracker, JSONObject jsonObject) throws Exception {
        if (!jsonObject.has("name")) {
            throw new Exception("Name is required");
        }
        if (!jsonObject.has("type")) {
            throw new Exception("Type is required");
        }
        SPIDataDefinitionField spiDataDefinitionField = new SPIDataDefinitionField();
        spiDataDefinitionField.setDefaultValue(LocalizedValueUtil.toLocalizedValues(jsonObject.getJSONObject("defaultValue")));
        spiDataDefinitionField.setFieldType(jsonObject.getString("type"));
        spiDataDefinitionField.setIndexable(jsonObject.getBoolean("indexable", true));
        spiDataDefinitionField.setIndexType(jsonObject.getString("indexType"));
        spiDataDefinitionField.setLabel(LocalizedValueUtil.toLocalizedValues(Optional.ofNullable(jsonObject.getJSONObject("label")).orElse(JSONFactoryUtil.createJSONObject())));
        spiDataDefinitionField.setLocalizable(jsonObject.getBoolean("localizable", false));
        spiDataDefinitionField.setName(jsonObject.getString("name"));
        if (jsonObject.has("nestedDataDefinitionFields")) {
            spiDataDefinitionField.setNestedSPIDataDefinitionFields((SPIDataDefinitionField[])JSONUtil.toArray((JSONArray)((JSONArray)GetterUtil.getObject((Object)jsonObject.getJSONArray("nestedDataDefinitionFields"), (Object)JSONFactoryUtil.createJSONArray())), nestedDataDefinitionFieldJSONObject -> {
                if (jsonObject.has("type")) {
                    FieldType fieldType = fieldTypeTracker.getFieldType(nestedDataDefinitionFieldJSONObject.getString("type"));
                    return fieldType.deserialize(fieldTypeTracker, (JSONObject)nestedDataDefinitionFieldJSONObject);
                }
                return null;
            }, SPIDataDefinitionField.class));
        }
        spiDataDefinitionField.setReadOnly(jsonObject.getBoolean("readOnly"));
        spiDataDefinitionField.setRepeatable(jsonObject.getBoolean("repeatable"));
        spiDataDefinitionField.setRequired(jsonObject.getBoolean("required"));
        spiDataDefinitionField.setShowlabel(jsonObject.getBoolean("showLabel", true));
        spiDataDefinitionField.setTip(LocalizedValueUtil.toLocalizedValues(Optional.ofNullable(jsonObject.getJSONObject("tip")).orElse(JSONFactoryUtil.createJSONObject())));
        spiDataDefinitionField.setVisible(jsonObject.getBoolean("visible", true));
        return spiDataDefinitionField;
    }

    @Override
    public Map<String, Object> includeContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SPIDataDefinitionField spiDataDefinitionField) {
        HashMap context = HashMapBuilder.put((Object)"dir", (Object)LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"lang.dir")).put((Object)"fieldName", (Object)spiDataDefinitionField.getName()).put((Object)"indexable", (Object)spiDataDefinitionField.getIndexable()).put((Object)"indexType", (Object)spiDataDefinitionField.getIndexType()).put((Object)"label", (Object)MapUtil.getString((Map)spiDataDefinitionField.getLabel(), (String)LocaleUtil.toLanguageId((Locale)httpServletRequest.getLocale()))).put((Object)"localizable", (Object)spiDataDefinitionField.getLocalizable()).put((Object)"name", (Object)spiDataDefinitionField.getName()).put((Object)"nestedDataDefinitionFields", (Object)spiDataDefinitionField.getNestedSPIDataDefinitionFields()).put((Object)"predefinedValue", LocalizedValueUtil.getLocalizedValue(httpServletRequest.getLocale(), spiDataDefinitionField.getDefaultValue())).put((Object)"readOnly", (Object)spiDataDefinitionField.getReadOnly()).put((Object)"repeatable", (Object)spiDataDefinitionField.getRepeatable()).put((Object)"required", (Object)spiDataDefinitionField.getRequired()).put((Object)"showLabel", (Object)spiDataDefinitionField.getShowLabel()).put((Object)"tip", (Object)MapUtil.getString((Map)spiDataDefinitionField.getTip(), (String)LocaleUtil.toLanguageId((Locale)httpServletRequest.getLocale()))).put((Object)"type", (Object)spiDataDefinitionField.getFieldType()).put((Object)"visible", (Object)spiDataDefinitionField.getVisible()).build();
        this.includeContext(context, httpServletRequest, httpServletResponse, spiDataDefinitionField);
        return context;
    }

    @Override
    public JSONObject toJSONObject(FieldTypeTracker fieldTypeTracker, SPIDataDefinitionField spiDataDefinitionField) throws Exception {
        String name = spiDataDefinitionField.getName();
        if (Validator.isNull((String)name)) {
            throw new Exception("Name is required");
        }
        String type = spiDataDefinitionField.getFieldType();
        if (type == null || type.isEmpty()) {
            throw new Exception("Type is required");
        }
        return JSONUtil.put((String)"dataType", (Object)MapUtil.getString((Map)spiDataDefinitionField.getCustomProperties(), (String)"dataType")).put("defaultValue", LocalizedValueUtil.toJSONObject(spiDataDefinitionField.getDefaultValue())).put("indexable", spiDataDefinitionField.getIndexable()).put("indexType", spiDataDefinitionField.getIndexType()).put("label", LocalizedValueUtil.toJSONObject(spiDataDefinitionField.getLabel())).put("localizable", spiDataDefinitionField.getLocalizable()).put("name", name).put("nestedDataDefinitionFields", JSONUtil.toJSONArray((Object[])spiDataDefinitionField.getNestedSPIDataDefinitionFields(), nestedSPIDataDefinitionField -> {
            FieldType fieldType = fieldTypeTracker.getFieldType(nestedSPIDataDefinitionField.getFieldType());
            return fieldType.toJSONObject(fieldTypeTracker, (SPIDataDefinitionField)nestedSPIDataDefinitionField);
        })).put("readOnly", spiDataDefinitionField.getReadOnly()).put("repeatable", spiDataDefinitionField.getRepeatable()).put("required", spiDataDefinitionField.getRequired()).put("showLabel", spiDataDefinitionField.getShowLabel()).put("tip", LocalizedValueUtil.toJSONObject(spiDataDefinitionField.getTip())).put("type", type).put("visible", spiDataDefinitionField.getVisible());
    }

    protected abstract void includeContext(Map<String, Object> var1, HttpServletRequest var2, HttpServletResponse var3, SPIDataDefinitionField var4);
}

