/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.upgrade.registry;

import com.liferay.change.tracking.store.service.CTSContentLocalService;
import com.liferay.data.cleanup.internal.configuration.DataCleanupConfiguration;
import com.liferay.data.cleanup.internal.configuration.DataRemovalConfiguration;
import com.liferay.data.cleanup.internal.upgrade.ChatUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.DictionaryUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.DirectoryUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.ExpiredJournalArticleUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.ImageEditorUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.InvitationUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.MailReaderUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.OpenSocialUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.PrivateMessagingUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.PublishedCTSContentDataUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.ShoppingUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SoftwareCatalogUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.TwitterUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.UpgradeHelloWorld;
import com.liferay.data.cleanup.internal.upgrade.util.ConfigurationUtil;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.function.Supplier;
import org.apache.felix.cm.PersistenceManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.data.cleanup.internal.configuration.DataCleanupConfiguration", "com.liferay.data.cleanup.internal.configuration.DataRemovalConfiguration"}, service={UpgradeStepRegistrator.class})
public class DataCleanupUpgradeStepRegistrator
implements UpgradeStepRegistrator {
    @Reference
    private CTSContentLocalService _ctsContentLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private PersistenceManager _persistenceManager;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private ReleaseLocalService _releaseLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;

    public void register(UpgradeStepRegistrator.Registry registry) {
        try {
            DataCleanupConfiguration dataCleanupConfiguration = ConfigurationUtil.getAndResetConfiguration(this._persistenceManager, DataCleanupConfiguration.class);
            this._cleanUpModuleData(dataCleanupConfiguration::cleanUpChatModuleData, "com.liferay.chat.service", ChatUpgradeProcess::new);
            this._cleanUpModuleData(dataCleanupConfiguration::cleanUpDictionaryModuleData, "com.liferay.dictionary.web", DictionaryUpgradeProcess::new);
            this._cleanUpModuleData(dataCleanupConfiguration::cleanUpDirectoryModuleData, "com.liferay.directory.web", DirectoryUpgradeProcess::new);
            this._cleanUpModuleData(dataCleanupConfiguration::cleanUpImageEditorModuleData, "com.liferay.frontend.image.editor.web", ImageEditorUpgradeProcess::new);
            this._cleanUpModuleData(dataCleanupConfiguration::cleanUpHelloWorldModuleData, "com.liferay.hello.world.web", UpgradeHelloWorld::new);
            this._cleanUpModuleData(dataCleanupConfiguration::cleanUpInvitationModuleData, "com.liferay.invitation.web", InvitationUpgradeProcess::new);
            this._cleanUpModuleData(dataCleanupConfiguration::cleanUpMailReaderModuleData, "com.liferay.mail.reader.service", MailReaderUpgradeProcess::new);
            this._cleanUpModuleData(dataCleanupConfiguration::cleanUpShoppingModuleData, "com.liferay.shopping.service", () -> new ShoppingUpgradeProcess(this._imageLocalService));
            this._cleanUpModuleData(dataCleanupConfiguration::cleanUpPrivateMessagingModuleData, "com.liferay.social.privatemessaging.service", () -> new PrivateMessagingUpgradeProcess(this._mbThreadLocalService));
            this._cleanUpModuleData(dataCleanupConfiguration::cleanUpSoftwareCatalogModuleData, "com.liferay.softwarecatalog.service", () -> new SoftwareCatalogUpgradeProcess(this._imageLocalService, this._mbMessageLocalService, this._ratingsStatsLocalService, this._subscriptionLocalService));
            this._cleanUpModuleData(dataCleanupConfiguration::cleanUpTwitterModuleData, "com.liferay.twitter.service", TwitterUpgradeProcess::new);
            this._cleanUpModuleData(dataCleanupConfiguration::cleanUpOpenSocialModuleData, "opensocial-portlet", () -> new OpenSocialUpgradeProcess(this._expandoTableLocalService));
            DataRemovalConfiguration dataRemovalConfiguration = ConfigurationUtil.getAndResetConfiguration(this._persistenceManager, DataRemovalConfiguration.class);
            this._removeModuleData(dataRemovalConfiguration::removePublishedCTSContentData, "com.liferay.change.tracking.store.service", () -> new PublishedCTSContentDataUpgradeProcess(this._ctsContentLocalService, this._portal));
            this._removeModuleData(dataRemovalConfiguration::removeExpiredJournalArticles, "com.liferay.journal.service", () -> new ExpiredJournalArticleUpgradeProcess(this._journalArticleLocalService));
        }
        catch (Exception exception) {
            ReflectionUtil.throwException((Throwable)exception);
        }
    }

    private void _cleanUpModuleData(Supplier<Boolean> booleanSupplier, String servletContextName, Supplier<UpgradeProcess> upgradeProcessSupplier) throws UpgradeException {
        Release release;
        if (booleanSupplier.get().booleanValue() && (release = this._releaseLocalService.fetchRelease(servletContextName)) != null) {
            UpgradeProcess upgradeProcess = upgradeProcessSupplier.get();
            upgradeProcess.upgrade();
            CacheRegistryUtil.clear();
        }
    }

    private void _removeModuleData(Supplier<Boolean> booleanSupplier, String servletContextName, Supplier<UpgradeProcess> upgradeProcessSupplier) throws UpgradeException {
        Release release;
        if (booleanSupplier.get().booleanValue() && (release = this._releaseLocalService.fetchRelease(servletContextName)) != null) {
            UpgradeProcess upgradeProcess = upgradeProcessSupplier.get();
            upgradeProcess.upgrade();
            CacheRegistryUtil.clear();
        }
    }
}

