/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.css.builder.maven;

import com.liferay.css.builder.CSSBuilder;
import com.liferay.css.builder.CSSBuilderArgs;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.util.Scanner;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.sonatype.plexus.build.incremental.BuildContext;

public class BuildCSSMojo
extends AbstractMojo {
    private File _baseDir;
    private BuildContext _buildContext;
    private final CSSBuilderArgs _cssBuilderArgs = new CSSBuilderArgs();
    private PluginDescriptor _pluginDescriptor;
    private MavenProject _project;
    private RepositorySystem _repositorySystem;
    private RepositorySystemSession _repositorySystemSession;

    public void execute() throws MojoExecutionException {
        try {
            for (ComponentDependency componentDependency : this._pluginDescriptor.getDependencies()) {
                String artifactId = componentDependency.getArtifactId();
                if (!artifactId.equals("com.liferay.frontend.css.common") || this._cssBuilderArgs.getPortalCommonPath() != null) continue;
                Artifact artifact = this._resolveArtifact(componentDependency);
                this._cssBuilderArgs.setPortalCommonPath(artifact.getFile());
            }
            if (this._buildContext.isIncremental()) {
                Scanner scanner = this._buildContext.newScanner(this._baseDir);
                String[] includes = new String[]{"", "**/*.scss"};
                scanner.setIncludes(includes);
                scanner.scan();
                Object[] includedFiles = scanner.getIncludedFiles();
                if (ArrayUtil.isNotEmpty(includedFiles)) {
                    this._execute();
                }
            } else {
                this._execute();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public void setAppendCssImportTimestamps(boolean appendCssImportTimestamps) {
        this._cssBuilderArgs.setAppendCssImportTimestamps(appendCssImportTimestamps);
    }

    public void setDirNames(String dirNames) {
        this._cssBuilderArgs.setDirNames(dirNames);
    }

    public void setDocrootDirName(String docrootDirName) {
        File docrootDir = new File(docrootDirName);
        if (!docrootDir.isAbsolute()) {
            docrootDir = new File(this._baseDir, docrootDirName);
        }
        this._cssBuilderArgs.setDocrootDir(docrootDir);
    }

    public void setGenerateSourceMap(boolean generateSourceMap) {
        this._cssBuilderArgs.setGenerateSourceMap(generateSourceMap);
    }

    public void setOutputDirName(String outputDirName) {
        this._cssBuilderArgs.setOutputDirName(outputDirName);
    }

    public void setPortalCommonPath(File portalCommonPath) {
        this._cssBuilderArgs.setPortalCommonPath(portalCommonPath);
    }

    public void setPrecision(int precision) {
        this._cssBuilderArgs.setPrecision(precision);
    }

    public void setRtlExcludedPathRegexps(String rtlExcludedPathRegexps) {
        this._cssBuilderArgs.setRtlExcludedPathRegexps(rtlExcludedPathRegexps);
    }

    public void setSassCompilerClassName(String sassCompilerClassName) {
        this._cssBuilderArgs.setSassCompilerClassName(sassCompilerClassName);
    }

    private void _execute() throws Exception {
        try (CSSBuilder cssBuilder = new CSSBuilder(this._cssBuilderArgs);){
            cssBuilder.execute();
        }
    }

    private Artifact _resolveArtifact(ComponentDependency componentDependency) throws ArtifactResolutionException {
        DefaultArtifact artifact = new DefaultArtifact(componentDependency.getGroupId(), componentDependency.getArtifactId(), componentDependency.getType(), componentDependency.getVersion());
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)artifact);
        ArrayList repositories = new ArrayList();
        repositories.addAll(this._project.getRemotePluginRepositories());
        repositories.addAll(this._project.getRemoteProjectRepositories());
        artifactRequest.setRepositories(repositories);
        ArtifactResult artifactResult = this._repositorySystem.resolveArtifact(this._repositorySystemSession, artifactRequest);
        return artifactResult.getArtifact();
    }
}

