/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.css.builder;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.liferay.css.builder.CSSBuilderArgs;
import com.liferay.css.builder.CSSBuilderUtil;
import com.liferay.css.builder.internal.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.rtl.css.RTLCSSConverter;
import com.liferay.sass.compiler.SassCompiler;
import com.liferay.sass.compiler.SassCompilerException;
import com.liferay.sass.compiler.jni.internal.JniSassCompiler;
import com.liferay.sass.compiler.ruby.internal.RubySassCompiler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CSSBuilder
implements AutoCloseable {
    private static final String[] _EXCLUDES = new String[]{"**\\_diffs\\**", "**\\.sass-cache*\\**", "**\\.sass_cache_*\\**", "**\\_sass_cache_*\\**", "**\\_styled\\**", "**\\_unstyled\\**", "**\\css\\aui\\**", "**\\tmp\\**"};
    private static RTLCSSConverter _rtlCSSConverter;
    private final boolean _cleanPortalCommonDir;
    private final CSSBuilderArgs _cssBuilderArgs;
    private final String _portalCommonDirName;
    private final Pattern[] _rtlExcludedPathPatterns;
    private SassCompiler _sassCompiler;

    public static void main(String[] args) throws Exception {
        block17: {
            CSSBuilderArgs cssBuilderArgs = new CSSBuilderArgs();
            JCommander jCommander = new JCommander((Object)cssBuilderArgs);
            try {
                File jarFile = FileUtil.getJarFile();
                if (jarFile.isFile()) {
                    jCommander.setProgramName("java -jar " + jarFile.getName());
                } else {
                    jCommander.setProgramName(CSSBuilder.class.getName());
                }
                jCommander.parse(args);
                if (cssBuilderArgs.isHelp()) {
                    CSSBuilder._printHelp(jCommander);
                    break block17;
                }
                try (CSSBuilder cssBuilder = new CSSBuilder(cssBuilderArgs);){
                    cssBuilder.execute();
                }
            }
            catch (ParameterException pe) {
                System.err.println(pe.getMessage());
                CSSBuilder._printHelp(jCommander);
                System.exit(1);
            }
        }
    }

    public CSSBuilder(CSSBuilderArgs cssBuilderArgs) throws Exception {
        this._cssBuilderArgs = cssBuilderArgs;
        File portalCommonDir = this._cssBuilderArgs.getPortalCommonPath();
        if (portalCommonDir.isFile()) {
            portalCommonDir = this._unzipPortalCommon(portalCommonDir);
            this._cleanPortalCommonDir = true;
        } else {
            this._cleanPortalCommonDir = false;
        }
        this._portalCommonDirName = portalCommonDir.getCanonicalPath();
        List<String> rtlExcludedPathRegexps = this._cssBuilderArgs.getRtlExcludedPathRegexps();
        this._rtlExcludedPathPatterns = new Pattern[rtlExcludedPathRegexps.size()];
        for (int i = 0; i < rtlExcludedPathRegexps.size(); ++i) {
            this._rtlExcludedPathPatterns[i] = Pattern.compile(rtlExcludedPathRegexps.get(i));
        }
        this._initSassCompiler(this._cssBuilderArgs.getSassCompilerClassName());
    }

    @Override
    public void close() throws Exception {
        if (this._cleanPortalCommonDir) {
            FileUtil.deltree(Paths.get(this._portalCommonDirName, new String[0]));
        }
        this._sassCompiler.close();
    }

    public void execute() throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        File docrootDir = this._cssBuilderArgs.getDocrootDir();
        for (String dirName : this._cssBuilderArgs.getDirNames()) {
            List<String> sassFileNames = this._collectSassFiles(dirName, docrootDir);
            fileNames.addAll(sassFileNames);
        }
        for (String fileName : fileNames) {
            long startTime = System.currentTimeMillis();
            this._parseSassFile(fileName);
            System.out.println("Parsed " + fileName + " in " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }

    public boolean isRtlExcludedPath(String filePath) {
        for (Pattern pattern : this._rtlExcludedPathPatterns) {
            Matcher matcher = pattern.matcher(filePath);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    private static void _printHelp(JCommander jCommander) throws Exception {
        jCommander.usage();
    }

    private List<String> _collectSassFiles(String dirName, File docrootDir) throws Exception {
        String[] scssFragments;
        long newestFragmentModifiedTime;
        long oldestSassModifiedTime;
        String[] scssFiles;
        ArrayList<String> fileNames = new ArrayList<String>();
        String basedir = new File(docrootDir, dirName).toString();
        if (!this._isModified(basedir, scssFiles = this._getScssFiles(basedir)) && (oldestSassModifiedTime = this._getOldestModifiedTime(basedir, scssFiles)) > (newestFragmentModifiedTime = this._getNewestModifiedTime(basedir, scssFragments = this._getScssFragments(basedir)))) {
            return fileNames;
        }
        for (String fileName : scssFiles) {
            if (fileName.contains("_rtl")) continue;
            fileNames.add(this._normalizeFileName(dirName, fileName));
        }
        return fileNames;
    }

    private long _getNewestModifiedTime(String baseDir, String[] fileNames) {
        Stream<String> stream = Stream.of(fileNames);
        return stream.map(fileName -> Paths.get(baseDir, fileName)).map(FileUtil::getLastModifiedTime).max(Comparator.naturalOrder()).orElse(Long.MIN_VALUE);
    }

    private long _getOldestModifiedTime(String baseDir, String[] fileNames) {
        Stream<String> stream = Stream.of(fileNames);
        return stream.map(fileName -> Paths.get(baseDir, fileName)).map(FileUtil::getLastModifiedTime).min(Comparator.naturalOrder()).orElse(Long.MIN_VALUE);
    }

    private String _getRtlCss(String fileName, String css) throws Exception {
        String rtlCss = css;
        try {
            if (_rtlCSSConverter == null) {
                _rtlCSSConverter = new RTLCSSConverter();
            }
            rtlCss = _rtlCSSConverter.process(rtlCss);
        }
        catch (Exception e) {
            System.out.println("Unable to generate RTL version for " + fileName + ", " + e.getMessage());
        }
        return rtlCss;
    }

    private String[] _getScssFiles(String baseDir) {
        String[] fragments = new String[]{"**\\_*.scss"};
        String[] includes = new String[]{"**\\*.scss"};
        Stream<String[]> stream = Stream.of(fragments, _EXCLUDES);
        String[] excludes = (String[])stream.flatMap(Stream::of).toArray(String[]::new);
        return FileUtil.getFilesFromDirectory(baseDir, includes, excludes);
    }

    private String[] _getScssFragments(String baseDir) {
        String[] includes = new String[]{"**\\\\_*.scss"};
        return FileUtil.getFilesFromDirectory(baseDir, includes, _EXCLUDES);
    }

    private void _initSassCompiler(String sassCompilerClassName) throws Exception {
        int precision = this._cssBuilderArgs.getPrecision();
        if (Validator.isNull(sassCompilerClassName) || sassCompilerClassName.equals("jni")) {
            try {
                System.setProperty("jna.nosys", Boolean.TRUE.toString());
                this._sassCompiler = new JniSassCompiler(precision);
                System.out.println("Using native Sass compiler");
            }
            catch (Throwable t) {
                System.out.println("Unable to load native compiler, falling back to Ruby");
                this._sassCompiler = new RubySassCompiler(precision);
            }
        } else {
            try {
                this._sassCompiler = new RubySassCompiler(precision);
                System.out.println("Using Ruby Sass compiler");
            }
            catch (Exception e) {
                System.out.println("Unable to load Ruby compiler, falling back to native");
                System.setProperty("jna.nosys", Boolean.TRUE.toString());
                this._sassCompiler = new JniSassCompiler(precision);
            }
        }
    }

    private boolean _isModified(String dirName, String[] fileNames) throws Exception {
        for (String fileName : fileNames) {
            if (fileName.contains("_rtl")) continue;
            fileName = this._normalizeFileName(dirName, fileName);
            File file = new File(fileName);
            File cacheFile = CSSBuilderUtil.getOutputFile(fileName, this._cssBuilderArgs.getOutputDirName());
            if (file.lastModified() == cacheFile.lastModified()) continue;
            return true;
        }
        return false;
    }

    private String _normalizeFileName(String dirName, String fileName) {
        fileName = StringUtil.replace(dirName + "/" + fileName, new String[]{"\\", "//"}, new String[]{"/", "/"});
        return fileName;
    }

    private String _parseSass(String fileName) throws SassCompilerException {
        String filePath;
        File sassFile = new File(this._cssBuilderArgs.getDocrootDir(), fileName);
        String cssBasePath = filePath = sassFile.toPath().toString();
        int pos = filePath.lastIndexOf("/css/");
        if (pos >= 0) {
            cssBasePath = filePath.substring(0, pos + 4);
        } else {
            pos = filePath.lastIndexOf("/resources/");
            if (pos >= 0) {
                cssBasePath = filePath.substring(0, pos + 10);
            }
        }
        String css = this._sassCompiler.compileFile(filePath, this._portalCommonDirName + File.pathSeparator + cssBasePath, this._cssBuilderArgs.isGenerateSourceMap(), filePath + ".map");
        return CSSBuilderUtil.parseStaticTokens(css);
    }

    private void _parseSassFile(String fileName) throws Exception {
        File file = new File(this._cssBuilderArgs.getDocrootDir(), fileName);
        if (!file.exists()) {
            return;
        }
        String ltrContent = this._parseSass(fileName);
        this._writeOutputFile(fileName, ltrContent, false);
        if (this.isRtlExcludedPath(fileName)) {
            return;
        }
        String rtlContent = this._getRtlCss(fileName, ltrContent);
        String rtlCustomFileName = CSSBuilderUtil.getRtlCustomFileName(fileName);
        File rtlCustomFile = new File(this._cssBuilderArgs.getDocrootDir(), rtlCustomFileName);
        if (rtlCustomFile.exists()) {
            rtlContent = rtlContent + this._parseSass(rtlCustomFileName);
        }
        this._writeOutputFile(fileName, rtlContent, true);
    }

    private File _unzipPortalCommon(File portalCommonFile) throws IOException {
        Path portalCommonCssDirPath = Files.createTempDirectory("portalCommonCss", new FileAttribute[0]);
        try (ZipFile zipFile = new ZipFile(portalCommonFile);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String name = zipEntry.getName();
                if (name.endsWith("/") || !name.startsWith("META-INF/resources/")) continue;
                name = name.substring(19);
                Path path = portalCommonCssDirPath.resolve(name);
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.copy(zipFile.getInputStream(zipEntry), path, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return portalCommonCssDirPath.toFile();
    }

    private void _writeOutputFile(String fileName, String content, boolean rtl) throws Exception {
        String outputFileName;
        if (this._cssBuilderArgs.isAppendCssImportTimestamps()) {
            content = CSSBuilderUtil.parseCSSImports(content);
        }
        if (rtl) {
            String rtlFileName = CSSBuilderUtil.getRtlCustomFileName(fileName);
            outputFileName = CSSBuilderUtil.getOutputFileName(rtlFileName, this._cssBuilderArgs.getOutputDirName(), "");
        } else {
            outputFileName = CSSBuilderUtil.getOutputFileName(fileName, this._cssBuilderArgs.getOutputDirName(), "");
        }
        File outputFile = new File(this._cssBuilderArgs.getDocrootDir(), outputFileName);
        FileUtil.write(outputFile, content);
        File file = new File(this._cssBuilderArgs.getDocrootDir(), fileName);
        outputFile.setLastModified(file.lastModified());
    }
}

