/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.space.apio.internal.architect.resource;

import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.CollectionResource;
import com.liferay.apio.architect.routes.CollectionRoutes;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.content.space.apio.architect.identifier.ContentSpaceIdentifier;
import com.liferay.content.space.apio.architect.util.ContentSpaceUtil;
import com.liferay.folder.apio.architect.identifier.RootFolderIdentifier;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class ContentSpaceCollectionResource
implements CollectionResource<Group, Long, ContentSpaceIdentifier> {
    @Reference
    private GroupLocalService _groupLocalService;

    public CollectionRoutes<Group, Long> collectionRoutes(CollectionRoutes.Builder<Group, Long> builder) {
        return builder.addGetter(this::_getPageItems, Company.class, PermissionChecker.class).build();
    }

    public String getName() {
        return "content-space";
    }

    public ItemRoutes<Group, Long> itemRoutes(ItemRoutes.Builder<Group, Long> builder) {
        return builder.addGetter(this::_getGroup).build();
    }

    public Representor<Group> representor(Representor.Builder<Group, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("ContentSpace", new String[0]).identifier(GroupModel::getGroupId).addBoolean("active", GroupModel::isActive)).addLinkedModel("creator", PersonIdentifier.class, GroupModel::getCreatorUserId)).addLinkedModel("folder", RootFolderIdentifier.class, GroupModel::getGroupId)).addLocalizedStringByLocale("description", GroupModel::getDescription)).addLocalizedStringByLocale("name", ContentSpaceUtil::getName)).build();
    }

    private Group _getGroup(long groupId) throws PortalException {
        return this._groupLocalService.getGroup(groupId);
    }

    private PageItems<Group> _getPageItems(Pagination pagination, Company company, PermissionChecker permissionChecker) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)permissionChecker, (String)"VIEW");
        List groups = this._groupLocalService.getGroups(company.getCompanyId(), -1L, true, pagination.getStartPosition(), pagination.getEndPosition());
        int count = this._groupLocalService.getGroupsCount(company.getCompanyId(), -1L, true);
        return new PageItems((Collection)groups, count);
    }
}

