/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.dashboard.blogs.internal.item.action.provider;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.content.dashboard.blogs.internal.item.action.SharingCollaboratorsBlogsEntryContentDashboardItemAction;
import com.liferay.content.dashboard.item.action.ContentDashboardItemAction;
import com.liferay.content.dashboard.item.action.provider.ContentDashboardItemActionProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.sharing.configuration.SharingConfiguration;
import com.liferay.sharing.configuration.SharingConfigurationFactory;
import com.liferay.sharing.security.permission.SharingPermission;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ContentDashboardItemActionProvider.class})
public class SharingCollaboratorsBlogsEntryContentDashboardItemActionProvider
implements ContentDashboardItemActionProvider<BlogsEntry> {
    private static final Log _log = LogFactoryUtil.getLog(SharingCollaboratorsBlogsEntryContentDashboardItemActionProvider.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference(target="(model.class.name=com.liferay.blogs.model.BlogsEntry)")
    private ModelResourcePermission<BlogsEntry> _modelResourcePermission;
    @Reference
    private Portal _portal;
    @Reference
    private SharingConfigurationFactory _sharingConfigurationFactory;
    @Reference
    private SharingPermission _sharingPermission;

    public ContentDashboardItemAction getContentDashboardItemAction(BlogsEntry blogsEntry, HttpServletRequest httpServletRequest) {
        if (!this.isShow(blogsEntry, httpServletRequest)) {
            return null;
        }
        return new SharingCollaboratorsBlogsEntryContentDashboardItemAction(blogsEntry, httpServletRequest, this._language, this._portal);
    }

    public String getKey() {
        return "share";
    }

    public ContentDashboardItemAction.Type getType() {
        return ContentDashboardItemAction.Type.SHARING_COLLABORATORS;
    }

    public boolean isShow(BlogsEntry blogsEntry, HttpServletRequest httpServletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            if (this._isSharingEnabled(themeDisplay.getScopeGroupId()) && this._sharingPermission.containsSharePermission(themeDisplay.getPermissionChecker(), this._classNameLocalService.getClassNameId(BlogsEntry.class.getName()), blogsEntry.getEntryId(), themeDisplay.getScopeGroupId())) {
                return true;
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return false;
        }
        return false;
    }

    private boolean _isSharingEnabled(long groupId) throws PortalException {
        SharingConfiguration sharingConfiguration = this._sharingConfigurationFactory.getGroupSharingConfiguration(this._groupLocalService.getGroup(groupId));
        return sharingConfiguration.isEnabled();
    }
}

