/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.contacts.web.internal.social;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.social.kernel.model.BaseSocialRequestInterpreter;
import com.liferay.social.kernel.model.SocialRequest;
import com.liferay.social.kernel.model.SocialRequestFeedEntry;
import com.liferay.social.kernel.model.SocialRequestInterpreter;
import com.liferay.social.kernel.service.SocialActivityLocalService;
import com.liferay.social.kernel.service.SocialRelationLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_contacts_web_portlet_ContactsCenterPortlet"}, service={SocialRequestInterpreter.class})
public class ContactsCenterRequestInterpreter
extends BaseSocialRequestInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{User.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(ContactsCenterRequestInterpreter.class);
    @Reference
    private SocialActivityLocalService _socialActivityLocalService;
    @Reference
    private SocialRelationLocalService _socialRelationLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected SocialRequestFeedEntry doInterpret(SocialRequest request, ThemeDisplay themeDisplay) throws Exception {
        if (request.getType() != 12) {
            return new SocialRequestFeedEntry("", "");
        }
        StringBundler sb = new StringBundler(8);
        sb.append("<a href=\"");
        sb.append(themeDisplay.getPortalURL());
        sb.append(themeDisplay.getPathFriendlyURLPublic());
        sb.append("/");
        User creatorUser = this._userLocalService.getUserById(request.getUserId());
        sb.append(creatorUser.getScreenName());
        sb.append("/profile\">");
        sb.append(this.getUserName(request.getUserId(), themeDisplay));
        sb.append("</a>");
        String creatorUserNameURL = sb.toString();
        String title = themeDisplay.translate("request-social-networking-summary-add-connection", new Object[]{creatorUserNameURL});
        return new SocialRequestFeedEntry(title, "");
    }

    protected boolean doProcessConfirmation(SocialRequest request, ThemeDisplay themeDisplay) {
        try {
            this._socialRelationLocalService.addRelation(request.getUserId(), request.getReceiverUserId(), 12);
            this._socialActivityLocalService.addActivity(request.getUserId(), 0L, User.class.getName(), request.getUserId(), 12, "", request.getReceiverUserId());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return true;
    }
}

