/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.contacts.web.internal.portlet;

import com.liferay.announcements.kernel.service.AnnouncementsDeliveryLocalService;
import com.liferay.contacts.exception.DuplicateEntryEmailAddressException;
import com.liferay.contacts.exception.EntryEmailAddressException;
import com.liferay.contacts.model.Entry;
import com.liferay.contacts.service.EntryLocalService;
import com.liferay.contacts.util.ContactsUtil;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.exception.AddressCityException;
import com.liferay.portal.kernel.exception.AddressStreetException;
import com.liferay.portal.kernel.exception.AddressZipException;
import com.liferay.portal.kernel.exception.ContactFirstNameException;
import com.liferay.portal.kernel.exception.ContactFullNameException;
import com.liferay.portal.kernel.exception.ContactLastNameException;
import com.liferay.portal.kernel.exception.DuplicateUserEmailAddressException;
import com.liferay.portal.kernel.exception.EmailAddressException;
import com.liferay.portal.kernel.exception.NoSuchCountryException;
import com.liferay.portal.kernel.exception.NoSuchListTypeException;
import com.liferay.portal.kernel.exception.NoSuchRegionException;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PhoneNumberException;
import com.liferay.portal.kernel.exception.PhoneNumberExtensionException;
import com.liferay.portal.kernel.exception.ReservedUserEmailAddressException;
import com.liferay.portal.kernel.exception.ReservedUserScreenNameException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.exception.UserScreenNameException;
import com.liferay.portal.kernel.exception.UserSmsException;
import com.liferay.portal.kernel.exception.WebsiteURLException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.notifications.UserNotificationManagerUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.comparator.UserLastNameComparator;
import com.liferay.social.kernel.exception.NoSuchRelationException;
import com.liferay.social.kernel.model.SocialRelation;
import com.liferay.social.kernel.model.SocialRequest;
import com.liferay.social.kernel.service.SocialRelationLocalService;
import com.liferay.social.kernel.service.SocialRequestLocalService;
import com.liferay.users.admin.configuration.UserFileUploadsConfiguration;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.users.admin.configuration.UserFileUploadsConfiguration"}, immediate=true, property={"com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.css-class-wrapper=contacts-portlet", "com.liferay.portlet.display-category=category.social", "com.liferay.portlet.friendly-url-mapping=contacts", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.header-portlet-javascript=/js/main.js", "com.liferay.portlet.icon=/icons/contacts_center.png", "javax.portlet.display-name=Contacts Center", "javax.portlet.expiration-cache=0", "javax.portlet.info.keywords=Contacts Center", "javax.portlet.info.short-title=Contacts Center", "javax.portlet.info.title=Contacts Center", "javax.portlet.init-param.config-template=/configuration.jsp", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_contacts_web_portlet_ContactsCenterPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator,power-user,user", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class ContactsCenterPortlet
extends MVCPortlet {
    @Reference
    protected AnnouncementsDeliveryLocalService announcementsDeliveryLocalService;
    @Reference
    protected DLAppLocalService dlAppLocalService;
    @Reference
    protected EntryLocalService entryLocalService;
    @Reference
    protected Portal portal;
    @Reference
    protected RoleLocalService roleLocalService;
    @Reference
    protected SocialRelationLocalService socialRelationLocalService;
    @Reference
    protected SocialRequestLocalService socialRequestLocalService;
    @Reference
    protected UserLocalService userLocalService;
    @Reference
    protected UserNotificationEventLocalService userNotificationEventLocalService;
    @Reference
    protected UserService userService;
    private static final Log _log = LogFactoryUtil.getLog(ContactsCenterPortlet.class);
    private volatile UserFileUploadsConfiguration _userFileUploadsConfiguration;

    public void addSocialRelation(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] userIds = this.getUserIds(actionRequest);
        int type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type");
        if (type == 12) {
            return;
        }
        for (long userId : userIds) {
            if (userId == themeDisplay.getUserId()) continue;
            boolean blocked = this.socialRelationLocalService.hasRelation(userId, themeDisplay.getUserId(), 9);
            if (type == 9) {
                this.socialRelationLocalService.deleteRelations(themeDisplay.getUserId(), userId);
                this.socialRelationLocalService.deleteRelations(userId, themeDisplay.getUserId());
            } else if (blocked) continue;
            this.socialRelationLocalService.addRelation(themeDisplay.getUserId(), userId, type);
            if (!blocked) continue;
            this.socialRelationLocalService.addRelation(userId, themeDisplay.getUserId(), type);
        }
    }

    public void deleteSocialRelation(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] userIds = this.getUserIds(actionRequest);
        int type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type");
        for (long userId : userIds) {
            if (userId == themeDisplay.getUserId()) continue;
            try {
                this.socialRelationLocalService.deleteRelation(themeDisplay.getUserId(), userId, type);
            }
            catch (NoSuchRelationException nsre) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)nsre, (Throwable)nsre);
            }
        }
    }

    public void exportVCard(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        long userId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"userId");
        User user = this.userService.getUserById(userId);
        String vCard = ContactsUtil.getVCard((User)user);
        PortletResponseUtil.sendFile((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (String)(user.getFullName() + ".vcf"), (byte[])vCard.getBytes("UTF-8"), (String)"text/x-vcard; charset=UTF-8");
    }

    public void exportVCards(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        long[] userIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)resourceRequest, (String)"userIds"), (long)0L);
        ArrayList<User> users = new ArrayList<User>(userIds.length);
        for (long userId : userIds) {
            User user = this.userService.getUserById(userId);
            users.add(user);
        }
        String vCards = ContactsUtil.getVCards(users);
        PortletResponseUtil.sendFile((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (String)"vcards.vcf", (byte[])vCards.getBytes("UTF-8"), (String)"text/x-vcard; charset=UTF-8");
    }

    public void getContact(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long userId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"userId");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("success", (Object)Boolean.TRUE);
        JSONObject userJSONObject = this.getUserJSONObject((PortletResponse)resourceResponse, themeDisplay, userId);
        jsonObject.put("user", userJSONObject);
        this.writeJSON((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, jsonObject);
    }

    public void getContacts(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        JSONObject contactListJSONObject = this.getContactsJSONObject((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        this.writeJSON((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, contactListJSONObject);
    }

    public void getSelectedContacts(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] userIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)resourceRequest, (String)"userIds"), (long)0L);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (long userId : userIds) {
            try {
                JSONObject userJSONObject = JSONFactoryUtil.createJSONObject();
                userJSONObject.put("success", (Object)Boolean.TRUE);
                userJSONObject.put("user", this.getUserJSONObject((PortletResponse)resourceResponse, themeDisplay, userId));
                jsonArray.put(userJSONObject);
            }
            catch (NoSuchUserException nsue) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)nsue, (Throwable)nsue);
            }
        }
        jsonObject.put("contacts", jsonArray);
        this.writeJSON((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, jsonObject);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!themeDisplay.isSignedIn()) {
            return;
        }
        try {
            String actionName = ParamUtil.getString((PortletRequest)actionRequest, (String)"javax.portlet.action");
            boolean jsonFormat = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"jsonFormat");
            if (jsonFormat) {
                if (actionName.equals("addSocialRelation")) {
                    this.addSocialRelation(actionRequest, actionResponse);
                } else if (actionName.equals("deleteSocialRelation")) {
                    this.deleteSocialRelation(actionRequest, actionResponse);
                } else if (actionName.equals("requestSocialRelation")) {
                    this.requestSocialRelation(actionRequest, actionResponse);
                }
                JSONObject jsonObject = this.getContactsDisplayJSONObject(actionRequest, actionResponse);
                this.writeJSON((PortletRequest)actionRequest, actionResponse, jsonObject);
            } else if (actionName.equals("deleteEntry")) {
                this.deleteEntry(actionRequest, actionResponse);
            } else if (actionName.equals("updateEntry")) {
                this.updateEntry(actionRequest, actionResponse);
            } else if (actionName.equals("updateFieldGroup")) {
                this.updateFieldGroup(actionRequest, actionResponse);
            } else if (actionName.equals("updateSocialRequest")) {
                this.updateSocialRequest(actionRequest, actionResponse);
            } else {
                super.processAction(actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void requestSocialRelation(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] userIds = this.getUserIds(actionRequest);
        int type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type");
        for (long userId : userIds) {
            if (userId == themeDisplay.getUserId() || this.socialRelationLocalService.hasRelation(userId, themeDisplay.getUserId(), 12) || this.socialRelationLocalService.hasRelation(userId, themeDisplay.getUserId(), 9) || this.socialRequestLocalService.hasRequest(themeDisplay.getUserId(), User.class.getName(), themeDisplay.getUserId(), type, userId, 3)) continue;
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
            String portletId = PortletIdCodec.decodePortletName((String)this.portal.getPortletId((PortletRequest)actionRequest));
            if (portletId.equals("com_liferay_contacts_web_portlet_MembersPortlet") || portletId.equals("com_liferay_contacts_web_portlet_ProfilePortlet")) {
                portletId = "com_liferay_contacts_web_portlet_ContactsCenterPortlet";
            }
            extraDataJSONObject.put("portletId", portletId);
            SocialRequest socialRequest = this.socialRequestLocalService.addRequest(themeDisplay.getUserId(), 0L, User.class.getName(), themeDisplay.getUserId(), type, extraDataJSONObject.toString(), userId);
            this.sendNotificationEvent(socialRequest);
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException {
        try {
            String resourceID = resourceRequest.getResourceID();
            if (resourceID.equals("exportVCard")) {
                this.exportVCard(resourceRequest, resourceResponse);
            } else if (resourceID.equals("exportVCards")) {
                this.exportVCards(resourceRequest, resourceResponse);
            } else if (resourceID.equals("getContact")) {
                this.getContact(resourceRequest, resourceResponse);
            } else if (resourceID.equals("getContacts")) {
                this.getContacts(resourceRequest, resourceResponse);
            } else if (resourceID.equals("getSelectedContacts")) {
                this.getSelectedContacts(resourceRequest, resourceResponse);
            } else {
                super.serveResource(resourceRequest, resourceResponse);
            }
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void updateEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        String fullName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fullName");
        String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
        String comments = ParamUtil.getString((PortletRequest)actionRequest, (String)"comments");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        String message = null;
        try {
            Entry entry = null;
            if (entryId > 0L) {
                entry = this.entryLocalService.getEntry(entryId);
                if (entry.getUserId() == themeDisplay.getUserId()) {
                    entry = this.entryLocalService.updateEntry(entryId, fullName, emailAddress, comments);
                    message = "you-have-successfully-updated-the-contact";
                }
            } else {
                entry = this.entryLocalService.addEntry(themeDisplay.getUserId(), fullName, emailAddress, comments);
                message = "you-have-successfully-added-a-new-contact";
            }
            jsonObject.put("contact", this.getEntryJSONObject((PortletResponse)actionResponse, themeDisplay, entry, redirect));
            JSONObject contactsJSONObject = this.getContactsJSONObject((PortletRequest)actionRequest, (PortletResponse)actionResponse);
            jsonObject.put("contactList", contactsJSONObject);
            jsonObject.put("success", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            message = e instanceof ContactFullNameException ? "full-name-cannot-be-empty" : (e instanceof DuplicateEntryEmailAddressException ? "there-is-already-a-contact-with-this-email-address" : (e instanceof EntryEmailAddressException ? "please-enter-a-valid-email-address" : "an-error-occurred-while-processing-the-requested-resource"));
            jsonObject.put("success", (Object)Boolean.FALSE);
        }
        jsonObject.put("message", this.translate((PortletRequest)actionRequest, message));
        this.writeJSON((PortletRequest)actionRequest, actionResponse, jsonObject);
    }

    public void updateFieldGroup(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            String fieldGroup = ParamUtil.getString((PortletRequest)actionRequest, (String)"fieldGroup");
            if (fieldGroup.equals("additionalEmailAddresses")) {
                this.updateAdditionalEmailAddresses(actionRequest);
            } else if (fieldGroup.equals("addresses")) {
                this.updateAddresses(actionRequest);
            } else if (fieldGroup.equals("categorization")) {
                this.updateAsset(actionRequest);
            } else if (fieldGroup.equals("comments") || fieldGroup.equals("details") || fieldGroup.equals("instantMessenger") || fieldGroup.equals("sms") || fieldGroup.equals("socialNetwork")) {
                this.updateProfile(actionRequest);
            } else if (fieldGroup.equals("phoneNumbers")) {
                this.updatePhoneNumbers(actionRequest);
            } else if (fieldGroup.equals("websites")) {
                this.updateWebsites(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            jsonObject.put("redirect", redirect);
            jsonObject.put("success", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            String message = "your-request-failed-to-complete";
            if (e instanceof AddressCityException) {
                message = "please-enter-a-valid-city";
            } else if (e instanceof AddressStreetException) {
                message = "please-enter-a-valid-street";
            } else if (e instanceof AddressZipException) {
                message = "please-enter-a-valid-postal-code";
            } else if (e instanceof ContactFirstNameException) {
                message = "please-enter-a-valid-first-name";
            } else if (e instanceof ContactFullNameException) {
                message = "please-enter-a-valid-first-middle-and-last-name";
            } else if (e instanceof ContactLastNameException) {
                message = "please-enter-a-valid-last-name";
            } else if (e instanceof DuplicateUserEmailAddressException) {
                message = "the-email-address-you-requested-is-already-taken";
            } else if (e instanceof EmailAddressException) {
                message = "please-enter-a-valid-email-address";
            } else if (e instanceof NoSuchCountryException) {
                message = "please-select-a-country";
            } else if (e instanceof NoSuchListTypeException) {
                message = "please-select-a-type";
            } else if (e instanceof NoSuchRegionException) {
                message = "please-select-a-region";
            } else if (e instanceof PhoneNumberException) {
                message = "please-enter-a-valid-phone-number";
            } else if (e instanceof PhoneNumberExtensionException) {
                message = "please-enter-a-valid-phone-number-extension";
            } else if (e instanceof ReservedUserEmailAddressException) {
                message = "the-email-address-you-requested-is-reserveds";
            } else if (e instanceof ReservedUserScreenNameException) {
                message = "the-screen-name-you-requested-is-reserved";
            } else if (e instanceof UserEmailAddressException) {
                message = "please-enter-a-valid-email-address";
            } else if (e instanceof UserScreenNameException) {
                message = "please-enter-a-valid-screen-name";
            } else if (e instanceof UserSmsException) {
                message = "please-enter-a-sms-id-that-is-a-valid-email-address";
            } else if (e instanceof WebsiteURLException) {
                message = "please-enter-a-valid-url";
            }
            jsonObject.put("message", this.translate((PortletRequest)actionRequest, message));
            jsonObject.put("success", (Object)Boolean.FALSE);
        }
        this.writeJSON((PortletRequest)actionRequest, actionResponse, jsonObject);
    }

    public void updateSocialRequest(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long socialRequestId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"socialRequestId");
        int status = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"status");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            SocialRequest socialRequest = this.socialRequestLocalService.getSocialRequest(socialRequestId);
            if (this.socialRelationLocalService.hasRelation(socialRequest.getReceiverUserId(), socialRequest.getUserId(), 9)) {
                status = 2;
            }
            this.socialRequestLocalService.updateRequest(socialRequestId, status, themeDisplay);
            if (status == 1) {
                this.socialRelationLocalService.addRelation(socialRequest.getUserId(), socialRequest.getReceiverUserId(), socialRequest.getType());
            }
            jsonObject.put("success", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            jsonObject.put("success", (Object)Boolean.FALSE);
        }
        this.writeJSON((PortletRequest)actionRequest, actionResponse, jsonObject);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._userFileUploadsConfiguration = (UserFileUploadsConfiguration)ConfigurableUtil.createConfigurable(UserFileUploadsConfiguration.class, properties);
    }

    protected void deleteEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Entry entry;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        if (entryId > 0L && (entry = this.entryLocalService.getEntry(entryId)).getUserId() == themeDisplay.getUserId()) {
            this.entryLocalService.deleteEntry(entryId);
        }
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        renderRequest.setAttribute(UserFileUploadsConfiguration.class.getName(), (Object)this._userFileUploadsConfiguration);
        super.doDispatch(renderRequest, renderResponse);
    }

    protected JSONObject getContactsDisplayJSONObject(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] userIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"userIds"), (long)0L);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        JSONObject contactListJSONObject = this.getContactsJSONObject((PortletRequest)actionRequest, (PortletResponse)actionResponse);
        jsonObject.put("contactList", contactListJSONObject);
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (long userId : userIds) {
            JSONObject userJSONObject = JSONFactoryUtil.createJSONObject();
            userJSONObject.put("success", (Object)Boolean.TRUE);
            userJSONObject.put("user", this.getUserJSONObject((PortletResponse)actionResponse, themeDisplay, userId));
            jsonArray.put(userJSONObject);
        }
        jsonObject.put("contacts", jsonArray);
        String message = this.getRelationMessage(actionRequest);
        jsonObject.put("message", this.translate((PortletRequest)actionRequest, message));
        return jsonObject;
    }

    protected JSONObject getContactsJSONObject(PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String redirect = ParamUtil.getString((PortletRequest)portletRequest, (String)"redirect");
        String filterBy = ParamUtil.getString((PortletRequest)portletRequest, (String)"filterBy");
        String keywords = ParamUtil.getString((PortletRequest)portletRequest, (String)"keywords");
        int start = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"start");
        int end = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"end");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        JSONObject optionsJSONObject = JSONFactoryUtil.createJSONObject();
        optionsJSONObject.put("end", end);
        optionsJSONObject.put("filterBy", filterBy);
        optionsJSONObject.put("keywords", keywords);
        optionsJSONObject.put("start", start);
        jsonObject.put("options", optionsJSONObject);
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        String portletId = portletDisplay.getId();
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        if (filterBy.equals("default") && !portletId.equals("com_liferay_contacts_web_portlet_MembersPortlet")) {
            List contacts = this.entryLocalService.searchUsersAndContacts(themeDisplay.getCompanyId(), themeDisplay.getUserId(), keywords, start, end);
            int contactsCount = this.entryLocalService.searchUsersAndContactsCount(themeDisplay.getCompanyId(), themeDisplay.getUserId(), keywords);
            jsonObject.put("count", contactsCount);
            for (BaseModel contact : contacts) {
                JSONObject contactJSONObject = null;
                contactJSONObject = contact instanceof User ? this.getUserJSONObject(portletResponse, themeDisplay, (User)contact) : this.getEntryJSONObject(portletResponse, themeDisplay, (Entry)contact, redirect);
                jsonArray.put(contactJSONObject);
            }
        } else if (filterBy.equals("followers") && !portletId.equals("com_liferay_contacts_web_portlet_MembersPortlet")) {
            List socialRelations = this.socialRelationLocalService.getInverseRelations(themeDisplay.getUserId(), 8, start, end);
            for (SocialRelation socialRelation : socialRelations) {
                jsonArray.put(this.getUserJSONObject(portletResponse, themeDisplay, socialRelation.getUserId1()));
            }
        } else if (filterBy.equals("type_101") && !portletId.equals("com_liferay_contacts_web_portlet_MembersPortlet")) {
            List entries = this.entryLocalService.search(themeDisplay.getUserId(), keywords, start, end);
            int entriesCount = this.entryLocalService.searchCount(themeDisplay.getUserId(), keywords);
            jsonObject.put("count", entriesCount);
            for (Entry entry : entries) {
                JSONObject contactJSONObject = this.getEntryJSONObject(portletResponse, themeDisplay, entry, redirect);
                jsonArray.put(contactJSONObject);
            }
        } else {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("inherit", Boolean.TRUE);
            Group group = themeDisplay.getScopeGroup();
            Layout layout = themeDisplay.getLayout();
            if (group.isUser() && layout.isPublicLayout()) {
                params.put("socialRelationType", new Long[]{group.getClassPK(), 12L});
            } else if (filterBy.startsWith("type_")) {
                params.put("socialRelationType", new Long[]{themeDisplay.getUserId(), ContactsUtil.getSocialRelationType((String)filterBy)});
            }
            if (portletId.equals("com_liferay_contacts_web_portlet_MembersPortlet")) {
                params.put("usersGroups", group.getGroupId());
            } else if (filterBy.startsWith("group_")) {
                params.put("usersGroups", ContactsUtil.getGroupId((String)filterBy));
            }
            ArrayList usersList = null;
            if (filterBy.equals("admins")) {
                Role siteAdministratorRole = this.roleLocalService.getRole(group.getCompanyId(), "Site Administrator");
                params.put("userGroupRole", new Long[]{group.getGroupId(), siteAdministratorRole.getRoleId()});
                HashSet users = new HashSet();
                users.addAll(this.userLocalService.search(themeDisplay.getCompanyId(), keywords, 0, params, -1, -1, (OrderByComparator)null));
                Role siteOwnerRole = this.roleLocalService.getRole(group.getCompanyId(), "Site Owner");
                params.put("userGroupRole", new Long[]{group.getGroupId(), siteOwnerRole.getRoleId()});
                users.addAll(this.userLocalService.search(themeDisplay.getCompanyId(), keywords, 0, params, -1, -1, (OrderByComparator)null));
                usersList = new ArrayList(users);
                ListUtil.sort(usersList, (Comparator)new UserLastNameComparator(true));
            } else {
                int usersCount = this.userLocalService.searchCount(themeDisplay.getCompanyId(), keywords, 0, params);
                jsonObject.put("count", usersCount);
                usersList = this.userLocalService.search(themeDisplay.getCompanyId(), keywords, 0, params, start, end, (OrderByComparator)new UserLastNameComparator(true));
            }
            for (User user : usersList) {
                JSONObject userJSONObject = this.getUserJSONObject(portletResponse, themeDisplay, user);
                jsonArray.put(userJSONObject);
            }
        }
        jsonObject.put("users", jsonArray);
        return jsonObject;
    }

    protected JSONObject getEntryJSONObject(PortletResponse portletResponse, ThemeDisplay themeDisplay, Entry entry, String redirect) throws Exception {
        entry = entry.toEscapedModel();
        JSONObject jsonObject = ContactsUtil.getEntryJSONObject((Entry)entry);
        jsonObject.put("portraitURL", themeDisplay.getPathImage() + "/user_male_portrait?img_id=0");
        jsonObject.put("redirect", redirect);
        LiferayPortletResponse liferayPortletResponse = this.portal.getLiferayPortletResponse(portletResponse);
        PortletURL viewSummaryURL = liferayPortletResponse.createRenderURL();
        viewSummaryURL.setParameter("mvcPath", "/contacts_center/view_resources.jsp");
        viewSummaryURL.setParameter("redirect", redirect);
        viewSummaryURL.setParameter("entryId", String.valueOf(entry.getEntryId()));
        viewSummaryURL.setParameter("portalUser", Boolean.FALSE.toString());
        viewSummaryURL.setWindowState(LiferayWindowState.EXCLUSIVE);
        jsonObject.put("viewSummaryURL", viewSummaryURL.toString());
        return jsonObject;
    }

    protected String getRelationMessage(ActionRequest actionRequest) {
        int type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type");
        String actionName = ParamUtil.getString((PortletRequest)actionRequest, (String)"javax.portlet.action");
        String message = "your-request-completed-successfully";
        if (actionName.equals("addSocialRelation")) {
            if (type == 12) {
                message = "you-are-now-connected-to-this-user";
            } else if (type == 8) {
                message = "you-are-now-following-this-user";
            } else if (type == 9) {
                message = "you-have-blocked-this-user";
            }
        } else if (actionName.equals("deleteSocialRelation")) {
            if (type == 12) {
                message = "you-are-not-connected-to-this-user-anymore";
            } else if (type == 8) {
                message = "you-are-not-following-this-user-anymore";
            } else if (type == 9) {
                message = "you-have-unblocked-this-user";
            }
        } else if (actionName.equals("requestSocialRelation") && type == 12) {
            message = "this-user-has-received-a-connection-request-from-you";
        }
        return message;
    }

    protected long[] getUserIds(ActionRequest actionRequest) {
        long userId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"userId", (long)0L);
        long[] userIds = userId > 0L ? new long[]{userId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"userIds"), (long)0L);
        return userIds;
    }

    protected JSONObject getUserJSONObject(PortletResponse portletResponse, ThemeDisplay themeDisplay, long userId) throws Exception {
        User user = this.userLocalService.getUser(userId);
        return this.getUserJSONObject(portletResponse, themeDisplay, user);
    }

    protected JSONObject getUserJSONObject(PortletResponse portletResponse, ThemeDisplay themeDisplay, User user) throws Exception {
        user = user.toEscapedModel();
        JSONObject jsonObject = ContactsUtil.getUserJSONObject((long)themeDisplay.getUserId(), (User)user);
        jsonObject.put("portraitURL", user.getPortraitURL(themeDisplay));
        LiferayPortletResponse liferayPortletResponse = this.portal.getLiferayPortletResponse(portletResponse);
        PortletURL viewSummaryURL = liferayPortletResponse.createRenderURL();
        viewSummaryURL.setParameter("mvcPath", "/contacts_center/view_resources.jsp");
        viewSummaryURL.setParameter("userId", String.valueOf(user.getUserId()));
        viewSummaryURL.setParameter("portalUser", Boolean.TRUE.toString());
        viewSummaryURL.setWindowState(LiferayWindowState.EXCLUSIVE);
        jsonObject.put("viewSummaryURL", viewSummaryURL.toString());
        return jsonObject;
    }

    protected void sendNotificationEvent(SocialRequest socialRequest) throws Exception {
        if (UserNotificationManagerUtil.isDeliver((long)socialRequest.getReceiverUserId(), (String)"com_liferay_contacts_web_portlet_ContactsCenterPortlet", (long)0L, (int)1001, (int)10002)) {
            JSONObject notificationEventJSONObject = JSONFactoryUtil.createJSONObject();
            notificationEventJSONObject.put("classPK", socialRequest.getRequestId());
            notificationEventJSONObject.put("userId", socialRequest.getUserId());
            this.userNotificationEventLocalService.sendUserNotificationEvents(socialRequest.getReceiverUserId(), "com_liferay_contacts_web_portlet_ContactsCenterPortlet", 10002, true, notificationEventJSONObject);
        }
    }

    protected void updateAdditionalEmailAddresses(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        List emailAddresses = UsersAdminUtil.getEmailAddresses((ActionRequest)actionRequest);
        UsersAdminUtil.updateEmailAddresses((String)Contact.class.getName(), (long)user.getContactId(), (List)emailAddresses);
    }

    protected void updateAddresses(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        List addresses = UsersAdminUtil.getAddresses((ActionRequest)actionRequest);
        UsersAdminUtil.updateAddresses((String)Contact.class.getName(), (long)user.getContactId(), (List)addresses);
    }

    protected void updateAsset(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)User.class.getName(), (PortletRequest)actionRequest);
        this.userLocalService.updateAsset(user.getUserId(), user, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
    }

    protected void updatePhoneNumbers(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        List phones = UsersAdminUtil.getPhones((ActionRequest)actionRequest);
        UsersAdminUtil.updatePhones((String)Contact.class.getName(), (long)user.getContactId(), (List)phones);
    }

    protected void updateProfile(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        boolean deleteLogo = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"deleteLogo");
        byte[] portraitBytes = null;
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        if (!deleteLogo && fileEntryId > 0L) {
            FileEntry fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
            try (InputStream inputStream = fileEntry.getContentStream();){
                portraitBytes = FileUtil.getBytes((InputStream)inputStream);
            }
        }
        String comments = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"comments");
        String emailAddress = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"emailAddress");
        String firstName = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"firstName");
        String jobTitle = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"jobTitle");
        String lastName = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"lastName");
        String middleName = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"middleName");
        String screenName = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"screenName");
        Contact contact = user.getContact();
        String facebookSn = BeanParamUtil.getString((Object)contact, (PortletRequest)actionRequest, (String)"facebookSn");
        String jabberSn = BeanParamUtil.getString((Object)contact, (PortletRequest)actionRequest, (String)"jabberSn");
        String skypeSn = BeanParamUtil.getString((Object)contact, (PortletRequest)actionRequest, (String)"skypeSn");
        String smsSn = BeanParamUtil.getString((Object)contact, (PortletRequest)actionRequest, (String)"smsSn");
        String twitterSn = BeanParamUtil.getString((Object)contact, (PortletRequest)actionRequest, (String)"twitterSn");
        Calendar cal = CalendarFactoryUtil.getCalendar();
        cal.setTime(user.getBirthday());
        int birthdayDay = cal.get(5);
        int birthdayMonth = cal.get(2);
        int birthdayYear = cal.get(1);
        List announcementsDeliveries = this.announcementsDeliveryLocalService.getUserDeliveries(user.getUserId());
        this.userService.updateUser(user.getUserId(), user.getPasswordUnencrypted(), user.getPasswordUnencrypted(), user.getPasswordUnencrypted(), user.isPasswordReset(), user.getReminderQueryQuestion(), user.getReminderQueryAnswer(), screenName, emailAddress, user.getFacebookId(), user.getOpenId(), !deleteLogo, portraitBytes, user.getLanguageId(), user.getTimeZoneId(), user.getGreeting(), comments, firstName, middleName, lastName, contact.getPrefixId(), contact.getSuffixId(), user.isMale(), birthdayMonth, birthdayDay, birthdayYear, smsSn, facebookSn, jabberSn, skypeSn, twitterSn, jobTitle, user.getGroupIds(), user.getOrganizationIds(), user.getRoleIds(), null, user.getUserGroupIds(), user.getAddresses(), null, user.getPhones(), user.getWebsites(), announcementsDeliveries, new ServiceContext());
    }

    protected void updateWebsites(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        List websites = UsersAdminUtil.getWebsites((ActionRequest)actionRequest);
        UsersAdminUtil.updateWebsites((String)Contact.class.getName(), (long)user.getContactId(), (List)websites);
    }
}

