/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.contacts.web.internal.notifications;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.notifications.BaseUserNotificationHandler;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.language.LanguageResources;
import com.liferay.social.kernel.model.SocialRequest;
import com.liferay.social.kernel.service.SocialRequestLocalService;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.WindowState;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_contacts_web_portlet_ContactsCenterPortlet"}, service={UserNotificationHandler.class})
public class ContactsCenterUserNotificationHandler
extends BaseUserNotificationHandler {
    private static final String _BODY = "<div class=\"title\">[$TITLE$]</div><div class=\"body\">[$BODY$]</div>";
    private ResourceBundleLoader _resourceBundleLoader;
    @Reference
    private SocialRequestLocalService _socialRequestLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public ContactsCenterUserNotificationHandler() {
        this.setActionable(true);
        this.setPortletId("com_liferay_contacts_web_portlet_ContactsCenterPortlet");
    }

    protected String getBody(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)userNotificationEvent.getPayload());
        long socialRequestId = jsonObject.getLong("classPK");
        SocialRequest socialRequest = this._socialRequestLocalService.fetchSocialRequest(socialRequestId);
        if (socialRequest == null) {
            this._userNotificationEventLocalService.deleteUserNotificationEvent(userNotificationEvent.getUserNotificationEventId());
            return null;
        }
        String creatorUserName = this.getUserNameLink(socialRequest.getUserId(), serviceContext);
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(serviceContext.getLocale());
        String title = "";
        title = socialRequest.getType() == 12 ? ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (Locale)serviceContext.getLocale(), (String)"request-social-networking-summary-add-connection", (Object[])new Object[]{creatorUserName}) : ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (Locale)serviceContext.getLocale(), (String)"x-sends-you-a-social-relationship-request", (Object[])new Object[]{creatorUserName});
        if (socialRequest.getStatus() != 3 || socialRequest.getModifiedDate() > userNotificationEvent.getTimestamp()) {
            return StringUtil.replace((String)_BODY, (String[])new String[]{"[$BODY$]", "[$TITLE$]"}, (String[])new String[]{"", title});
        }
        LiferayPortletResponse liferayPortletResponse = serviceContext.getLiferayPortletResponse();
        LiferayPortletURL confirmURL = liferayPortletResponse.createActionURL("com_liferay_contacts_web_portlet_ContactsCenterPortlet");
        confirmURL.setParameter("javax.portlet.action", "updateSocialRequest");
        confirmURL.setParameter("redirect", serviceContext.getLayoutFullURL());
        confirmURL.setParameter("socialRequestId", String.valueOf(socialRequestId));
        confirmURL.setParameter("status", String.valueOf(1));
        confirmURL.setParameter("userNotificationEventId", String.valueOf(userNotificationEvent.getUserNotificationEventId()));
        confirmURL.setWindowState(WindowState.NORMAL);
        LiferayPortletURL ignoreURL = liferayPortletResponse.createActionURL("com_liferay_contacts_web_portlet_ContactsCenterPortlet");
        ignoreURL.setParameter("javax.portlet.action", "updateSocialRequest");
        ignoreURL.setParameter("redirect", serviceContext.getLayoutFullURL());
        ignoreURL.setParameter("socialRequestId", String.valueOf(socialRequestId));
        ignoreURL.setParameter("status", String.valueOf(2));
        ignoreURL.setParameter("userNotificationEventId", String.valueOf(userNotificationEvent.getUserNotificationEventId()));
        ignoreURL.setWindowState(WindowState.NORMAL);
        return StringUtil.replace((String)this.getBodyTemplate(), (String[])new String[]{"[$CONFIRM$]", "[$CONFIRM_URL$]", "[$IGNORE$]", "[$IGNORE_URL$]", "[$TITLE$]"}, (String[])new String[]{serviceContext.translate("confirm", new Object[0]), confirmURL.toString(), serviceContext.translate("ignore", new Object[0]), ignoreURL.toString(), title});
    }

    protected String getLink(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        return "";
    }

    protected String getUserNameLink(long userId, ServiceContext serviceContext) {
        try {
            if (userId <= 0L) {
                return "";
            }
            User user = this._userLocalService.getUserById(userId);
            String userName = user.getFullName();
            String userDisplayURL = user.getDisplayURL(serviceContext.getThemeDisplay());
            return StringBundler.concat((String[])new String[]{"<a href=\"", userDisplayURL, "\">", HtmlUtil.escape((String)userName), "</a>"});
        }
        catch (Exception e) {
            return "";
        }
    }

    @Reference(target="(bundle.symbolic.name=com.liferay.contacts.web)", unbind="-")
    protected void setResourceBundleLoader(ResourceBundleLoader resourceBundleLoader) {
        this._resourceBundleLoader = new AggregateResourceBundleLoader(new ResourceBundleLoader[]{resourceBundleLoader, LanguageResources.RESOURCE_BUNDLE_LOADER});
    }
}

