/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.contacts.web.internal.asset;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseAssetRendererFactory;
import com.liferay.contacts.web.internal.asset.UserAssetRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_contacts_web_portlet_ContactsCenterPortlet"}, service={AssetRendererFactory.class})
public class UserAssetRendererFactory
extends BaseAssetRendererFactory<User> {
    public static final String TYPE = "user";
    private GroupLocalService _groupLocalService;
    private ServletContext _servletContext;
    private UserLocalService _userLocalService;

    public UserAssetRendererFactory() {
        this.setSearchable(true);
        this.setSelectable(false);
    }

    public AssetRenderer<User> getAssetRenderer(long classPK, int type) throws PortalException {
        User user = this._userLocalService.getUserById(classPK);
        UserAssetRenderer userAssetRenderer = new UserAssetRenderer(user);
        userAssetRenderer.setAssetRendererType(type);
        userAssetRenderer.setServletContext(this._servletContext);
        return userAssetRenderer;
    }

    public AssetRenderer<User> getAssetRenderer(long groupId, String urlTitle) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        User user = this._userLocalService.getUserByScreenName(group.getCompanyId(), urlTitle);
        return new UserAssetRenderer(user);
    }

    public String getClassName() {
        return User.class.getName();
    }

    public String getIconCssClass() {
        return TYPE;
    }

    public String getPortletId() {
        return "com_liferay_contacts_web_portlet_ContactsCenterPortlet";
    }

    public String getType() {
        return TYPE;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)classPK, (String)actionId);
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.contacts.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

