/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.contacts.web.internal.asset;

import com.liferay.asset.kernel.model.BaseJSPAssetRenderer;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UserAssetRenderer
extends BaseJSPAssetRenderer<User> {
    private final User _user;

    public UserAssetRenderer(User user) {
        this._user = user;
    }

    public User getAssetObject() {
        return this._user;
    }

    public String getClassName() {
        return User.class.getName();
    }

    public long getClassPK() {
        return this._user.getPrimaryKey();
    }

    public String getDiscussionPath() {
        return null;
    }

    public long getGroupId() {
        return 0L;
    }

    public String getJspPath(HttpServletRequest request, String template) {
        if (template.equals("abstract") || template.equals("full_content")) {
            return "/asset/abstract.jsp";
        }
        return null;
    }

    public int getStatus() {
        return this._user.getStatus();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        return this._user.getComments();
    }

    public String getTitle(Locale locale) {
        return this._user.getFullName();
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        String portletId = PortletProviderUtil.getPortletId((String)User.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(this.getControlPanelPlid(liferayPortletRequest), portletId, "RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/users_admin/edit_user");
        portletURL.setParameter("p_u_i_d", String.valueOf(this._user.getUserId()));
        return portletURL;
    }

    public String getUrlTitle() {
        return this._user.getScreenName();
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            return this._user.getDisplayURL(themeDisplay);
        }
        catch (Exception exception) {
            return noSuchEntryRedirect;
        }
    }

    public long getUserId() {
        return this._user.getUserId();
    }

    public String getUserName() {
        return this._user.getFullName();
    }

    public String getUuid() {
        return this._user.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) {
        return UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)this._user.getUserId(), (String)"UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) {
        return UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)this._user.getUserId(), (String)"VIEW");
    }

    public boolean include(HttpServletRequest request, HttpServletResponse response, String template) throws Exception {
        request.setAttribute("CONTACTS_USER", (Object)this._user);
        return super.include(request, response, template);
    }

    public boolean isPrintable() {
        return false;
    }
}

