/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.connected.app.web.internal;

import com.liferay.connected.app.ConnectedApp;
import com.liferay.connected.app.ConnectedAppManager;
import com.liferay.connected.app.ConnectedAppProvider;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={ConnectedAppManager.class})
public class ConnectedAppManagerImpl
implements ConnectedAppManager {
    private static final Log _log = LogFactoryUtil.getLog(ConnectedAppManagerImpl.class);
    private ServiceTrackerList<ConnectedAppProvider, ConnectedAppProvider> _serviceTrackerList;

    public ConnectedApp getConnectedApp(User user, String key) {
        for (ConnectedApp connectedApp : this.getConnectedApps(user)) {
            if (!key.equals(connectedApp.getKey())) continue;
            return connectedApp;
        }
        return null;
    }

    public List<ConnectedApp> getConnectedApps(User user) {
        ArrayList<ConnectedApp> connectedApps = new ArrayList<ConnectedApp>();
        for (ConnectedAppProvider connectedAppProvider : this._serviceTrackerList) {
            try {
                ConnectedApp connectedApp = connectedAppProvider.getConnectedApp(user);
                if (connectedApp == null) continue;
                connectedApps.add(connectedApp);
            }
            catch (PortalException pe) {
                _log.error((Object)pe, (Throwable)pe);
            }
        }
        return connectedApps;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, ConnectedAppProvider.class);
    }
}

