/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.configuration.admin.web.internal.util;

import com.liferay.configuration.admin.web.internal.model.ConfigurationModel;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.FieldConstants;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.configuration.metatype.definitions.ExtendedAttributeDefinition;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class DDMFormValuesToPropertiesConverter {
    private final ConfigurationModel _configurationModel;
    private final Map<String, DDMFormField> _ddmFormFieldsMap;
    private final Map<String, List<DDMFormFieldValue>> _ddmFormFieldValuesMap;
    private final JSONFactory _jsonFactory;
    private final Locale _locale;

    public DDMFormValuesToPropertiesConverter(ConfigurationModel configurationModel, DDMFormValues ddmFormValues, JSONFactory jsonFactory, Locale locale) {
        DDMForm ddmForm = ddmFormValues.getDDMForm();
        this._configurationModel = configurationModel;
        this._ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(false);
        this._ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        this._jsonFactory = jsonFactory;
        this._locale = locale;
    }

    public Dictionary<String, Object> getProperties() {
        ExtendedAttributeDefinition[] attributeDefinitions;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        for (ExtendedAttributeDefinition attributeDefinition : attributeDefinitions = this._configurationModel.getAttributeDefinitions(-1)) {
            Vector<Serializable> value = null;
            List<DDMFormFieldValue> ddmFormFieldValues = this._ddmFormFieldValuesMap.get(attributeDefinition.getID());
            if (attributeDefinition.getCardinality() == 0) {
                value = this.toSimpleValue(ddmFormFieldValues.get(0));
            } else if (attributeDefinition.getCardinality() > 0) {
                value = this.toArrayValue(ddmFormFieldValues);
            } else if (attributeDefinition.getCardinality() < 0) {
                value = this.toVectorValue(ddmFormFieldValues);
            }
            ((Dictionary)properties).put(attributeDefinition.getID(), value);
        }
        return properties;
    }

    protected String getDataTypeDefaultValue(String dataType) {
        if (dataType.equals("boolean")) {
            return "false";
        }
        if (dataType.equals("double") || dataType.equals("float")) {
            return "0.0";
        }
        if (dataType.equals("integer") || dataType.equals("long") || dataType.equals("short")) {
            return "0";
        }
        return "";
    }

    protected String getDDMFormFieldDataType(String fieldName) {
        DDMFormField ddmFormField = this._ddmFormFieldsMap.get(fieldName);
        return ddmFormField.getDataType();
    }

    protected String getDDMFormFieldType(String fieldName) {
        DDMFormField ddmFormField = this._ddmFormFieldsMap.get(fieldName);
        return ddmFormField.getType();
    }

    protected String getDDMFormFieldValueString(DDMFormFieldValue ddmFormFieldValue) {
        Value value = ddmFormFieldValue.getValue();
        String valueString = value.getString(this._locale);
        String type = this.getDDMFormFieldType(ddmFormFieldValue.getName());
        if (type.equals("select")) {
            try {
                JSONArray jsonArray = this._jsonFactory.createJSONArray(valueString);
                if (jsonArray.length() == 1) {
                    valueString = jsonArray.getString(0);
                }
            }
            catch (JSONException jsone) {
                ReflectionUtil.throwException((Throwable)jsone);
            }
        }
        if (valueString.equals("")) {
            String dataType = this.getDDMFormFieldDataType(ddmFormFieldValue.getName());
            valueString = this.getDataTypeDefaultValue(dataType);
        }
        return valueString;
    }

    protected Serializable toArrayValue(List<DDMFormFieldValue> ddmFormFieldValues) {
        DDMFormFieldValue ddmFormFieldValue = ddmFormFieldValues.get(0);
        String dataType = this.getDDMFormFieldDataType(ddmFormFieldValue.getName());
        Vector<Serializable> values = this.toVectorValue(ddmFormFieldValues);
        return FieldConstants.getSerializable((String)dataType, values);
    }

    protected Serializable toSimpleValue(DDMFormFieldValue ddmFormFieldValue) {
        String dataType = this.getDDMFormFieldDataType(ddmFormFieldValue.getName());
        String valueString = this.getDDMFormFieldValueString(ddmFormFieldValue);
        return FieldConstants.getSerializable((String)dataType, (String)valueString);
    }

    protected Vector<Serializable> toVectorValue(List<DDMFormFieldValue> ddmFormFieldValues) {
        Vector<Serializable> values = new Vector<Serializable>();
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            values.add(this.toSimpleValue(ddmFormFieldValue));
        }
        return values;
    }
}

