/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.configuration.admin.web.internal.util;

import com.liferay.configuration.admin.web.internal.model.ConfigurationModel;
import com.liferay.configuration.admin.web.internal.util.ConfigurationDDMFormDeclarationUtil;
import com.liferay.configuration.admin.web.internal.util.ConfigurationModelToDDMFormConverter;
import com.liferay.configuration.admin.web.internal.util.ConfigurationModelToDDMFormValuesConverter;
import com.liferay.configuration.admin.web.internal.util.ResourceBundleLoaderProvider;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingException;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormLayoutFactory;
import com.liferay.dynamic.data.mapping.util.DDMUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

public class DDMFormRendererHelper {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormRendererHelper.class);
    private final ConfigurationModel _configurationModel;
    private final DDMFormRenderer _ddmFormRenderer;
    private final PortletRequest _portletRequest;
    private final PortletResponse _portletResponse;
    private final ResourceBundleLoaderProvider _resourceBundleLoaderProvider;

    public DDMFormRendererHelper(PortletRequest portletRequest, PortletResponse portletResponse, ConfigurationModel configurationModel, DDMFormRenderer ddmFormRenderer, ResourceBundleLoaderProvider resourceBundleLoaderProvider) {
        this._portletRequest = portletRequest;
        this._portletResponse = portletResponse;
        this._configurationModel = configurationModel;
        this._ddmFormRenderer = ddmFormRenderer;
        this._resourceBundleLoaderProvider = resourceBundleLoaderProvider;
    }

    public String getDDMFormHTML() throws PortletException {
        try {
            DDMForm ddmForm = this.getDDMForm();
            return this._ddmFormRenderer.render(ddmForm, this.getDDMFormLayout(ddmForm), this.createDDMFormRenderingContext(ddmForm));
        }
        catch (DDMFormRenderingException ddmfre) {
            _log.error((Object)"Unable to render DDM Form ", (Throwable)ddmfre);
            throw new PortletException((Throwable)ddmfre);
        }
    }

    protected DDMFormRenderingContext createDDMFormRenderingContext(DDMForm ddmForm) {
        DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
        ddmFormRenderingContext.setDDMFormValues(this.getDDMFormValues(ddmForm));
        ddmFormRenderingContext.setHttpServletRequest(PortalUtil.getHttpServletRequest((PortletRequest)this._portletRequest));
        ddmFormRenderingContext.setHttpServletResponse(PortalUtil.getHttpServletResponse((PortletResponse)this._portletResponse));
        ddmFormRenderingContext.setLocale(this.getLocale());
        ddmFormRenderingContext.setPortletNamespace(this._portletResponse.getNamespace());
        return ddmFormRenderingContext;
    }

    protected DDMForm getDDMForm() {
        String bundleSymbolicName = this._configurationModel.getBundleSymbolicName();
        ResourceBundleLoader resourceBundleLoader = this._resourceBundleLoaderProvider.getResourceBundleLoader(bundleSymbolicName);
        Locale locale = this.getLocale();
        ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
        ConfigurationModelToDDMFormConverter configurationModelToDDMFormConverter = new ConfigurationModelToDDMFormConverter(this._configurationModel, locale, resourceBundle);
        return configurationModelToDDMFormConverter.getDDMForm();
    }

    protected DDMFormLayout getDDMFormLayout(DDMForm ddmForm) {
        Class<?> formClass = ConfigurationDDMFormDeclarationUtil.getConfigurationDDMFormClass(this._configurationModel);
        if (formClass != null) {
            try {
                return DDMFormLayoutFactory.create(formClass);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return DDMUtil.getDefaultDDMFormLayout((DDMForm)ddmForm);
    }

    protected DDMFormValues getDDMFormValues(DDMForm ddmForm) {
        String bundleSymbolicName = this._configurationModel.getBundleSymbolicName();
        ResourceBundleLoader resourceBundleLoader = this._resourceBundleLoaderProvider.getResourceBundleLoader(bundleSymbolicName);
        Locale locale = this.getLocale();
        ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
        ConfigurationModelToDDMFormValuesConverter configurationModelToDDMFormValuesConverter = new ConfigurationModelToDDMFormValuesConverter(this._configurationModel, ddmForm, locale, resourceBundle);
        return configurationModelToDDMFormValuesConverter.getDDMFormValues();
    }

    protected Locale getLocale() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return themeDisplay.getLocale();
    }
}

