/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.configuration.admin.web.internal.util;

import com.liferay.configuration.admin.web.internal.model.ConfigurationModel;
import com.liferay.configuration.admin.web.internal.util.ConfigurationModelRetriever;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.configuration.metatype.definitions.ExtendedMetaTypeInformation;
import com.liferay.portal.configuration.metatype.definitions.ExtendedMetaTypeService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ConfigurationModelRetriever.class})
public class ConfigurationModelRetrieverImpl
implements ConfigurationModelRetriever {
    private BundleContext _bundleContext;
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ExtendedMetaTypeService _extendedMetaTypeService;

    @Override
    public Map<String, Set<ConfigurationModel>> categorizeConfigurationModels(Map<String, ConfigurationModel> configurationModels) {
        HashMap<String, Set<ConfigurationModel>> categorizedConfigurationModels = new HashMap<String, Set<ConfigurationModel>>();
        for (ConfigurationModel configurationModel : configurationModels.values()) {
            String configurationCategory = configurationModel.getCategory();
            TreeSet<ConfigurationModel> curConfigurationModels = (TreeSet<ConfigurationModel>)categorizedConfigurationModels.get(configurationCategory);
            if (curConfigurationModels == null) {
                curConfigurationModels = new TreeSet<ConfigurationModel>(this.getConfigurationModelComparator());
                categorizedConfigurationModels.put(configurationCategory, curConfigurationModels);
            }
            curConfigurationModels.add(configurationModel);
        }
        return categorizedConfigurationModels;
    }

    @Override
    public Configuration getConfiguration(String pid) {
        try {
            String pidFilter = this.getPidFilterString(pid, false);
            Configuration[] configurations = this._configurationAdmin.listConfigurations(pidFilter);
            if (configurations != null) {
                return configurations[0];
            }
        }
        catch (IOException | InvalidSyntaxException e) {
            ReflectionUtil.throwException((Throwable)e);
        }
        return null;
    }

    @Override
    public Map<String, ConfigurationModel> getConfigurationModels() {
        return this.getConfigurationModels((String)null);
    }

    @Override
    public Map<String, ConfigurationModel> getConfigurationModels(Bundle bundle) {
        HashMap<String, ConfigurationModel> configurationModels = new HashMap<String, ConfigurationModel>();
        this.collectConfigurationModels(bundle, configurationModels, true, null);
        this.collectConfigurationModels(bundle, configurationModels, false, null);
        return configurationModels;
    }

    @Override
    public Map<String, ConfigurationModel> getConfigurationModels(String locale) {
        Bundle[] bundles;
        HashMap<String, ConfigurationModel> configurationModels = new HashMap<String, ConfigurationModel>();
        for (Bundle bundle : bundles = this._bundleContext.getBundles()) {
            if (bundle.getState() != 32) continue;
            this.collectConfigurationModels(bundle, configurationModels, true, locale);
            this.collectConfigurationModels(bundle, configurationModels, false, locale);
        }
        return configurationModels;
    }

    @Override
    public Set<ConfigurationModel> getConfigurationModels(String configurationCategory, String languageId) {
        Map<String, ConfigurationModel> configurationModelsMap = this.getConfigurationModels(languageId);
        Map<String, Set<ConfigurationModel>> categorizedConfigurationModels = this.categorizeConfigurationModels(configurationModelsMap);
        Set<ConfigurationModel> configurationModels = categorizedConfigurationModels.get(configurationCategory);
        if (configurationModels == null) {
            configurationModels = Collections.emptySet();
        }
        return configurationModels;
    }

    @Override
    public List<ConfigurationModel> getFactoryInstances(ConfigurationModel factoryConfigurationModel) throws IOException {
        Configuration[] configurations = this.getFactoryConfigurations(factoryConfigurationModel.getFactoryPid());
        if (configurations == null) {
            return Collections.emptyList();
        }
        ArrayList<ConfigurationModel> factoryInstances = new ArrayList<ConfigurationModel>();
        for (Configuration configuration : configurations) {
            ConfigurationModel curConfigurationModel = new ConfigurationModel(factoryConfigurationModel, configuration, factoryConfigurationModel.getBundleSymbolicName(), configuration.getBundleLocation(), false);
            factoryInstances.add(curConfigurationModel);
        }
        return factoryInstances;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    protected void collectConfigurationModels(Bundle bundle, Map<String, ConfigurationModel> configurationModels, boolean factory, String locale) {
        ExtendedMetaTypeInformation extendedMetaTypeInformation = this._extendedMetaTypeService.getMetaTypeInformation(bundle);
        if (extendedMetaTypeInformation == null) {
            return;
        }
        ArrayList pids = new ArrayList();
        if (factory) {
            Collections.addAll(pids, extendedMetaTypeInformation.getFactoryPids());
        } else {
            Collections.addAll(pids, extendedMetaTypeInformation.getPids());
        }
        for (String pid : pids) {
            ConfigurationModel configurationModel = this.getConfigurationModel(bundle, pid, factory, locale);
            if (configurationModel == null) continue;
            configurationModels.put(pid, configurationModel);
        }
    }

    protected Configuration getCompanyDefaultConfiguration(String factoryPid) {
        Object configuration = null;
        try {
            Object[] factoryConfigurations = this.getFactoryConfigurations(factoryPid, "companyId", "0");
            if (ArrayUtil.isNotEmpty((Object[])factoryConfigurations)) {
                configuration = factoryConfigurations[0];
            }
        }
        catch (IOException ioe) {
            ReflectionUtil.throwException((Throwable)ioe);
        }
        return configuration;
    }

    protected ConfigurationModel getConfigurationModel(Bundle bundle, String pid, boolean factory, String locale) {
        ExtendedMetaTypeInformation metaTypeInformation = this._extendedMetaTypeService.getMetaTypeInformation(bundle);
        if (metaTypeInformation == null) {
            return null;
        }
        ConfigurationModel configurationModel = new ConfigurationModel(metaTypeInformation.getObjectClassDefinition(pid, locale), this.getConfiguration(pid), bundle.getSymbolicName(), "?", factory);
        if (configurationModel.isCompanyFactory()) {
            Configuration configuration = this.getCompanyDefaultConfiguration(pid);
            configurationModel = new ConfigurationModel(configurationModel.getExtendedObjectClassDefinition(), configuration, bundle.getSymbolicName(), "?", configurationModel.isFactory());
        }
        return configurationModel;
    }

    protected Comparator<ConfigurationModel> getConfigurationModelComparator() {
        return new ConfigurationModelComparator();
    }

    protected Configuration[] getFactoryConfigurations(String factoryPid) throws IOException {
        return this.getFactoryConfigurations(factoryPid, null, null);
    }

    protected Configuration[] getFactoryConfigurations(String factoryPid, String property, String value) throws IOException {
        Configuration[] configurations = null;
        StringBundler sb = new StringBundler(13);
        if (Validator.isNotNull((String)property) && Validator.isNotNull((String)value)) {
            sb.append("(");
            sb.append("&");
        }
        sb.append("(");
        sb.append("service.factoryPid");
        sb.append("=");
        sb.append(factoryPid);
        sb.append(")");
        if (Validator.isNotNull((String)property) && Validator.isNotNull((String)value)) {
            sb.append("(");
            sb.append(property);
            sb.append("=");
            sb.append(value);
            sb.append(")");
            sb.append(")");
        }
        try {
            configurations = this._configurationAdmin.listConfigurations(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            ReflectionUtil.throwException((Throwable)ise);
        }
        return configurations;
    }

    protected String getPidFilterString(String pid, boolean factory) {
        StringBundler sb = new StringBundler(5);
        sb.append("(");
        if (factory) {
            sb.append("service.factoryPid");
        } else {
            sb.append("service.pid");
        }
        sb.append("=");
        sb.append(pid);
        sb.append(")");
        return sb.toString();
    }

    private static class ConfigurationModelComparator
    implements Comparator<ConfigurationModel> {
        private ConfigurationModelComparator() {
        }

        @Override
        public int compare(ConfigurationModel configurationModel1, ConfigurationModel configurationModel2) {
            String name1 = configurationModel1.getName();
            String name2 = configurationModel2.getName();
            return name1.compareTo(name2);
        }
    }
}

