/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.configuration.admin.web.internal.util;

import com.liferay.configuration.admin.category.ConfigurationCategory;
import com.liferay.configuration.admin.display.ConfigurationScreen;
import com.liferay.configuration.admin.web.internal.display.ConfigurationCategoryDisplay;
import com.liferay.configuration.admin.web.internal.display.ConfigurationCategoryMenuDisplay;
import com.liferay.configuration.admin.web.internal.display.ConfigurationCategorySectionDisplay;
import com.liferay.configuration.admin.web.internal.display.ConfigurationEntry;
import com.liferay.configuration.admin.web.internal.display.ConfigurationModelConfigurationEntry;
import com.liferay.configuration.admin.web.internal.display.ConfigurationScreenConfigurationEntry;
import com.liferay.configuration.admin.web.internal.model.ConfigurationModel;
import com.liferay.configuration.admin.web.internal.util.AdhocConfigurationCategory;
import com.liferay.configuration.admin.web.internal.util.ConfigurationEntryRetriever;
import com.liferay.configuration.admin.web.internal.util.ConfigurationModelRetriever;
import com.liferay.configuration.admin.web.internal.util.ResourceBundleLoaderProvider;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ConfigurationEntryRetriever.class})
public class ConfigurationEntryRetrieverImpl
implements ConfigurationEntryRetriever {
    private ServiceTrackerMap<String, List<ConfigurationCategory>> _configurationCategoriesServiceTrackerMap;
    private ServiceTrackerMap<String, ConfigurationCategory> _configurationCategoryServiceTrackerMap;
    @Reference
    private ConfigurationModelRetriever _configurationModelRetriever;
    private ServiceTrackerMap<String, ConfigurationScreen> _configurationScreenServiceTrackerMap;
    private ServiceTrackerMap<String, List<ConfigurationScreen>> _configurationScreensServiceTrackerMap;
    @Reference
    private ResourceBundleLoaderProvider _resourceBundleLoaderProvider;

    @Override
    public ConfigurationCategory getConfigurationCategory(String configurationCategoryKey) {
        return (ConfigurationCategory)this._configurationCategoryServiceTrackerMap.getService((Object)configurationCategoryKey);
    }

    @Override
    public ConfigurationCategoryMenuDisplay getConfigurationCategoryMenuDisplay(String configurationCategory, String languageId) {
        ConfigurationCategoryDisplay configurationCategoryDisplay = new ConfigurationCategoryDisplay(this.getConfigurationCategory(configurationCategory));
        return new ConfigurationCategoryMenuDisplay(configurationCategoryDisplay, this.getConfigurationEntries(configurationCategory, languageId));
    }

    @Override
    public List<ConfigurationCategorySectionDisplay> getConfigurationCategorySectionDisplays() {
        Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
        Map<String, ConfigurationModel> configurationModelsMap = this._configurationModelRetriever.getConfigurationModels(locale.getLanguage());
        Map<String, Set<ConfigurationModel>> categorizedConfigurationModels = this._configurationModelRetriever.categorizeConfigurationModels(configurationModelsMap);
        HashMap<String, ConfigurationCategorySectionDisplay> configurationCategorySectionDisplaysMap = new HashMap<String, ConfigurationCategorySectionDisplay>();
        for (String curConfigurationCategoryKey : categorizedConfigurationModels.keySet()) {
            ConfigurationCategorySectionDisplay configurationCategorySectionDisplay;
            ConfigurationCategory curConfigurationCategory = (ConfigurationCategory)this._configurationCategoryServiceTrackerMap.getService((Object)curConfigurationCategoryKey);
            if (curConfigurationCategory == null) {
                curConfigurationCategory = new AdhocConfigurationCategory(curConfigurationCategoryKey);
            }
            if ((configurationCategorySectionDisplay = (ConfigurationCategorySectionDisplay)configurationCategorySectionDisplaysMap.get(curConfigurationCategory.getCategorySection())) == null) {
                configurationCategorySectionDisplay = new ConfigurationCategorySectionDisplay(curConfigurationCategory.getCategorySection());
                configurationCategorySectionDisplaysMap.put(curConfigurationCategory.getCategorySection(), configurationCategorySectionDisplay);
            }
            ConfigurationCategoryDisplay configurationCategoryDisplay = new ConfigurationCategoryDisplay(curConfigurationCategory);
            configurationCategorySectionDisplay.add(configurationCategoryDisplay);
        }
        TreeSet<ConfigurationCategorySectionDisplay> configurationCategorySections = new TreeSet<ConfigurationCategorySectionDisplay>(new ConfigurationCategorySectionDisplayComparator());
        configurationCategorySections.addAll(configurationCategorySectionDisplaysMap.values());
        return new ArrayList<ConfigurationCategorySectionDisplay>(configurationCategorySections);
    }

    @Override
    public Set<ConfigurationEntry> getConfigurationEntries(String configurationCategory, String languageId) {
        TreeSet<ConfigurationEntry> configurationEntries = new TreeSet<ConfigurationEntry>(this.getConfigurationEntryComparator());
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        Set<ConfigurationModel> configurationModels = this._configurationModelRetriever.getConfigurationModels(configurationCategory, languageId);
        for (ConfigurationModel configurationModel : configurationModels) {
            if (!configurationModel.isGenerateUI()) continue;
            ConfigurationModelConfigurationEntry configurationEntry = new ConfigurationModelConfigurationEntry(configurationModel, locale, this._resourceBundleLoaderProvider);
            configurationEntries.add(configurationEntry);
        }
        Set<ConfigurationScreen> configurationScreens = this.getConfigurationScreens(configurationCategory);
        for (ConfigurationScreen configurationScreen : configurationScreens) {
            ConfigurationScreenConfigurationEntry configurationEntry = new ConfigurationScreenConfigurationEntry(configurationScreen, locale);
            configurationEntries.add(configurationEntry);
        }
        return configurationEntries;
    }

    @Override
    public ConfigurationScreen getConfigurationScreen(String configurationScreenKey) {
        return (ConfigurationScreen)this._configurationScreenServiceTrackerMap.getService((Object)configurationScreenKey);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._configurationCategoriesServiceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, ConfigurationCategory.class, null, (serviceReference, emitter) -> {
            ConfigurationCategory configurationCategory = (ConfigurationCategory)bundleContext.getService(serviceReference);
            emitter.emit((Object)configurationCategory.getCategorySection());
        });
        this._configurationCategoryServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ConfigurationCategory.class, null, (serviceReference, emitter) -> {
            ConfigurationCategory configurationCategory = (ConfigurationCategory)bundleContext.getService(serviceReference);
            emitter.emit((Object)configurationCategory.getCategoryKey());
        });
        this._configurationScreenServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ConfigurationScreen.class, null, (serviceReference, emitter) -> {
            ConfigurationScreen configurationScreen = (ConfigurationScreen)bundleContext.getService(serviceReference);
            emitter.emit((Object)configurationScreen.getKey());
        });
        this._configurationScreensServiceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, ConfigurationScreen.class, null, (serviceReference, emitter) -> {
            ConfigurationScreen configurationScreen = (ConfigurationScreen)bundleContext.getService(serviceReference);
            emitter.emit((Object)configurationScreen.getCategoryKey());
        });
    }

    protected Comparator<ConfigurationEntry> getConfigurationEntryComparator() {
        return new ConfigurationEntryComparator();
    }

    protected Set<ConfigurationScreen> getConfigurationScreens(String configurationCategoryKey) {
        Set<ConfigurationScreen> configurationCategoriesSet = Collections.emptySet();
        List configurationCategories = (List)this._configurationScreensServiceTrackerMap.getService((Object)configurationCategoryKey);
        if (configurationCategories != null) {
            configurationCategoriesSet = new HashSet<ConfigurationScreen>(configurationCategories);
        }
        return configurationCategoriesSet;
    }

    private static class ConfigurationEntryComparator
    implements Comparator<ConfigurationEntry> {
        private ConfigurationEntryComparator() {
        }

        @Override
        public int compare(ConfigurationEntry configurationEntry1, ConfigurationEntry configurationEntry2) {
            String key1 = configurationEntry1.getKey();
            String key2 = configurationEntry2.getKey();
            return key1.compareTo(key2);
        }
    }

    private static class ConfigurationCategorySectionDisplayComparator
    implements Comparator<ConfigurationCategorySectionDisplay> {
        private final List<String> _orderedConfigurationCategorySections = ListUtil.fromArray((Object[])new String[]{"content", "social", "commerce", "platform", "security"});

        private ConfigurationCategorySectionDisplayComparator() {
        }

        @Override
        public int compare(ConfigurationCategorySectionDisplay configurationCategorySectionDisplay1, ConfigurationCategorySectionDisplay configurationCategorySectionDisplay2) {
            String configurationCategorySection1 = configurationCategorySectionDisplay1.getConfigurationCategorySection();
            String configurationCategorySection2 = configurationCategorySectionDisplay2.getConfigurationCategorySection();
            int index1 = this._orderedConfigurationCategorySections.indexOf(configurationCategorySection1);
            int index2 = this._orderedConfigurationCategorySections.indexOf(configurationCategorySection2);
            if (index1 == -1 && index2 == -1) {
                return configurationCategorySection1.compareTo(configurationCategorySection2);
            }
            if (index1 == -1) {
                return 1;
            }
            if (index2 == -1) {
                return -1;
            }
            if (index1 > index2) {
                return 1;
            }
            if (index2 > index1) {
                return -1;
            }
            return configurationCategorySection1.compareTo(configurationCategorySection2);
        }
    }
}

