/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.comment.demo.data.creator.internal;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.comment.demo.data.creator.CommentDemoDataCreator;
import com.liferay.message.boards.exception.NoSuchMessageException;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.IdentityServiceContextFunction;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommentDemoDataCreator.class})
public class CommentDemoDataCreatorImpl
implements CommentDemoDataCreator {
    private static final Log _log = LogFactoryUtil.getLog(CommentDemoDataCreatorImpl.class);
    private static final List<String> _bodies = CommentDemoDataCreatorImpl._read("bodies");
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    private final List<Long> _commentIds = new CopyOnWriteArrayList<Long>();
    @Reference
    private CommentManager _commentManager;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public Comment create(long userId, ClassedModel classedModel) throws PortalException {
        User user = this._userLocalService.fetchUser(userId);
        String className = classedModel.getModelClassName();
        Long classPK = (long)((Long)classedModel.getPrimaryKeyObj());
        AssetEntry assetEntry = this._assetEntryLocalService.getEntry(className, classPK.longValue());
        Group group = this._groupLocalService.getGroup(assetEntry.getGroupId());
        IdentityServiceContextFunction identityServiceContextFunction = new IdentityServiceContextFunction(new ServiceContext());
        long commentId = this._commentManager.addComment(null, user.getUserId(), group.getGroupId(), className, classPK.longValue(), user.getFullName(), "", this._getRandomBody(), (Function)identityServiceContextFunction);
        return this._getComment(commentId);
    }

    public Comment create(long userId, long parentCommentId) throws PortalException {
        User user = this._userLocalService.fetchUser(userId);
        Comment parentComment = this._commentManager.fetchComment(parentCommentId);
        IdentityServiceContextFunction identityServiceContextFunction = new IdentityServiceContextFunction(new ServiceContext());
        long commentId = this._commentManager.addComment(null, userId, parentComment.getClassName(), parentComment.getClassPK(), user.getFullName(), parentCommentId, "", this._getRandomBody(), (Function)identityServiceContextFunction);
        return this._getComment(commentId);
    }

    public void delete() throws PortalException {
        for (long commentId : this._commentIds) {
            block3: {
                try {
                    this._commentManager.deleteComment(commentId);
                }
                catch (NoSuchMessageException noSuchMessageException) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Throwable)noSuchMessageException);
                }
            }
            this._commentIds.remove(commentId);
        }
    }

    private static List<String> _read(String fileName) {
        String content = StringUtil.read(CommentDemoDataCreatorImpl.class, (String)("dependencies/" + fileName + ".txt"));
        return Arrays.asList(StringUtil.split((String)content, (char)'\n'));
    }

    private Comment _getComment(long commentId) {
        this._commentIds.add(commentId);
        return this._commentManager.fetchComment(commentId);
    }

    private String _getRandomBody() {
        return _bodies.get(RandomUtil.nextInt((int)_bodies.size()));
    }
}

