/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.comment.apio.internal.architect.router.base;

import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.router.NestedCollectionRouter;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.comment.apio.architect.identifier.CommentIdentifier;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class BaseCommentNestedCollectionRouter<T extends Identifier<Long>>
implements NestedCollectionRouter<Comment, Long, CommentIdentifier, Long, T> {
    public NestedCollectionRoutes<Comment, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<Comment, Long, Long> builder) {
        return builder.addGetter(this::getPageItems, PermissionChecker.class).build();
    }

    protected void checkViewPermission(PermissionChecker permissionChecker, long groupId, String className, long classPK) throws PortalException {
        DiscussionPermission discussionPermission = this.getCommentManager().getDiscussionPermission(permissionChecker);
        discussionPermission.checkViewPermission(permissionChecker.getCompanyId(), groupId, className, classPK);
    }

    protected abstract CommentManager getCommentManager();

    protected abstract GroupedModel getGroupedModel(long var1) throws PortalException;

    protected PageItems<Comment> getPageItems(Pagination pagination, long classPK, PermissionChecker permissionChecker) throws PortalException {
        GroupedModel groupedModel = this.getGroupedModel(classPK);
        long resourcePrimKey = this.getResourcePrimKey(classPK);
        int count = this.getCommentManager().getRootCommentsCount(groupedModel.getModelClassName(), resourcePrimKey, 0);
        if (count == 0) {
            return new PageItems(Collections.emptyList(), 0);
        }
        this.checkViewPermission(permissionChecker, groupedModel.getGroupId(), groupedModel.getModelClassName(), classPK);
        List comments = this.getCommentManager().getRootComments(groupedModel.getModelClassName(), resourcePrimKey, 0, pagination.getStartPosition(), pagination.getEndPosition());
        return new PageItems((Collection)comments, count);
    }

    protected long getResourcePrimKey(long classPK) throws PortalException {
        return classPK;
    }
}

