/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.comment.apio.internal.architect.resource;

import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.comment.apio.architect.identifier.CommentIdentifier;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.NotFoundException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class CommentNestedCollectionResource
implements NestedCollectionResource<Comment, Long, CommentIdentifier, Long, CommentIdentifier> {
    @Reference
    private CommentManager _commentManager;

    public NestedCollectionRoutes<Comment, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<Comment, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems, PermissionChecker.class).build();
    }

    public String getName() {
        return "comment";
    }

    public ItemRoutes<Comment, Long> itemRoutes(ItemRoutes.Builder<Comment, Long> builder) {
        return builder.addGetter(this::_getComment, PermissionChecker.class).build();
    }

    public Representor<Comment> representor(Representor.Builder<Comment, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)builder.types("Comment", new String[0]).identifier(Comment::getCommentId).addLinkedModel("author", PersonIdentifier.class, Comment::getUserId)).addRelatedCollection("comments", CommentIdentifier.class).addString("text", Comment::getBody)).build();
    }

    private void _checkViewPermission(Comment comment, PermissionChecker permissionChecker) throws PortalException {
        if (comment == null) {
            throw new NotFoundException();
        }
        DiscussionPermission discussionPermission = this._commentManager.getDiscussionPermission(permissionChecker);
        discussionPermission.checkViewPermission(permissionChecker.getCompanyId(), comment.getGroupId(), comment.getClassName(), comment.getClassPK());
    }

    private Comment _getComment(long commentId, PermissionChecker permissionChecker) throws PortalException {
        Comment comment = this._commentManager.fetchComment(commentId);
        this._checkViewPermission(comment, permissionChecker);
        return comment;
    }

    private PageItems<Comment> _getPageItems(Pagination pagination, long parentCommentId, PermissionChecker permissionChecker) throws PortalException {
        Comment comment = this._commentManager.fetchComment(parentCommentId);
        this._checkViewPermission(comment, permissionChecker);
        List comments = this._commentManager.getChildComments(parentCommentId, 0, pagination.getStartPosition(), pagination.getEndPosition());
        int count = this._commentManager.getChildCommentsCount(parentCommentId, 0);
        return new PageItems((Collection)comments, count);
    }
}

