/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.util.spring.boot;

import java.time.Instant;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.core.OAuth2AccessToken;

@Configuration
public class LiferayOAuth2AccessTokenConfiguration {
    private static final Log _log = LogFactory.getLog(LiferayOAuth2AccessTokenConfiguration.class);
    @Autowired
    private AuthorizedClientServiceOAuth2AuthorizedClientManager _authorizedClientServiceOAuth2AuthorizedClientManager;
    @Autowired
    private Environment _environment;
    private OAuth2AccessToken _oAuth2AccessToken;

    public String getAuthorization() {
        OAuth2AccessToken oAuth2AccessToken = this.getOAuth2AccessToken();
        if (oAuth2AccessToken == null) {
            return null;
        }
        return this.getTokenType() + " " + this.getTokenValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth2AccessToken getOAuth2AccessToken() {
        Log log = _log;
        synchronized (log) {
            if (this._oAuth2AccessToken == null) {
                this._oAuth2AccessToken = this._getOAuth2AccessToken();
                return this._oAuth2AccessToken;
            }
            Instant instant = Instant.now();
            Instant expiresAtInstant = this._oAuth2AccessToken.getExpiresAt();
            if (expiresAtInstant == null || expiresAtInstant.isBefore(instant.minusSeconds(300L))) {
                this._oAuth2AccessToken = this._getOAuth2AccessToken();
            }
            return this._oAuth2AccessToken;
        }
    }

    public String getTokenType() {
        OAuth2AccessToken oAuth2AccessToken = this.getOAuth2AccessToken();
        if (oAuth2AccessToken == null) {
            return null;
        }
        OAuth2AccessToken.TokenType tokenType = oAuth2AccessToken.getTokenType();
        if (tokenType == null) {
            return null;
        }
        return tokenType.getValue();
    }

    public String getTokenValue() {
        OAuth2AccessToken oAuth2AccessToken = this.getOAuth2AccessToken();
        if (oAuth2AccessToken == null) {
            return null;
        }
        return oAuth2AccessToken.getTokenValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Log log = _log;
        synchronized (log) {
            this._oAuth2AccessToken = null;
            this._oAuth2AccessToken = this.getOAuth2AccessToken();
        }
    }

    private OAuth2AccessToken _getOAuth2AccessToken() {
        String liferayOauthApplicationExternalReferenceCodes = this._environment.getProperty("liferay.oauth.application.external.reference.codes");
        if (liferayOauthApplicationExternalReferenceCodes == null) {
            throw new IllegalArgumentException("Property \"liferay.oauth.application.external.reference.codes\" is not defined");
        }
        OAuth2AuthorizeRequest.Builder oAuth2AuthorizeRequestBuilder = OAuth2AuthorizeRequest.withClientRegistrationId((String)liferayOauthApplicationExternalReferenceCodes).principal(liferayOauthApplicationExternalReferenceCodes);
        OAuth2AuthorizedClient oAuth2AuthorizedClient = this._authorizedClientServiceOAuth2AuthorizedClientManager.authorize(oAuth2AuthorizeRequestBuilder.build());
        if (oAuth2AuthorizedClient == null) {
            _log.error((Object)"Unable to get OAuth 2 authorized client");
            return null;
        }
        OAuth2AccessToken oAuth2AccessToken = oAuth2AuthorizedClient.getAccessToken();
        if (oAuth2AccessToken == null) {
            _log.error((Object)"Unable to get OAuth 2 access token");
            return null;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Updated OAuth2 access token at " + oAuth2AccessToken.getIssuedAt()));
        }
        return oAuth2AccessToken;
    }
}

