/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.util.spring.boot;

import com.liferay.client.extension.util.spring.boot.LiferayOAuth2Util;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JWSAlgorithmFamilyJWSKeySelector;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTProcessor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
public class LiferayOAuth2ResourceServerEnableWebSecurity {
    private static final Log _log = LogFactory.getLog(LiferayOAuth2ResourceServerEnableWebSecurity.class);
    @Autowired
    private Environment _environment;
    @Value(value="${com.liferay.lxc.dxp.domains}")
    private String _lxcDXPDomains;
    @Value(value="${com.liferay.lxc.dxp.mainDomain}")
    private String _lxcDXPMainDomain;
    @Value(value="${com.liferay.lxc.dxp.server.protocol}")
    private String _lxcDXPServerProtocol;

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        UrlBasedCorsConfigurationSource urlBasedCorsConfigurationSource = new UrlBasedCorsConfigurationSource();
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.setAllowedHeaders(Arrays.asList("Authorization", "Content-Type"));
        corsConfiguration.setAllowedMethods(Arrays.asList("DELETE", "GET", "HEAD", "OPTIONS", "PATCH", "POST", "PUT"));
        corsConfiguration.setAllowedOrigins(this._getAllowedOrigins());
        urlBasedCorsConfigurationSource.registerCorsConfiguration("/**", corsConfiguration);
        return urlBasedCorsConfigurationSource;
    }

    @Bean
    public JwtDecoder jwtDecoder() throws Exception {
        String liferayOauthApplicationExternalReferenceCodes = this._environment.getProperty("liferay.oauth.application.external.reference.codes");
        if (liferayOauthApplicationExternalReferenceCodes == null) {
            throw new IllegalArgumentException("Property \"liferay.oauth.application.external.reference.codes\" is not defined");
        }
        DefaultJWTProcessor defaultJWTProcessor = new DefaultJWTProcessor();
        URL jwkSetURL = new URL(this._lxcDXPServerProtocol + "://" + this._lxcDXPMainDomain + "/o/oauth2/jwks");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Using " + jwkSetURL));
        }
        defaultJWTProcessor.setJWSKeySelector((JWSKeySelector)JWSAlgorithmFamilyJWSKeySelector.fromJWKSetURL((URL)jwkSetURL));
        defaultJWTProcessor.setJWSTypeVerifier((JOSEObjectTypeVerifier)new DefaultJOSEObjectTypeVerifier(new JOSEObjectType[]{new JOSEObjectType("at+jwt")}));
        NimbusJwtDecoder nimbusJwtDecoder = new NimbusJwtDecoder((JWTProcessor)defaultJWTProcessor);
        HashSet<String> clientIds = new HashSet<String>();
        for (String externalReferenceCode : liferayOauthApplicationExternalReferenceCodes.split(",")) {
            String clientId = this._environment.getProperty(externalReferenceCode + ".oauth2.user.agent.client.id");
            long timeout = TimeUnit.MINUTES.toMillis(5L);
            while (clientId == null && timeout > 0L) {
                clientId = LiferayOAuth2Util.getClientId(externalReferenceCode, this._lxcDXPMainDomain, this._lxcDXPServerProtocol);
                if (clientId != null) continue;
                long sleep = TimeUnit.SECONDS.toMillis(1L);
                Thread.sleep(sleep);
                timeout -= sleep;
            }
            clientIds.add(clientId);
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)("Using client ID " + clientId));
        }
        nimbusJwtDecoder.setJwtValidator((OAuth2TokenValidator)new DelegatingOAuth2TokenValidator(new OAuth2TokenValidator[]{new ClientIdOAuth2TokenValidator(clientIds)}));
        return nimbusJwtDecoder;
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity httpSecurity) throws Exception {
        return (SecurityFilterChain)((HttpSecurity)((HttpSecurity)((HttpSecurity)httpSecurity.cors().and()).csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.antMatchers(new String[]{"/ready"})).permitAll().anyRequest()).authenticated()).oauth2ResourceServer(OAuth2ResourceServerConfigurer::jwt).build();
    }

    private List<String> _getAllowedOrigins() {
        ArrayList<String> allowedOrigins = new ArrayList<String>();
        for (String lxcDXPDomain : this._lxcDXPDomains.split("\\s*[,\n]\\s*")) {
            allowedOrigins.add("http://" + lxcDXPDomain);
            allowedOrigins.add("https://" + lxcDXPDomain);
        }
        return allowedOrigins;
    }

    private class ClientIdOAuth2TokenValidator
    implements OAuth2TokenValidator<Jwt> {
        private final OAuth2Error _oAuth2Error = new OAuth2Error("invalid_token", "The client_id does not match", null);
        private final Set<String> _validClientIds;

        public OAuth2TokenValidatorResult validate(Jwt jwt) {
            String clientId = jwt.getClaimAsString("client_id");
            if (this._validClientIds.contains(clientId)) {
                return OAuth2TokenValidatorResult.success();
            }
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{this._oAuth2Error});
        }

        private ClientIdOAuth2TokenValidator(Set<String> validClientIds) {
            this._validClientIds = validClientIds;
        }
    }
}

