/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.client.extension.model.ClientExtensionEntryRel;
import com.liferay.client.extension.service.ClientExtensionEntryRelLocalService;
import com.liferay.client.extension.uad.constants.ClientExtensionUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseClientExtensionEntryRelUADAnonymizer
extends DynamicQueryUADAnonymizer<ClientExtensionEntryRel> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected ClientExtensionEntryRelLocalService clientExtensionEntryRelLocalService;

    public void autoAnonymize(ClientExtensionEntryRel clientExtensionEntryRel, long userId, User anonymousUser) throws PortalException {
        if (clientExtensionEntryRel.getUserId() == userId) {
            clientExtensionEntryRel.setUserId(anonymousUser.getUserId());
            clientExtensionEntryRel.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(clientExtensionEntryRel, anonymousUser);
        }
        this.clientExtensionEntryRelLocalService.updateClientExtensionEntryRel(clientExtensionEntryRel);
    }

    public void delete(ClientExtensionEntryRel clientExtensionEntryRel) throws PortalException {
        this.clientExtensionEntryRelLocalService.deleteClientExtensionEntryRel(clientExtensionEntryRel);
    }

    public Class<ClientExtensionEntryRel> getTypeClass() {
        return ClientExtensionEntryRel.class;
    }

    protected void autoAnonymizeAssetEntry(ClientExtensionEntryRel clientExtensionEntryRel, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(clientExtensionEntryRel);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.clientExtensionEntryRelLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return ClientExtensionUADConstants.USER_ID_FIELD_NAMES_CLIENT_EXTENSION_ENTRY_REL;
    }

    protected AssetEntry fetchAssetEntry(ClientExtensionEntryRel clientExtensionEntryRel) {
        return this.assetEntryLocalService.fetchEntry(ClientExtensionEntryRel.class.getName(), clientExtensionEntryRel.getClientExtensionEntryRelId());
    }
}

