/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.client.extension.model.ClientExtensionEntry;
import com.liferay.client.extension.service.ClientExtensionEntryLocalService;
import com.liferay.client.extension.uad.constants.ClientExtensionUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseClientExtensionEntryUADAnonymizer
extends DynamicQueryUADAnonymizer<ClientExtensionEntry> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected ClientExtensionEntryLocalService clientExtensionEntryLocalService;

    public void autoAnonymize(ClientExtensionEntry clientExtensionEntry, long userId, User anonymousUser) throws PortalException {
        if (clientExtensionEntry.getUserId() == userId) {
            clientExtensionEntry.setUserId(anonymousUser.getUserId());
            clientExtensionEntry.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(clientExtensionEntry, anonymousUser);
        }
        if (clientExtensionEntry.getStatusByUserId() == userId) {
            clientExtensionEntry.setStatusByUserId(anonymousUser.getUserId());
            clientExtensionEntry.setStatusByUserName(anonymousUser.getFullName());
        }
        this.clientExtensionEntryLocalService.updateClientExtensionEntry(clientExtensionEntry);
    }

    public void delete(ClientExtensionEntry clientExtensionEntry) throws PortalException {
        this.clientExtensionEntryLocalService.deleteClientExtensionEntry(clientExtensionEntry);
    }

    public Class<ClientExtensionEntry> getTypeClass() {
        return ClientExtensionEntry.class;
    }

    protected void autoAnonymizeAssetEntry(ClientExtensionEntry clientExtensionEntry, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(clientExtensionEntry);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.clientExtensionEntryLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return ClientExtensionUADConstants.USER_ID_FIELD_NAMES_CLIENT_EXTENSION_ENTRY;
    }

    protected AssetEntry fetchAssetEntry(ClientExtensionEntry clientExtensionEntry) {
        return this.assetEntryLocalService.fetchEntry(ClientExtensionEntry.class.getName(), clientExtensionEntry.getClientExtensionEntryId());
    }
}

