/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.client.extension.uad.exporter;

import com.liferay.client.extension.model.ClientExtensionEntryRel;
import com.liferay.client.extension.service.ClientExtensionEntryRelLocalService;
import com.liferay.client.extension.uad.constants.ClientExtensionUADConstants;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.user.associated.data.exporter.DynamicQueryUADExporter;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the client extension entry rel UAD exporter.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link ClientExtensionEntryRelUADExporter}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseClientExtensionEntryRelUADExporter
	extends DynamicQueryUADExporter<ClientExtensionEntryRel> {

	@Override
	public Class<ClientExtensionEntryRel> getTypeClass() {
		return ClientExtensionEntryRel.class;
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return clientExtensionEntryRelLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return ClientExtensionUADConstants.
			USER_ID_FIELD_NAMES_CLIENT_EXTENSION_ENTRY_REL;
	}

	@Override
	protected String toXmlString(
		ClientExtensionEntryRel clientExtensionEntryRel) {

		StringBundler sb = new StringBundler(13);

		sb.append("<model><model-name>");
		sb.append("com.liferay.client.extension.model.ClientExtensionEntryRel");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>clientExtensionEntryRelId</column-name><column-value><![CDATA[");
		sb.append(clientExtensionEntryRel.getClientExtensionEntryRelId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(clientExtensionEntryRel.getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(clientExtensionEntryRel.getUserName());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	@Reference
	protected ClientExtensionEntryRelLocalService
		clientExtensionEntryRelLocalService;

}